/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Test;
import org.mvel2.MVEL;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.compiler.ExpressionCompiler;

public class MvelCompileExpNullSafeTest {
    @Test
    public void testMvelCompileNullSafeNullFirst() {
        String expression = "((parentGroup != null) && ($.?child.firstName in parentGroup.parentList if  $.?child.firstName != null).size() > 0)";
        ExpressionCompiler compiler = new ExpressionCompiler(expression, true);
        CompiledExpression compiledExpression = compiler.compile();
        ParentGroup pGroup = new ParentGroup();
        ArrayList<Parent> list = new ArrayList<Parent>();
        Parent parent = new Parent();
        parent.setChild(null);
        list.add(parent);
        pGroup.setParentList(list);
        Boolean result = (Boolean)MVEL.executeExpression((Object)compiledExpression, Collections.singletonMap("parentGroup", pGroup));
        assert (!result.booleanValue());
        Child child = new Child();
        child.setFirstName("vlaa");
        pGroup = new ParentGroup();
        list = new ArrayList();
        parent = new Parent();
        parent.setChild(child);
        list.add(parent);
        child = new Child();
        child.setFirstName(null);
        parent = new Parent();
        parent.setChild(child);
        list.add(parent);
        pGroup.setParentList(list);
        result = (Boolean)MVEL.executeExpression((Object)compiledExpression, Collections.singletonMap("parentGroup", pGroup));
        assert (result.booleanValue());
    }

    @Test
    public void testMvelCompileNullSafeNullSecond() {
        String expression = "((parentGroup != null) && ($.?child.firstName in parentGroup.parentList if  $.?child.firstName != null).size() > 0)";
        ExpressionCompiler compiler = new ExpressionCompiler(expression, true);
        CompiledExpression compiledExpression = compiler.compile();
        Child child = new Child();
        child.setFirstName("vlaa");
        ParentGroup pGroup = new ParentGroup();
        ArrayList<Parent> list = new ArrayList<Parent>();
        Parent parent = new Parent();
        parent.setChild(child);
        list.add(parent);
        child = new Child();
        child.setFirstName(null);
        parent = new Parent();
        parent.setChild(child);
        list.add(parent);
        pGroup.setParentList(list);
        Boolean result = (Boolean)MVEL.executeExpression((Object)compiledExpression, Collections.singletonMap("parentGroup", pGroup));
        assert (result.booleanValue());
        pGroup = new ParentGroup();
        list = new ArrayList();
        parent = new Parent();
        parent.setChild(null);
        list.add(parent);
        pGroup.setParentList(list);
        result = (Boolean)MVEL.executeExpression((Object)compiledExpression, Collections.singletonMap("parentGroup", pGroup));
        assert (!result.booleanValue());
    }

    public class ParentGroup {
        private List<Parent> parentList;

        public List<Parent> getParentList() {
            return this.parentList;
        }

        public void setParentList(List<Parent> parentList) {
            this.parentList = parentList;
        }
    }

    public class Parent {
        private Child child;

        public Child getChild() {
            return this.child;
        }

        public void setChild(Child child) {
            this.child = child;
        }
    }

    public class Child {
        private String firstName;
        private String lastName;

        public String getFirstName() {
            return this.firstName;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }
    }
}

