/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.tests.core;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.mvel2.CompileException;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.optimizers.OptimizerFactory;
import org.mvel2.tests.core.AbstractTest;

public class FailureTests
extends AbstractTest {
    public void shouldThrowException() {
        FailureTests.fail((String)"should have thrown exception, but didn't");
    }

    public void testBadParserConstruct() {
        try {
            MVEL.eval((String)"a = 0; a =+++ 5;");
        }
        catch (RuntimeException e) {
            return;
        }
        this.shouldThrowException();
    }

    public void testShouldFail() {
        try {
            MVEL.eval((String)"i = 0; i < 99 dksadlka", new HashMap());
        }
        catch (Exception e) {
            return;
        }
        this.shouldThrowException();
    }

    public void testShouldFail2() {
        try {
            MVEL.compileExpression((String)"i = 0; i < 99 dksadlka");
        }
        catch (Exception e) {
            return;
        }
        this.shouldThrowException();
    }

    public void testShouldFail3() {
        try {
            MVEL.compileExpression((String)"def foo() { 'bar' }; foo(123);");
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.shouldThrowException();
    }

    public void testShouldFail4() {
        try {
            MVEL.eval((String)"hour zzz", (Map)FailureTests.createTestMap());
        }
        catch (Exception e) {
            return;
        }
        this.shouldThrowException();
    }

    public void testShouldFail5() {
        try {
            MVEL.eval((String)"[");
        }
        catch (Exception e) {
            return;
        }
        this.shouldThrowException();
    }

    public void testShouldFail6() {
        try {
            ParserContext pctx = new ParserContext();
            pctx.setStrongTyping(true);
            MVEL.compileExpression((String)"new int[] {1.5}", (ParserContext)pctx);
        }
        catch (Exception e) {
            return;
        }
        this.shouldThrowException();
    }

    public void testShouldFail7() {
        try {
            ParserContext pctx = new ParserContext();
            pctx.setStrongTyping(true);
            MVEL.compileExpression((String)"String x = 'foo'; int y = 2; new int[] { x, y }", (ParserContext)pctx);
        }
        catch (Exception e) {
            return;
        }
        this.shouldThrowException();
    }

    public void testShouldFail8() {
        try {
            ParserContext pCtx = new ParserContext();
            pCtx.setStrongTyping(true);
            MVEL.compileExpression((String)"for (String s : new java.util.HashMap()) { }", (ParserContext)pCtx);
        }
        catch (Exception e) {
            return;
        }
        this.shouldThrowException();
    }

    public void testShouldFail9() {
        try {
            MVEL.compileExpression((String)"foo = ", new HashMap());
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.shouldThrowException();
    }

    public void testShouldFail10() {
        try {
            MVEL.compileExpression((String)"foo = [1,1,qq,zz]", (ParserContext)ParserContext.create().stronglyTyped());
        }
        catch (CompileException e) {
            e.printStackTrace();
            return;
        }
        this.shouldThrowException();
    }

    public void testShouldFailCleanly() {
        try {
            MVEL.eval((String)"6:f-\t\nr:wsGbL%X5&wb<C.8n(\n1X-;zUX-L<%<TG)S#z1fh69:tn`#eH9XneL8XFIB94-z*XzQ-RPhX{&bbp{fLDe@`3<-\tZp9_k*Xo\tDy36t15XX>-75EArR]6`**<kw}P<FpD-+XA-<+K!\nRb9n)zA-<L9pIIbHb?!b-bO%n<zLFqzbmm-n#~-zL`5Fq_PYD+9`NPt4Tnt\tvT-L[d\n<b<9l9XV9-9 X9h7#9Ln?FnnLXLkg5<V-Z%bb-n&Et<B-X[n\"jbvg&@b{X0?*9eC{%zU\nL\t{RPX\tbwhY&L`z<`Oh`<8pH\nb:y:#H-;&,PzXw\ttHicFbs");
        }
        catch (CompileException e) {
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            FailureTests.fail((String)"Unclean failure");
        }
    }

    public void testShouldFail11() {
        try {
            MVEL.eval((String)"for (int i = 0; i--; i++) {}");
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.shouldThrowException();
    }

    public void testShouldFail12() {
        try {
            MVEL.eval((String)"def x(_");
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public void testErrorUtilShouldNotThrowNPE() {
        try {
            OptimizerFactory.setDefaultOptimizer((String)OptimizerFactory.SAFE_REFLECTIVE);
            Serializable compiledExpression = MVEL.compileExpression((String)"new org.mvel2.tests.core.FailureTests$Person()");
            MVEL.executeExpression((Object)compiledExpression);
            FailureTests.fail((String)"Should throw CompileException");
        }
        catch (CompileException ce) {
            FailureTests.assertTrue((boolean)ce.getMessage().contains("unable to find constructor"));
        }
        catch (NullPointerException npe) {
            FailureTests.fail((String)"Should not throw NullPointerException");
        }
        finally {
            OptimizerFactory.setDefaultOptimizer((String)OptimizerFactory.DYNAMIC);
        }
    }

    public static class Person {
        private String name;

        public Person(String name) {
            this.name = name;
        }
    }
}

