/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.tests.perftests;

import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;
import org.mvel2.MVEL;
import org.mvel2.optimizers.OptimizerFactory;
import org.mvel2.tests.BaseMvelTestCase;

public class ConcurrentEvaluationTests
extends BaseMvelTestCase {
    Serializable expression = MVEL.compileExpression((String)"Thread.sleep(2000)");

    @Test(timeout=10000L)
    public void testReflective() throws Exception {
        OptimizerFactory.setDefaultOptimizer((String)OptimizerFactory.SAFE_REFLECTIVE);
        this.internalConcurrentEvaluation();
    }

    @Test(timeout=10000L)
    public void testDynamic() throws Exception {
        OptimizerFactory.setDefaultOptimizer((String)OptimizerFactory.DYNAMIC);
        this.internalConcurrentEvaluation();
    }

    @Test(timeout=10000L)
    public void testASM() throws Exception {
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        this.internalConcurrentEvaluation();
    }

    private void internalConcurrentEvaluation() throws Exception {
        int N = 20;
        final CountDownLatch start = new CountDownLatch(1);
        final CountDownLatch end = new CountDownLatch(20);
        final AtomicInteger errors = new AtomicInteger(0);
        for (int i = 0; i < 20; ++i) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        start.await();
                        MVEL.executeExpression((Object)ConcurrentEvaluationTests.this.expression);
                    }
                    catch (Exception e) {
                        errors.incrementAndGet();
                    }
                    finally {
                        end.countDown();
                    }
                }
            }, "thread-eval-" + i).start();
        }
        start.countDown();
        ConcurrentEvaluationTests.assertEquals((String)"Test did not complete withing 10s", (boolean)true, (boolean)end.await(10L, TimeUnit.SECONDS));
        if (errors.get() > 0) {
            ConcurrentEvaluationTests.fail();
        }
    }
}

