/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.tests.templates;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mvel2.CompileException;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.MapVariableResolverFactory;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.SimpleTemplateRegistry;
import org.mvel2.templates.TemplateCompiler;
import org.mvel2.templates.TemplateRegistry;
import org.mvel2.templates.TemplateRuntime;
import org.mvel2.tests.BaseMvelTestCase;
import org.mvel2.tests.core.CoreConfidenceTests;
import org.mvel2.tests.core.res.Bar;
import org.mvel2.tests.core.res.Base;
import org.mvel2.tests.core.res.Foo;
import org.mvel2.tests.core.res.TestMVEL197;
import org.mvel2.tests.templates.tests.res.TestPluginNode;

public class TemplateTests
extends BaseMvelTestCase {
    private Map<String, Object> map = new HashMap<String, Object>();
    private VariableResolverFactory vrf = new MapVariableResolverFactory(this.map);
    private Foo foo = new Foo();
    private Base base = new Base();
    String[] testCasesMVEL220 = new String[]{"map[\"foundIt\"] = !(map['list'].contains(\"john\"))"};
    String[] templateTestCasesMVEL220 = new String[]{"@{map[\"foundIt\"] = !(map['list']).contains(\"john\")}", "@{map[\"foundIt\"] = !(map['list'].contains(\"john\"))}"};
    String[] testCasesMVEL219 = new String[]{"map['foo']==map['foo']", "(map['one'] > 0)", "(map['one'] > 0) && (map['foo'] == map['foo'])", "(map['one'] > 0) && (map['foo']==map['foo'])"};
    String[] templateTestCasesMVEL219 = new String[]{"@{map['foo']==map['foo']}", "@(map['one'] > 0)}", "@{(map['one'] > 0) && (map['foo'] == map['foo'])}", "@{(map['one'] > 0) && (map['foo']==map['foo'])}"};

    public TemplateTests() {
        this.map.put("_foo_", "Foo");
        this.map.put("_bar_", "Bar");
        ArrayList<String> list = new ArrayList<String>(3);
        list.add("Jane");
        list.add("John");
        list.add("Foo");
        this.map.put("arrayList", list);
        this.foo.setBar(new Bar());
        this.map.put("foo", this.foo);
        this.map.put("a", null);
        this.map.put("b", null);
        this.map.put("c", "cat");
        this.map.put("BWAH", "");
        this.map.put("pi", "3.14");
        this.map.put("hour", "60");
        this.map.put("zero", 0);
        this.map.put("doubleTen", new Double(10.0));
        this.map.put("variable_with_underscore", "HELLO");
        this.map.put("testImpl", new TestInterface(){

            @Override
            public String getName() {
                return "FOOBAR!";
            }

            @Override
            public boolean isFoo() {
                return true;
            }
        });
    }

    public Object test(String template) {
        CompiledTemplate compiled = TemplateCompiler.compileTemplate((String)template);
        return TemplateRuntime.execute((CompiledTemplate)compiled, (Object)this.base, (VariableResolverFactory)this.vrf);
    }

    public void testPassThru() {
        String s = "foobar!";
        TemplateTests.assertEquals((Object)"foobar!", (Object)this.test(s));
    }

    public void testBasicParsing() {
        String s = "foo: @{_foo_}--@{_bar_}!";
        TemplateTests.assertEquals((Object)"foo: Foo--Bar!", (Object)this.test(s));
    }

    public void testIfStatement() {
        String s = "@if{_foo_=='Foo'}Hello@end{}";
        TemplateTests.assertEquals((Object)"Hello", (Object)this.test(s));
    }

    public void testIfStatement2() {
        String s = "@if{_foo_=='Bar'}Hello@else{_foo_=='Foo'}Goodbye@end{}";
        TemplateTests.assertEquals((Object)"Goodbye", (Object)this.test(s));
    }

    public void testIfStatement3() {
        String s = "@if{_foo_=='Bar'}Hello@else{_foo_=='foo'}Goodbye@else{}Nope@end{}";
        TemplateTests.assertEquals((Object)"Nope", (Object)this.test(s));
    }

    public void testIfStatement4() {
        String s = "@if{_foo_=='Foo'}Hello@else{_foo_=='foo'}Goodbye@else{}Nope@end{}End";
        TemplateTests.assertEquals((Object)"HelloEnd", (Object)this.test(s));
    }

    public void testIfStatement5() {
        String s = "@if{_foo_=='foo'}Hello@end{}Goodbye";
        TemplateTests.assertEquals((Object)"Goodbye", (Object)this.test(s));
    }

    public void testIfNesting() {
        String s = "@if{_foo_=='Foo'}Hello@if{_bar_=='Bar'}Bar@end{}@else{_foo_=='foo'}Goodbye@else{}Nope@end{}";
        TemplateTests.assertEquals((Object)"HelloBar", (Object)this.test(s));
    }

    public void testForEach() {
        String s = "List:@foreach{item : arrayList}@{item}@end{}";
        TemplateTests.assertEquals((Object)"List:JaneJohnFoo", (Object)this.test(s));
    }

    public void testForEachMulti() {
        String s = "Multi:@foreach{item : arrayList, item2 : arrayList}@{item}-@{item2}@end{','}:Multi";
        TemplateTests.assertEquals((Object)"Multi:Jane-Jane,John-John,Foo-Foo:Multi", (Object)this.test(s));
    }

    public void testComplexTemplate() {
        String s = "@foreach{item : arrayList}@if{item[0] == 'J'}@{item}@end{}@end{}";
        TemplateTests.assertEquals((Object)"JaneJohn", (Object)this.test(s));
    }

    public void testFileBasedEval() {
        TemplateTests.assertEquals((Object)"Foo::Bar", (Object)TemplateRuntime.eval((File)new File("src/test/java/org/mvel2/tests/templates/templateTest.mv"), (Object)this.base, (VariableResolverFactory)new MapVariableResolverFactory(this.map), null));
    }

    public void testInclusionOfTemplateFile() {
        String s = "<<@include{'src/test/java/org/mvel2/tests/templates/templateTest.mv'}>>";
        TemplateTests.assertEquals((Object)"<<Foo::Bar>>", (Object)this.test(s));
    }

    public void testInclusionOfTemplateFile2() {
        String s = "<<@include{'src/test/java/org/mvel2/tests/templates/templateError.mv'}>>";
        try {
            this.test(s);
        }
        catch (CompileException e) {
            System.out.println(e.toString());
            return;
        }
        TemplateTests.assertTrue((boolean)false);
    }

    public void testForEachException1() {
        String s = "<<@foreach{arrayList}@{item}@end{}>>";
        try {
            this.test(s);
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return;
        }
        TemplateTests.assertTrue((boolean)false);
    }

    public void testForEachException2() {
        String s = "<<@foreach{item:arrayList}@{item}>>";
        try {
            this.test(s);
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return;
        }
        TemplateTests.assertTrue((boolean)false);
    }

    public void testTemplateFile() {
        String s = (String)TemplateRuntime.eval((File)new File("src/test/java/org/mvel2/tests/templates/templateIfTest.mv"), (Object)this.base, (VariableResolverFactory)new MapVariableResolverFactory(this.map), null);
        System.out.println(s);
    }

    public void testInclusionOfNamedTemplate() {
        SimpleTemplateRegistry registry = new SimpleTemplateRegistry();
        registry.addNamedTemplate("footemplate", TemplateCompiler.compileTemplate((String)"@{_foo_}@{_bar_}"));
        registry.addNamedTemplate("bartemplate", TemplateCompiler.compileTemplate((String)"@{_bar_}@{_foo_}"));
        String s = "@includeNamed{'footemplate'}  ::  @includeNamed{'bartemplate'}";
        TemplateTests.assertEquals((Object)"FooBar  ::  BarFoo", (Object)TemplateRuntime.eval((String)s, this.map, (TemplateRegistry)registry));
    }

    public void testExpressions() {
        String s = "@{_foo_.length()}";
        Object r = this.test(s);
        TemplateTests.assertEquals((Object)3, (Object)r);
    }

    public void testCode() {
        String s = "@code{a = 'foo'; b = 'bar'}@{a}@{b}";
        TemplateTests.assertEquals((Object)"foobar", (Object)this.test(s));
    }

    public void testInlineDeclarations() {
        String s = "@declare{'fudge'}Hello @{name}!@end{}@includeNamed{'fudge'; name='John'} -- @includeNamed{'fudge'; name='Mary'}";
        TemplateTests.assertEquals((Object)"Hello John! -- Hello Mary!", (Object)this.test(s));
    }

    public void testInlineDeclarations2() {
        String s = "@declare{'fudge'}Hello @{name}!@end{}@code{toInclude='fudge'}@includeNamed{toInclude; name='John'} -- @includeNamed{toInclude; name='Mary'}";
        TemplateTests.assertEquals((Object)"Hello John! -- Hello Mary!", (Object)this.test(s));
    }

    public void testPluginNode() {
        HashMap<String, Class<TestPluginNode>> plugins = new HashMap<String, Class<TestPluginNode>>();
        plugins.put("testNode", TestPluginNode.class);
        TemplateCompiler compiler = new TemplateCompiler("Foo:@testNode{}!!", plugins);
        CompiledTemplate compiled = compiler.compile();
        TemplateTests.assertEquals((Object)"Foo:THIS_IS_A_TEST!!", (Object)TemplateRuntime.execute((CompiledTemplate)compiled));
    }

    public void testComments() {
        TemplateTests.assertEquals((Object)"Foo", (Object)this.test("@comment{ This section is commented }@{_foo_}"));
    }

    public void testPassThru2() {
        TemplateTests.assertEquals((Object)"foo@bar.com", (Object)TemplateRuntime.eval((String)"foo@bar.com", this.map));
    }

    public void testMethodOnValue() {
        TemplateTests.assertEquals((Object)"DOG", (Object)this.test("@{foo.bar.name.toUpperCase()}"));
    }

    public void testSimpleProperty() {
        TemplateTests.assertEquals((Object)"dog", (Object)this.test("@{foo.bar.name}"));
    }

    public void testBooleanOperator() {
        TemplateTests.assertEquals((Object)true, (Object)this.test("@{foo.bar.woof == true}"));
    }

    public void testBooleanOperator2() {
        TemplateTests.assertEquals((Object)false, (Object)this.test("@{foo.bar.woof == false}"));
    }

    public void testTextComparison() {
        TemplateTests.assertEquals((Object)true, (Object)this.test("@{foo.bar.name == 'dog'}"));
    }

    public void testNETextComparison() {
        TemplateTests.assertEquals((Object)true, (Object)this.test("@{foo.bar.name != 'foo'}"));
    }

    public void testChor() {
        TemplateTests.assertEquals((Object)"cat", (Object)this.test("@{a or b or c}"));
    }

    public void testChorWithLiteral() {
        TemplateTests.assertEquals((Object)"fubar", (Object)this.test("@{a or 'fubar'}"));
    }

    public void testNullCompare() {
        TemplateTests.assertEquals((Object)true, (Object)this.test("@{c != null}"));
    }

    public void testAnd() {
        TemplateTests.assertEquals((Object)true, (Object)this.test("@{c != null && foo.bar.name == 'dog' && foo.bar.woof}"));
    }

    public void testMath() {
        TemplateTests.assertEquals((Object)188.4, (Object)this.test("@{pi * hour}"));
    }

    public void testTemplating() {
        TemplateTests.assertEquals((Object)"dogDOGGIE133.5", (Object)this.test("@{foo.bar.name}DOGGIE@{hour*2.225+1-1}"));
    }

    public void testComplexAnd() {
        TemplateTests.assertEquals((Object)true, (Object)this.test("@{(pi * hour) > 0 && foo.happy() == 'happyBar'}"));
    }

    public void testModulus() {
        TemplateTests.assertEquals((Object)0, (Object)this.test("@{38392 % 2}"));
    }

    public void testLessThan() {
        TemplateTests.assertEquals((Object)true, (Object)this.test("@{pi < 3.15}"));
        TemplateTests.assertEquals((Object)true, (Object)this.test("@{pi <= 3.14}"));
        TemplateTests.assertEquals((Object)false, (Object)this.test("@{pi > 3.14}"));
        TemplateTests.assertEquals((Object)true, (Object)this.test("@{pi >= 3.14}"));
    }

    public void testMethodAccess() {
        TemplateTests.assertEquals((Object)"happyBar", (Object)this.test("@{foo.happy()}"));
    }

    public void testMethodAccess2() {
        TemplateTests.assertEquals((Object)"FUBAR", (Object)this.test("@{foo.toUC('fubar')}"));
    }

    public void testMethodAccess3() {
        TemplateTests.assertEquals((Object)true, (Object)this.test("@{equalityCheck(c, 'cat')}"));
    }

    public void testMethodAccess4() {
        TemplateTests.assertEquals(null, (Object)this.test("@{readBack(null)}"));
    }

    public void testMethodAccess5() {
        TemplateTests.assertEquals((Object)"nulltest", (Object)this.test("@{appendTwoStrings(null, 'test')}"));
    }

    public void testMethodAccess6() {
        TemplateTests.assertEquals((Object)false, (Object)this.test("@{!foo.bar.isWoof()}"));
    }

    public void testNegation() {
        TemplateTests.assertEquals((Object)true, (Object)this.test("@{!fun && !fun}"));
    }

    public void testNegation2() {
        TemplateTests.assertEquals((Object)false, (Object)this.test("@{fun && !fun}"));
    }

    public void testNegation3() {
        TemplateTests.assertEquals((Object)true, (Object)this.test("@{!(fun && fun)}"));
    }

    public void testNegation4() {
        TemplateTests.assertEquals((Object)false, (Object)this.test("@{(fun && fun)}"));
    }

    public void testMultiStatement() {
        TemplateTests.assertEquals((Object)true, (Object)this.test("@{populate(); barfoo == 'sarah'}"));
    }

    public void testAssignment2() {
        TemplateTests.assertEquals((Object)"sarah", (Object)this.test("@{populate(); blahfoo = barfoo}"));
    }

    public void testOr() {
        TemplateTests.assertEquals((Object)true, (Object)this.test("@{fun || true}"));
    }

    public void testLiteralPassThrough() {
        TemplateTests.assertEquals((Object)true, (Object)this.test("@{true}"));
    }

    public void testLiteralPassThrough2() {
        TemplateTests.assertEquals((Object)false, (Object)this.test("@{false}"));
    }

    public void testLiteralPassThrough3() {
        TemplateTests.assertEquals(null, (Object)this.test("@{null}"));
    }

    public void testControlLoopList() {
        TemplateTests.assertEquals((Object)"HappyHappy!JoyJoy!", (Object)this.test("@foreach{item : list}@{item}@end{}"));
    }

    public void testControlLoopArray() {
        TemplateTests.assertEquals((Object)"Happy0Happy!1Joy2Joy!3", (Object)this.test("@code{i=0}@foreach{item : array}@{item}@{i++}@end{}"));
    }

    public void testMultiCollectionControlLoop() {
        TemplateTests.assertEquals((Object)"0=Happy:Happy,1=Happy!:Happy!,2=Joy:Joy,3=Joy!:Joy!", (Object)this.test("@code{i=0}@foreach{item : list, listItem : array}@{i++}=@{item}:@{listItem}@end{','}"));
    }

    public void testControlLoopListMultiple() {
        for (int i = 0; i < 100; ++i) {
            this.testControlLoopList();
        }
    }

    public void testControlLoopArrayMultiple() {
        for (int i = 0; i < 100; ++i) {
            this.testControlLoopArray();
        }
    }

    public void testControlLoop2() {
        TemplateTests.assertEquals((Object)"HappyHappy!JoyJoy!", (Object)this.test("@foreach{item : list}@{item}@end{}"));
    }

    public void testControlLoop3() {
        TemplateTests.assertEquals((Object)"HappyHappy!JoyJoy!", (Object)this.test("@foreach{item : list }@{item}@end{}"));
    }

    public void testIfStatement6() {
        TemplateTests.assertEquals((Object)"sarah", (Object)this.test("@if{'fun' == 'fun'}sarah@end{}"));
    }

    public void testIfStatement7() {
        TemplateTests.assertEquals((Object)"poo", (Object)this.test("@if{'fun' == 'bar'}sarah@else{}poo@end{}"));
    }

    public void testRegEx() {
        TemplateTests.assertEquals((Object)true, (Object)this.test("@{foo.bar.name ~= '[a-z].+'}"));
    }

    public void testRegExNegate() {
        TemplateTests.assertEquals((Object)false, (Object)this.test("@{!(foo.bar.name ~= '[a-z].+')}"));
    }

    public void testRegEx2() {
        TemplateTests.assertEquals((Object)true, (Object)this.test("@{foo.bar.name ~= '[a-z].+' && foo.bar.name != null}"));
    }

    public void testBlank() {
        TemplateTests.assertEquals((Object)true, (Object)this.test("@{'' == empty}"));
    }

    public void testBlank2() {
        TemplateTests.assertEquals((Object)true, (Object)this.test("@{BWAH == empty}"));
    }

    public void testTernary() {
        TemplateTests.assertEquals((Object)"foobie", (Object)this.test("@{zero==0?'foobie':zero}"));
    }

    public void testTernary2() {
        TemplateTests.assertEquals((Object)"blimpie", (Object)this.test("@{zero==1?'foobie':'blimpie'}"));
    }

    public void testTernary3() {
        TemplateTests.assertEquals((Object)"foobiebarbie", (Object)this.test("@{zero==1?'foobie':'foobie'+'barbie'}"));
    }

    public void testTernary4() {
        TemplateTests.assertEquals((Object)"no", (Object)this.test("@{ackbar ? 'yes' : 'no'}"));
    }

    public void testStrAppend() {
        TemplateTests.assertEquals((Object)"foobarcar", (Object)this.test("@{'foo' + 'bar' + 'car'}"));
    }

    public void testStrAppend2() {
        TemplateTests.assertEquals((Object)"foobarcar1", (Object)this.test("@{'foobar' + 'car' + 1}"));
    }

    public void testInstanceCheck1() {
        TemplateTests.assertEquals((Object)true, (Object)this.test("@{c is java.lang.String}"));
    }

    public void testInstanceCheck2() {
        TemplateTests.assertEquals((Object)false, (Object)this.test("@{pi is java.lang.Integer}"));
    }

    public void testBitwiseOr1() {
        TemplateTests.assertEquals((Object)6, (Object)this.test("@{2 | 4}"));
    }

    public void testBitwiseOr2() {
        TemplateTests.assertEquals((Object)true, (Object)this.test("@{(2 | 1) > 0}"));
    }

    public void testBitwiseOr3() {
        TemplateTests.assertEquals((Object)true, (Object)this.test("@{(2 | 1) == 3}"));
    }

    public void testBitwiseAnd1() {
        TemplateTests.assertEquals((Object)2, (Object)this.test("@{2 & 3}"));
    }

    public void testShiftLeft() {
        TemplateTests.assertEquals((Object)4, (Object)this.test("@{2 << 1}"));
    }

    public void testUnsignedShiftLeft() {
        TemplateTests.assertEquals((Object)2, (Object)this.test("@{-2 <<< 0}"));
    }

    public void testShiftRight() {
        TemplateTests.assertEquals((Object)128, (Object)this.test("@{256 >> 1}"));
    }

    public void testXOR() {
        TemplateTests.assertEquals((Object)3, (Object)this.test("@{1 ^ 2}"));
    }

    public void testContains1() {
        TemplateTests.assertEquals((Object)true, (Object)this.test("@{list contains 'Happy!'}"));
    }

    public void testContains2() {
        TemplateTests.assertEquals((Object)false, (Object)this.test("@{list contains 'Foobie'}"));
    }

    public void testContains3() {
        TemplateTests.assertEquals((Object)true, (Object)this.test("@{sentence contains 'fox'}"));
    }

    public void testContains4() {
        TemplateTests.assertEquals((Object)false, (Object)this.test("@{sentence contains 'mike'}"));
    }

    public void testContains5() {
        TemplateTests.assertEquals((Object)true, (Object)this.test("@{!(sentence contains 'mike')}"));
    }

    public void testTokenMethodAccess() {
        TemplateTests.assertEquals(String.class, (Object)this.test("@{a = 'foo'; a.getClass()}"));
    }

    public void testArrayCreationWithLength() {
        TemplateTests.assertEquals((Object)2, (Object)this.test("@{Array.getLength({'foo', 'bar'})}"));
    }

    public void testMapCreation() {
        TemplateTests.assertEquals((Object)"sarah", (Object)this.test("@{map = ['mike':'sarah','tom':'jacquelin']; map['mike']}"));
    }

    public void testProjectionSupport() {
        TemplateTests.assertEquals((Object)true, (Object)this.test("@{(name in things) contains 'Bob'}"));
    }

    public void testProjectionSupport2() {
        TemplateTests.assertEquals((Object)3, (Object)this.test("@{(name in things).size()}"));
    }

    public void testObjectInstantiation() {
        TemplateTests.assertEquals((Object)"foobie", (Object)this.test("@{new java.lang.String('foobie')}"));
    }

    public void testObjectInstantiationWithMethodCall() {
        TemplateTests.assertEquals((Object)"foobie", (Object)this.test("@{new String('foobie').toString()}"));
    }

    public void testObjectInstantiation2() {
        this.test("@{new String() is String}");
    }

    public void testArrayCoercion() {
        TemplateTests.assertEquals((Object)"gonk", (Object)this.test("@{funMethod( {'gonk', 'foo'} )}"));
    }

    public void testMapAccess() {
        TemplateTests.assertEquals((Object)"dog", (Object)this.test("@{funMap['foo'].bar.name}"));
    }

    public void testMapAccess2() {
        TemplateTests.assertEquals((Object)"dog", (Object)this.test("@{funMap.foo.bar.name}"));
    }

    public void testSoundex() {
        TemplateTests.assertTrue((boolean)((Boolean)this.test("@{'foobar' soundslike 'fubar'}")));
    }

    public void testSoundex2() {
        TemplateTests.assertFalse((boolean)((Boolean)this.test("@{'flexbar' soundslike 'fubar'}")));
    }

    public void testThisReference() {
        TemplateTests.assertEquals((boolean)true, (boolean)(this.test("@{this}") instanceof Base));
    }

    public void testIfLoopInTemplate() {
        TemplateTests.assertEquals((Object)"ONETWOTHREE", (Object)this.test("@foreach{item :things}@if{item.name=='Bob'}ONE@elseif{item.name=='Smith'}TWO@elseif{item.name=='Cow'}THREE@end{}@end{}"));
    }

    public void testStringEscaping() {
        TemplateTests.assertEquals((Object)"\"Mike Brock\"", (Object)this.test("@{\"\\\"Mike Brock\\\"\"}"));
    }

    public void testStringEscaping2() {
        TemplateTests.assertEquals((Object)"MVEL's Parser is Fast", (Object)this.test("@{'MVEL\\'s Parser is Fast'}"));
    }

    public void testNestedAtSymbol() {
        TemplateTests.assertEquals((Object)"email:foo@foo.com", (Object)this.test("email:@{'foo@foo.com'}"));
    }

    public void testEscape() {
        TemplateTests.assertEquals((Object)"foo@foo.com", (Object)this.test("foo@@@{'foo.com'}"));
    }

    public void testEvalNodes() {
        TemplateTests.assertEquals((Object)"foo", (Object)this.test("@eval{\"@{'foo'}\"}"));
    }

    public void testIteration1() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("a1");
        list.add("a2");
        list.add("a3");
        String template = "@foreach{item : list}a@end{}";
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        map.put("list", list);
        String r = (String)TemplateRuntime.eval((String)template, map);
        System.out.println("r: " + r);
        TemplateTests.assertEquals((String)"aaa", (String)r);
    }

    public void testIteration2() {
        Folder f1 = new Folder("f1", null);
        String template = "@{name} @foreach{item : children}a@end{}";
        String r = (String)TemplateRuntime.eval((String)template, (Object)f1);
        System.out.println("r: " + r);
    }

    public void testIteration3() {
        Folder f = new Folder("a1", null);
        List<Page> list = f.getChildren();
        String template = "@foreach{item : list}a@end{}";
        HashMap<String, List<Page>> map = new HashMap<String, List<Page>>();
        map.put("list", list);
        String r = (String)TemplateRuntime.eval((String)template, map);
        System.out.println("r: " + r);
        TemplateTests.assertEquals((String)"aaa", (String)r);
    }

    public void testIteration4() {
        Folder f = new Folder("a1", null);
        String template = "@foreach{item : f.children}a@end{}";
        HashMap<String, Folder> map = new HashMap<String, Folder>();
        map.put("f", f);
        String r = (String)TemplateRuntime.eval((String)template, map);
        System.out.println("r: " + r);
        TemplateTests.assertEquals((String)"aaa", (String)r);
    }

    public void testMVEL197() {
        HashMap<String, Object[]> context = new HashMap<String, Object[]>();
        Object[] args = new Object[1];
        TestMVEL197 test = new TestMVEL197();
        test.setName1("name1");
        test.setName2("name2");
        args[0] = test;
        context.put("args", args);
        String template = "${(args[0].name1=='name1'&&args[0].name2=='name2')?'a':'b'}";
        Object value = TemplateRuntime.eval((String)template, context);
        TemplateTests.assertEquals((Object)"a", (Object)value);
    }

    public void testEscaping() {
        String template = "@@{'foo'}ABC";
        TemplateTests.assertEquals((Object)"@{'foo'}ABC", (Object)TemplateRuntime.eval((String)template, (Object)new Object()));
    }

    public void testMVEL229() {
        Object context = new Object();
        String template = "@code{sumText = 0}@{sumText}";
        System.out.println(TemplateRuntime.eval((String)"@code{sumText = 0}@{sumText}", new HashMap()));
    }

    public void testOutputStream1() {
        final StringBuilder sb = new StringBuilder();
        OutputStream outstream = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                sb.append((char)b);
            }
        };
        String template = "@foreach{item:['foo','far']}@{item}@end{}";
        CompiledTemplate compiled = TemplateCompiler.compileTemplate((String)template);
        TemplateRuntime.execute((CompiledTemplate)compiled, new HashMap(), (OutputStream)outstream);
        TemplateTests.assertEquals((String)"foofar", (String)sb.toString());
    }

    private Map<String, Object> setupVarsMVEL219() {
        LinkedHashMap<String, Object> vars = new LinkedHashMap<String, Object>();
        vars.put("bal", new BigDecimal("999.99"));
        vars.put("word", "ball");
        vars.put("object", new CoreConfidenceTests.Dog());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("foo", "bar");
        map.put("fu", new CoreConfidenceTests.Dog());
        map.put("trueValue", true);
        map.put("falseValue", false);
        map.put("one", 1);
        map.put("zero", 0);
        vars.put("map", map);
        return vars;
    }

    private Map<String, Object> setupVarsMVEL220() {
        LinkedHashMap<String, Object> vars = new LinkedHashMap<String, Object>();
        vars.put("word", "ball");
        vars.put("object", new CoreConfidenceTests.Dog());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("foo", "bar");
        map.put("fu", new CoreConfidenceTests.Dog());
        map.put("trueValue", true);
        map.put("falseValue", false);
        map.put("one", 1);
        map.put("zero", 0);
        map.put("list", "john,paul,ringo,george");
        vars.put("map", map);
        return vars;
    }

    public void testEvalMVEL220() {
        Map<String, Object> vars = this.setupVarsMVEL220();
        System.out.println("Evaluation=====================");
        for (String expr : this.testCasesMVEL220) {
            System.out.println("Evaluating '" + expr + "': ......");
            Object ret = MVEL.eval((String)expr, vars);
            System.out.println("'" + expr + " ' = " + ret.toString());
            TemplateTests.assertNotNull((Object)ret);
        }
        System.out.println("Evaluation=====================");
    }

    public void testCompiledMVEL220() {
        Map<String, Object> vars = this.setupVarsMVEL220();
        System.out.println("Compilation=====================");
        for (String expr : this.testCasesMVEL220) {
            System.out.println("Compiling '" + expr + "': ......");
            Serializable compiled = MVEL.compileExpression((String)expr);
            Boolean ret = (Boolean)MVEL.executeExpression((Object)compiled, vars);
            System.out.println("'" + expr + " ' = " + ret.toString());
            TemplateTests.assertNotNull((Object)ret);
        }
        System.out.println("Compilation=====================");
    }

    public void testTemplateMVEL220() {
        Map<String, Object> vars = this.setupVarsMVEL220();
        System.out.println("Templates=====================");
        for (String expr : this.templateTestCasesMVEL220) {
            System.out.println("Templating '" + expr + "': ......");
            Object ret = TemplateRuntime.eval((String)expr, vars);
            System.out.println("'" + expr + " ' = " + ret.toString());
            TemplateTests.assertNotNull((Object)ret);
        }
        System.out.println("Templates=====================");
    }

    public void testEvalMVEL219() {
        Map<String, Object> vars = this.setupVarsMVEL219();
        for (String expr : this.testCasesMVEL219) {
            System.out.println("Evaluating '" + expr + "': ......");
            Object ret = MVEL.eval((String)expr, vars);
            System.out.println("'" + expr + " ' = " + ret.toString());
            TemplateTests.assertNotNull((Object)ret);
        }
    }

    public void testCompiledMVEL219() {
        Map<String, Object> vars = this.setupVarsMVEL219();
        for (String expr : this.testCasesMVEL219) {
            System.out.println("Compiling '" + expr + "': ......");
            Serializable compiled = MVEL.compileExpression((String)expr);
            Boolean ret = (Boolean)MVEL.executeExpression((Object)compiled, vars);
            System.out.println("'" + expr + " ' = " + ret.toString());
            TemplateTests.assertNotNull((Object)ret);
        }
    }

    public void testTemplateMVEL219() {
        Map<String, Object> vars = this.setupVarsMVEL219();
        for (String expr : this.templateTestCasesMVEL219) {
            System.out.println("Templating '" + expr + "': ......");
            Object ret = TemplateRuntime.eval((String)expr, vars);
            System.out.println("'" + expr + " ' = " + ret.toString());
            TemplateTests.assertNotNull((Object)ret);
        }
    }

    public void testStringCoercion() {
        String expr = " buffer = new StringBuilder(); i = 10; buffer.append( i + \"blah\" ); buffer.toString()";
        Serializable s = MVEL.compileExpression((String)expr);
        Object ret = MVEL.executeExpression((Object)s, this.setupVarsMVEL219());
        System.out.println(":" + ret);
    }

    public void testTemplateStringCoercion() {
        String expr = "@code{ buffer = new StringBuilder(); i = 10; buffer.append( i + \"blah\" );}@{buffer.toString()}";
        Map<String, Object> vars = this.setupVarsMVEL219();
        System.out.println("Templating '" + expr + "': ......");
        Object ret = TemplateRuntime.eval((String)expr, vars);
        System.out.println("'" + expr + " ' = " + ret.toString());
        TemplateTests.assertNotNull((Object)ret);
    }

    public void testMVEL244() {
        Foo244 foo = new Foo244("plop");
        String template = "@foreach{val : foo.liste[0].liste} plop @end{}";
        CompiledTemplate compiledTemplate = TemplateCompiler.compileTemplate((String)template);
        HashMap<String, Foo244> model = new HashMap<String, Foo244>();
        model.put("foo", foo);
        System.out.println(TemplateRuntime.execute((CompiledTemplate)compiledTemplate, (Object)new ParserContext(), (VariableResolverFactory)new MapVariableResolverFactory(model)));
    }

    public void testImportsInTemplate() {
        String template = "@code{import java.util.HashMap; i = 10;}_____________@code{new HashMap().toString() + i}";
        HashMap map = new HashMap();
        Object result = TemplateRuntime.eval((String)template, map);
        TemplateTests.assertNotNull((String)"result cannot be null", (Object)result);
        TemplateTests.assertEquals((String)"result did not return string", String.class, result.getClass());
    }

    public void testDRLTemplate() {
        String template = "@declare{\"drl\"}@includeNamed{\"ced\"; node=root }@end{}@declare{\"ced\"}@if{ node.base==1 } @includeNamed{ \"cedX\"; connect=\"AND\"; args=node.list }@elseif{ node.base ==2 }@includeNamed{ \"cedX\"; connect=\"OR\"; args=node.list }@end{}@end{}@declare{\"cedX\"}@{connect}@foreach{child : args}@includeNamed{\"ced\"; node=child; }@end{} @{connect}@end{}";
        SimpleTemplateRegistry reportRegistry = new SimpleTemplateRegistry();
        reportRegistry.addNamedTemplate("drl", TemplateCompiler.compileTemplate((String)template));
        TemplateRuntime.execute((CompiledTemplate)reportRegistry.getNamedTemplate("drl"), null, (TemplateRegistry)reportRegistry);
        HashMap<String, Node> context = new HashMap<String, Node>();
        context.put("root", new Node(2, Arrays.asList(new Node(1, Collections.EMPTY_LIST))));
        String result = (String)TemplateRuntime.execute((CompiledTemplate)reportRegistry.getNamedTemplate("drl"), null, (VariableResolverFactory)new MapVariableResolverFactory(context), (TemplateRegistry)reportRegistry);
        TemplateTests.assertEquals((String)"OR AND AND OR", (String)result);
    }

    public static class Node {
        public int base;
        public List<Node> list;

        public Node(int base, List<Node> list) {
            this.base = base;
            this.list = list;
        }
    }

    public static class Foo244 {
        private List<Foo244> liste = new ArrayList<Foo244>();
        private String val = "";

        public Foo244() {
        }

        public Foo244(String plop) {
            this.liste.add(new Foo244());
            this.liste.add(new Foo244());
            this.liste.add(new Foo244());
            this.liste.add(new Foo244());
            this.liste.get(0).getListe().add(new Foo244());
            this.liste.get(0).getListe().add(new Foo244());
            this.liste.get(0).getListe().add(new Foo244());
            this.liste.get(0).getListe().add(new Foo244());
        }

        public List<Foo244> getListe() {
            return this.liste;
        }

        public void setListe(List<Foo244> liste) {
            this.liste = liste;
        }

        public String getVal() {
            return this.val;
        }

        public void setVal(String val) {
            this.val = val;
        }
    }

    public class Folder
    extends Page {
        public Folder(String name, Folder parent) {
            super(name, parent);
        }

        public List<Page> getChildren() {
            ArrayList<Page> list = new ArrayList<Page>();
            list.add(new Page("a1", this));
            list.add(new Page("a2", this));
            list.add(new Page("a3", this));
            return list;
        }
    }

    public class Page {
        String name;
        Folder parent;

        public Page(String name, Folder parent) {
            this.name = name;
            this.parent = parent;
        }

        public String getName() {
            return this.name;
        }

        public Folder getParent() {
            return this.parent;
        }
    }

    public static interface TestInterface {
        public String getName();

        public boolean isFoo();
    }
}

