/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.tests.core;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.junit.Test;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.IndexedVariableResolverFactory;
import org.mvel2.tests.BaseMvelTestCase;
import org.mvel2.tests.core.res.DefaultKnowledgeHelper;
import org.mvel2.tests.core.res.NumberHolder;

public class CompoundAssignmentOperatorTest
extends BaseMvelTestCase {
    private static final String HOLDER = "holder";

    private Map<String, Object> createVarMap() {
        HashMap<String, Object> varMap = new HashMap<String, Object>();
        NumberHolder holder = new NumberHolder();
        holder.setIntPrimitive(120);
        holder.setBigDecimal(new BigDecimal("120"));
        varMap.put(HOLDER, holder);
        varMap.put("myIntValue", 10);
        varMap.put("myBigDecimalValue", 10);
        return varMap;
    }

    @Test
    public void testSimpleIntAddNum() {
        String str = "simpleInteger += 10";
        HashMap<String, Integer> varMap = new HashMap<String, Integer>();
        varMap.put("simpleInteger", new Integer(120));
        Object result = MVEL.eval((String)str, varMap);
        Integer simpleInteger = (Integer)varMap.get("simpleInteger");
        CompoundAssignmentOperatorTest.assertEquals((Object)130, (Object)result);
        CompoundAssignmentOperatorTest.assertEquals((int)130, (int)simpleInteger);
        varMap = new HashMap();
        varMap.put("simpleInteger", new Integer(120));
        Serializable s = MVEL.compileExpression((String)str);
        result = MVEL.executeExpression((Object)s, varMap);
        simpleInteger = (Integer)varMap.get("simpleInteger");
        CompoundAssignmentOperatorTest.assertEquals((Object)130, (Object)result);
        CompoundAssignmentOperatorTest.assertEquals((int)130, (int)simpleInteger);
    }

    @Test
    public void testIntAddNum() {
        String str = "holder.intPrimitive += 10";
        Map<String, Object> varMap = this.createVarMap();
        Object result = MVEL.eval((String)str, varMap);
        NumberHolder holder = (NumberHolder)varMap.get(HOLDER);
        CompoundAssignmentOperatorTest.assertEquals((Object)130, (Object)result);
        CompoundAssignmentOperatorTest.assertEquals((int)130, (int)holder.getIntPrimitive());
        varMap = this.createVarMap();
        Serializable s = MVEL.compileExpression((String)str);
        result = MVEL.executeExpression((Object)s, varMap);
        holder = (NumberHolder)varMap.get(HOLDER);
        CompoundAssignmentOperatorTest.assertEquals((Object)130, (Object)result);
        CompoundAssignmentOperatorTest.assertEquals((int)130, (int)holder.getIntPrimitive());
    }

    @Test
    public void testIntSubNum() {
        String str = "holder.intPrimitive -= 10";
        Map<String, Object> varMap = this.createVarMap();
        Object result = MVEL.eval((String)str, varMap);
        NumberHolder holder = (NumberHolder)varMap.get(HOLDER);
        CompoundAssignmentOperatorTest.assertEquals((Object)110, (Object)result);
        CompoundAssignmentOperatorTest.assertEquals((int)110, (int)holder.getIntPrimitive());
        varMap = this.createVarMap();
        Serializable s = MVEL.compileExpression((String)str);
        result = MVEL.executeExpression((Object)s, varMap);
        holder = (NumberHolder)varMap.get(HOLDER);
        CompoundAssignmentOperatorTest.assertEquals((Object)110, (Object)result);
        CompoundAssignmentOperatorTest.assertEquals((int)110, (int)holder.getIntPrimitive());
    }

    @Test
    public void testIntMultNum() {
        String str = "holder.intPrimitive *= 10";
        Map<String, Object> varMap = this.createVarMap();
        Object result = MVEL.eval((String)str, varMap);
        NumberHolder holder = (NumberHolder)varMap.get(HOLDER);
        CompoundAssignmentOperatorTest.assertEquals((Object)1200, (Object)result);
        CompoundAssignmentOperatorTest.assertEquals((int)1200, (int)holder.getIntPrimitive());
        varMap = this.createVarMap();
        Serializable s = MVEL.compileExpression((String)str);
        result = MVEL.executeExpression((Object)s, varMap);
        holder = (NumberHolder)varMap.get(HOLDER);
        CompoundAssignmentOperatorTest.assertEquals((Object)1200, (Object)result);
        CompoundAssignmentOperatorTest.assertEquals((int)1200, (int)holder.getIntPrimitive());
    }

    @Test
    public void testIntDivNum() {
        String str = "holder.intPrimitive /= 10";
        Map<String, Object> varMap = this.createVarMap();
        Object result = MVEL.eval((String)str, varMap);
        NumberHolder holder = (NumberHolder)varMap.get(HOLDER);
        CompoundAssignmentOperatorTest.assertEquals((Object)12.0, (Object)result);
        CompoundAssignmentOperatorTest.assertEquals((int)12, (int)holder.getIntPrimitive());
        varMap = this.createVarMap();
        Serializable s = MVEL.compileExpression((String)str);
        result = MVEL.executeExpression((Object)s, varMap);
        holder = (NumberHolder)varMap.get(HOLDER);
        CompoundAssignmentOperatorTest.assertEquals((Object)12.0, (Object)result);
        CompoundAssignmentOperatorTest.assertEquals((int)12, (int)holder.getIntPrimitive());
    }

    @Test
    public void testIntAddVar() {
        String str = "holder.intPrimitive += myIntValue";
        Map<String, Object> varMap = this.createVarMap();
        Object result = MVEL.eval((String)str, varMap);
        NumberHolder holder = (NumberHolder)varMap.get(HOLDER);
        CompoundAssignmentOperatorTest.assertEquals((Object)130, (Object)result);
        CompoundAssignmentOperatorTest.assertEquals((int)130, (int)holder.getIntPrimitive());
        varMap = this.createVarMap();
        Serializable s = MVEL.compileExpression((String)str);
        result = MVEL.executeExpression((Object)s, varMap);
        holder = (NumberHolder)varMap.get(HOLDER);
        CompoundAssignmentOperatorTest.assertEquals((Object)130, (Object)result);
        CompoundAssignmentOperatorTest.assertEquals((int)130, (int)holder.getIntPrimitive());
    }

    @Test
    public void testIntSubVar() {
        String str = "holder.intPrimitive -= myIntValue";
        Map<String, Object> varMap = this.createVarMap();
        Object result = MVEL.eval((String)str, varMap);
        NumberHolder holder = (NumberHolder)varMap.get(HOLDER);
        CompoundAssignmentOperatorTest.assertEquals((Object)110, (Object)result);
        CompoundAssignmentOperatorTest.assertEquals((int)110, (int)holder.getIntPrimitive());
        varMap = this.createVarMap();
        Serializable s = MVEL.compileExpression((String)str);
        result = MVEL.executeExpression((Object)s, varMap);
        holder = (NumberHolder)varMap.get(HOLDER);
        CompoundAssignmentOperatorTest.assertEquals((Object)110, (Object)result);
        CompoundAssignmentOperatorTest.assertEquals((int)110, (int)holder.getIntPrimitive());
    }

    @Test
    public void testIntMultVar() {
        String str = "holder.intPrimitive *= myIntValue";
        Map<String, Object> varMap = this.createVarMap();
        Object result = MVEL.eval((String)str, varMap);
        NumberHolder holder = (NumberHolder)varMap.get(HOLDER);
        CompoundAssignmentOperatorTest.assertEquals((Object)1200, (Object)result);
        CompoundAssignmentOperatorTest.assertEquals((int)1200, (int)holder.getIntPrimitive());
        varMap = this.createVarMap();
        Serializable s = MVEL.compileExpression((String)str);
        result = MVEL.executeExpression((Object)s, varMap);
        holder = (NumberHolder)varMap.get(HOLDER);
        CompoundAssignmentOperatorTest.assertEquals((Object)1200, (Object)result);
        CompoundAssignmentOperatorTest.assertEquals((int)1200, (int)holder.getIntPrimitive());
    }

    @Test
    public void testIntDivVar() {
        String str = "holder.intPrimitive /= myIntValue";
        Map<String, Object> varMap = this.createVarMap();
        Object result = MVEL.eval((String)str, varMap);
        NumberHolder holder = (NumberHolder)varMap.get(HOLDER);
        CompoundAssignmentOperatorTest.assertEquals((Object)12.0, (Object)result);
        CompoundAssignmentOperatorTest.assertEquals((int)12, (int)holder.getIntPrimitive());
        varMap = this.createVarMap();
        Serializable s = MVEL.compileExpression((String)str);
        result = MVEL.executeExpression((Object)s, varMap);
        holder = (NumberHolder)varMap.get(HOLDER);
        CompoundAssignmentOperatorTest.assertEquals((Object)12.0, (Object)result);
        CompoundAssignmentOperatorTest.assertEquals((int)12, (int)holder.getIntPrimitive());
    }

    @Test
    public void testBigDecimalAddNum() {
        String str = "holder.bigDecimal += 10";
        Map<String, Object> varMap = this.createVarMap();
        Object result = MVEL.eval((String)str, varMap);
        NumberHolder holder = (NumberHolder)varMap.get(HOLDER);
        CompoundAssignmentOperatorTest.assertEquals((Object)new BigDecimal("130"), (Object)result);
        CompoundAssignmentOperatorTest.assertEquals((Object)new BigDecimal("130"), (Object)holder.getBigDecimal());
        varMap = this.createVarMap();
        Serializable s = MVEL.compileExpression((String)str);
        result = MVEL.executeExpression((Object)s, varMap);
        holder = (NumberHolder)varMap.get(HOLDER);
        CompoundAssignmentOperatorTest.assertEquals((Object)new BigDecimal("130"), (Object)result);
        CompoundAssignmentOperatorTest.assertEquals((Object)new BigDecimal("130"), (Object)holder.getBigDecimal());
    }

    @Test
    public void testBigDecimalSubNum() {
        String str = "holder.bigDecimal -= 10";
        Map<String, Object> varMap = this.createVarMap();
        Object result = MVEL.eval((String)str, varMap);
        NumberHolder holder = (NumberHolder)varMap.get(HOLDER);
        CompoundAssignmentOperatorTest.assertEquals((Object)new BigDecimal("110"), (Object)result);
        CompoundAssignmentOperatorTest.assertEquals((Object)new BigDecimal("110"), (Object)holder.getBigDecimal());
        varMap = this.createVarMap();
        Serializable s = MVEL.compileExpression((String)str);
        result = MVEL.executeExpression((Object)s, varMap);
        holder = (NumberHolder)varMap.get(HOLDER);
        CompoundAssignmentOperatorTest.assertEquals((Object)new BigDecimal("110"), (Object)result);
        CompoundAssignmentOperatorTest.assertEquals((Object)new BigDecimal("110"), (Object)holder.getBigDecimal());
    }

    @Test
    public void testBigDecimalMultNum() {
        String str = "holder.bigDecimal *= 10";
        Map<String, Object> varMap = this.createVarMap();
        Object result = MVEL.eval((String)str, varMap);
        NumberHolder holder = (NumberHolder)varMap.get(HOLDER);
        CompoundAssignmentOperatorTest.assertEquals((Object)new BigDecimal("1200"), (Object)result);
        CompoundAssignmentOperatorTest.assertEquals((Object)new BigDecimal("1200"), (Object)holder.getBigDecimal());
        varMap = this.createVarMap();
        Serializable s = MVEL.compileExpression((String)str);
        result = MVEL.executeExpression((Object)s, varMap);
        holder = (NumberHolder)varMap.get(HOLDER);
        CompoundAssignmentOperatorTest.assertEquals((Object)new BigDecimal("1200"), (Object)result);
        CompoundAssignmentOperatorTest.assertEquals((Object)new BigDecimal("1200"), (Object)holder.getBigDecimal());
    }

    @Test
    public void testBigDecimalDivNum() {
        String str = "holder.bigDecimal /= 10";
        Map<String, Object> varMap = this.createVarMap();
        Object result = MVEL.eval((String)str, varMap);
        NumberHolder holder = (NumberHolder)varMap.get(HOLDER);
        CompoundAssignmentOperatorTest.assertEquals((Object)new BigDecimal("12"), (Object)result);
        CompoundAssignmentOperatorTest.assertEquals((Object)new BigDecimal("12"), (Object)holder.getBigDecimal());
        varMap = this.createVarMap();
        Serializable s = MVEL.compileExpression((String)str);
        result = MVEL.executeExpression((Object)s, varMap);
        holder = (NumberHolder)varMap.get(HOLDER);
        CompoundAssignmentOperatorTest.assertEquals((Object)new BigDecimal("12"), (Object)result);
        CompoundAssignmentOperatorTest.assertEquals((Object)new BigDecimal("12"), (Object)holder.getBigDecimal());
    }

    @Test
    public void testBigDecimalAddVar() {
        String str = "holder.bigDecimal += myBigDecimalValue";
        Map<String, Object> varMap = this.createVarMap();
        Object result = MVEL.eval((String)str, varMap);
        NumberHolder holder = (NumberHolder)varMap.get(HOLDER);
        CompoundAssignmentOperatorTest.assertEquals((Object)new BigDecimal("130"), (Object)result);
        CompoundAssignmentOperatorTest.assertEquals((Object)new BigDecimal("130"), (Object)holder.getBigDecimal());
        varMap = this.createVarMap();
        Serializable s = MVEL.compileExpression((String)str);
        result = MVEL.executeExpression((Object)s, varMap);
        holder = (NumberHolder)varMap.get(HOLDER);
        CompoundAssignmentOperatorTest.assertEquals((Object)new BigDecimal("130"), (Object)result);
        CompoundAssignmentOperatorTest.assertEquals((Object)new BigDecimal("130"), (Object)holder.getBigDecimal());
    }

    @Test
    public void testBigDecimalSubVar() {
        String str = "holder.bigDecimal -= myBigDecimalValue";
        Map<String, Object> varMap = this.createVarMap();
        Object result = MVEL.eval((String)str, varMap);
        NumberHolder holder = (NumberHolder)varMap.get(HOLDER);
        CompoundAssignmentOperatorTest.assertEquals((Object)new BigDecimal("110"), (Object)result);
        CompoundAssignmentOperatorTest.assertEquals((Object)new BigDecimal("110"), (Object)holder.getBigDecimal());
        varMap = this.createVarMap();
        Serializable s = MVEL.compileExpression((String)str);
        result = MVEL.executeExpression((Object)s, varMap);
        holder = (NumberHolder)varMap.get(HOLDER);
        CompoundAssignmentOperatorTest.assertEquals((Object)new BigDecimal("110"), (Object)result);
        CompoundAssignmentOperatorTest.assertEquals((Object)new BigDecimal("110"), (Object)holder.getBigDecimal());
    }

    @Test
    public void testBigDecimalMultVar() {
        String str = "holder.bigDecimal *= myBigDecimalValue";
        Map<String, Object> varMap = this.createVarMap();
        Object result = MVEL.eval((String)str, varMap);
        NumberHolder holder = (NumberHolder)varMap.get(HOLDER);
        CompoundAssignmentOperatorTest.assertEquals((Object)new BigDecimal("1200"), (Object)result);
        CompoundAssignmentOperatorTest.assertEquals((Object)new BigDecimal("1200"), (Object)holder.getBigDecimal());
        varMap = this.createVarMap();
        Serializable s = MVEL.compileExpression((String)str);
        result = MVEL.executeExpression((Object)s, varMap);
        holder = (NumberHolder)varMap.get(HOLDER);
        CompoundAssignmentOperatorTest.assertEquals((Object)new BigDecimal("1200"), (Object)result);
        CompoundAssignmentOperatorTest.assertEquals((Object)new BigDecimal("1200"), (Object)holder.getBigDecimal());
    }

    @Test
    public void testBigDecimalDivVar() {
        String str = "holder.bigDecimal /= myBigDecimalValue";
        Map<String, Object> varMap = this.createVarMap();
        Object result = MVEL.eval((String)str, varMap);
        NumberHolder holder = (NumberHolder)varMap.get(HOLDER);
        CompoundAssignmentOperatorTest.assertEquals((Object)new BigDecimal("12"), (Object)result);
        CompoundAssignmentOperatorTest.assertEquals((Object)new BigDecimal("12"), (Object)holder.getBigDecimal());
        varMap = this.createVarMap();
        Serializable s = MVEL.compileExpression((String)str);
        result = MVEL.executeExpression((Object)s, varMap);
        holder = (NumberHolder)varMap.get(HOLDER);
        CompoundAssignmentOperatorTest.assertEquals((Object)new BigDecimal("12"), (Object)result);
        CompoundAssignmentOperatorTest.assertEquals((Object)new BigDecimal("12"), (Object)holder.getBigDecimal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBigDecimalAddNumStrictType() {
        boolean allowNakedMethCall = MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL;
        boolean allowOverrideAllProphandling = MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING;
        boolean allowResolveInnerclassesWithDotnotation = MVEL.COMPILER_OPT_ALLOW_RESOLVE_INNERCLASSES_WITH_DOTNOTATION;
        boolean supportJavaStyleClassLiterals = MVEL.COMPILER_OPT_SUPPORT_JAVA_STYLE_CLASS_LITERALS;
        try {
            MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = true;
            MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = true;
            MVEL.COMPILER_OPT_ALLOW_RESOLVE_INNERCLASSES_WITH_DOTNOTATION = true;
            MVEL.COMPILER_OPT_SUPPORT_JAVA_STYLE_CLASS_LITERALS = true;
            ParserContext parserContext = ParserContext.create();
            parserContext.setStrictTypeEnforcement(true);
            parserContext.setStrongTyping(true);
            parserContext.setIndexAllocation(true);
            String[] names = new String[]{HOLDER};
            parserContext.addIndexedInput(names);
            parserContext.addInput(HOLDER, NumberHolder.class);
            String str = "holder.bigDecimal += 10";
            Serializable s = MVEL.compileExpression((String)str, (ParserContext)parserContext);
            DefaultKnowledgeHelper helper = new DefaultKnowledgeHelper();
            NumberHolder holder = new NumberHolder();
            holder.setBigDecimal(new BigDecimal("120"));
            Object[] values = new Object[]{holder};
            IndexedVariableResolverFactory variableResolverFactory = new IndexedVariableResolverFactory(names, values);
            Object result = MVEL.executeExpression((Object)s, (Object)helper, (VariableResolverFactory)variableResolverFactory);
            CompoundAssignmentOperatorTest.assertEquals((Object)new BigDecimal("130"), (Object)result);
            CompoundAssignmentOperatorTest.assertEquals((Object)new BigDecimal("130"), (Object)holder.getBigDecimal());
        }
        finally {
            MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = allowNakedMethCall;
            MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = allowOverrideAllProphandling;
            MVEL.COMPILER_OPT_ALLOW_RESOLVE_INNERCLASSES_WITH_DOTNOTATION = allowResolveInnerclassesWithDotnotation;
            MVEL.COMPILER_OPT_SUPPORT_JAVA_STYLE_CLASS_LITERALS = supportJavaStyleClassLiterals;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBigDecimalAddVarStrictType() {
        boolean allowNakedMethCall = MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL;
        boolean allowOverrideAllProphandling = MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING;
        boolean allowResolveInnerclassesWithDotnotation = MVEL.COMPILER_OPT_ALLOW_RESOLVE_INNERCLASSES_WITH_DOTNOTATION;
        boolean supportJavaStyleClassLiterals = MVEL.COMPILER_OPT_SUPPORT_JAVA_STYLE_CLASS_LITERALS;
        try {
            MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = true;
            MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = true;
            MVEL.COMPILER_OPT_ALLOW_RESOLVE_INNERCLASSES_WITH_DOTNOTATION = true;
            MVEL.COMPILER_OPT_SUPPORT_JAVA_STYLE_CLASS_LITERALS = true;
            ParserContext parserContext = ParserContext.create();
            parserContext.setStrictTypeEnforcement(true);
            parserContext.setStrongTyping(true);
            parserContext.setIndexAllocation(true);
            String[] names = new String[]{HOLDER, "myBigDecimalValue"};
            parserContext.addIndexedInput(names);
            parserContext.addInput(HOLDER, NumberHolder.class);
            parserContext.addInput("myBigDecimalValue", BigDecimal.class);
            String str = "holder.bigDecimal += myBigDecimalValue";
            Serializable s = MVEL.compileExpression((String)str, (ParserContext)parserContext);
            DefaultKnowledgeHelper helper = new DefaultKnowledgeHelper();
            NumberHolder holder = new NumberHolder();
            holder.setBigDecimal(new BigDecimal("120"));
            BigDecimal myBigDecimalValue = new BigDecimal("10");
            Object[] values = new Object[]{holder, myBigDecimalValue};
            IndexedVariableResolverFactory variableResolverFactory = new IndexedVariableResolverFactory(names, values);
            Object result = MVEL.executeExpression((Object)s, (Object)helper, (VariableResolverFactory)variableResolverFactory);
            CompoundAssignmentOperatorTest.assertEquals((Object)new BigDecimal("130"), (Object)result);
            CompoundAssignmentOperatorTest.assertEquals((Object)new BigDecimal("130"), (Object)holder.getBigDecimal());
        }
        finally {
            MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = allowNakedMethCall;
            MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = allowOverrideAllProphandling;
            MVEL.COMPILER_OPT_ALLOW_RESOLVE_INNERCLASSES_WITH_DOTNOTATION = allowResolveInnerclassesWithDotnotation;
            MVEL.COMPILER_OPT_SUPPORT_JAVA_STYLE_CLASS_LITERALS = supportJavaStyleClassLiterals;
        }
    }
}

