/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.tests.core;

import java.util.HashMap;
import org.mvel2.MVEL;
import org.mvel2.ast.Proto;
import org.mvel2.compiler.AbstractParser;
import org.mvel2.tests.BaseMvelTestCase;

public class ProtoTests
extends BaseMvelTestCase {
    boolean run = AbstractParser.OPERATORS.containsKey("proto");

    public void testBasicProtoConstruct() {
        if (!this.run) {
            return;
        }
        ProtoTests.assertTrue((boolean)(MVEL.eval((String)"proto Person { int age; String name; }; new Person();", new HashMap()) instanceof Proto.ProtoInstance));
    }

    public void testProtoFieldAccess() {
        if (!this.run) {
            return;
        }
        Object o = MVEL.eval((String)"proto Person { int age = 5; String name; }; (p = new Person()).age", new HashMap());
        ProtoTests.assertEquals((Object)5, (Object)o);
    }

    public void testProtoWithFunction() {
        if (!this.run) {
            return;
        }
        Object o = MVEL.eval((String)"proto Person {                int age = 2;                def multAge() {                    age * 10                };              };             p = new Person();              p.multAge();", new HashMap());
        ProtoTests.assertEquals((Object)20, (Object)o);
    }

    public void testProtoWithFunction2() {
        if (!this.run) {
            return;
        }
        String ex = "proto Adder {int count = 0;def accumulate() {if (count < 10) {System.out.println('counting:' + count);count++;accumulate();}}};adder = new Adder();adder.accumulate();adder.count;";
        Object o = MVEL.eval((String)ex, new HashMap());
        ProtoTests.assertEquals((Object)10, (Object)o);
    }

    public void testProtoWithOtherProtoRef() {
        if (!this.run) {
            return;
        }
        String ex = "proto Parent { Child child = new Child(); }; proto Child { Parent parent; }; Parent parent = new Parent(); if (parent.child.parent == null) { 'YEP' } else { 'NOPE' }";
        Object o = MVEL.eval((String)ex, new HashMap());
        ProtoTests.assertEquals((Object)"YEP", (Object)o);
    }
}

