![Logo](.docs/logo_250.png "atlassian")
# atlassian
jira and confluence command line interface.

[![Version][badge-vers]][npm]
[![Bundle size][npm-size-badge]][npm-size-url]
[![Downloads][npm-downloads-badge]][npm]

[![CodeFactor][codefactor-badge]][codefactor-url]
[![SonarCloud][sonarcloud-badge]][sonarcloud-url]
[![Codacy][codacy-badge]][codacy-url]
[![Scrutinizer][scrutinizer-badge]][scrutinizer-url]

[![Dependencies][badge-deps]][npm]
[![Security][snyk-badge]][snyk-url]
[![Build Status][tests-badge]][tests-url]
[![Coverage Status][badge-coverage]][url-coverage]

[![Commit activity][commit-activity-badge]][github]
[![FOSSA][fossa-badge]][fossa-url]
[![License][badge-lic]][github]

## 🇺🇦 Help Ukraine
I woke up on my 26th birthday at 5 am from the blows of russian missiles. They attacked the city of Kyiv, where I live, as well as the cities in which my family and friends live. Now my country is a war zone. 

We fight for democratic values, freedom, for our future! Once again Ukrainians have to stand against evil, terror, against genocide. The outcome of this war will determine what path human history is taking from now on.

💛💙  Help Ukraine! We need your support! There are [dozen ways][ukr-link] to help us, just do it!

## Table of Contents
  - [Requirements](#requirements)
  - [Installation](#installation)
  - [Usage](#usage)
  - [Contribute](#contribute)

## Requirements
[![Platform Status][node-ver-test-badge]][node-ver-test-url]

To use library you need to have [node](https://nodejs.org) and [npm](https://www.npmjs.com) installed in your machine:

* node `>=10`
* npm `>=6`

**Note:** if you received yargs error ```"yargs parser supports a minimum Node.js version of x"```, try to set evironment variable ```YARGS_MIN_NODE_VERSION=10```.

Package is [continuously tested][node-ver-test-url] on darwin, linux and win32 platforms. All active and maintenance [LTS](https://nodejs.org/en/about/releases/) node releases are supported.

## Installation

To install the library run the following command

```bash
  npm i -g atlassian
```

## Usage

## Jira cli

### Init
```
jira init

Add attlasian profile

Options:
  -h, --help     Show help                                             [boolean]
      --version  Show version number                                   [boolean]
```

### List Tasks

Generally, ```jira list``` command can help to list all tasks

```
jira list [--dev] [--mine] [--search=<search>] [--sprint=<sprint>] [--verbose]
[--profile=<profile>]

List Tasks

Options:
  -h, --help                Show help                                                 [boolean]
      --version             Show version number                                       [boolean]
  -v, --verbose             verbose logs                                              [boolean]
  -p, --profile             specify profile name                                       [string]
  -d, --dev, --development  filter only tasks in development                          [boolean]
  -m, --mine, --my          filter only mine issues                                   [boolean]
  -s, --search, --grep      search issues by summary                                   [string]
      --sprint              specify sprints for filter
                                           [array] [choices: "all", "open"] [default: ["open"]]
```

Some common examples:

1) get all mine tasks in development for open sprint:
   ```bash
      jira ls -dm
   ```
   where ```ls``` is alias for ```list``` command and ```-dm``` means *mine* tasks in *dev* status

2) search issues that contains *memory leak* words:
   ```bash
      jira ls -s 'memory leak'
   ```
   where ```-s``` is a shortcut for ```--search``` or ```--grep```

### Send issue(s) to testing

```
jira test [--verbose] [--profile=<profile>] <issueId...>

Send task to testing

Options:
  -h, --help     Show help                                                            [boolean]
      --version  Show version number                                                  [boolean]
  -v, --verbose  verbose logs                                                         [boolean]
  -p, --profile  specify profile name                                                  [string]
      --issueId  id(s) of task                                                          [array]
```

### Clear worklog

```
jira worklog clear <issueId> [--verbose] [--profile=<profile>]

Clear worklog

Positionals:
  <issueId>  Id of the issue                                                           [string]

Options:
  -h, --help     Show help                                                            [boolean]
      --version  Show version number                                                  [boolean]
  -v, --verbose  verbose logs                                                         [boolean]
  -p, --profile  specify profile name                                                  [string]
```
### Print jira statuses
```
jira statuses [--verbose] [--profile=<profile>]

List jira configuration statuses

Options:
  -h, --help     Show help                                                            [boolean]
      --version  Show version number                                                  [boolean]
```

## Confluence cli

### Init
```
confluence init

Add attlasian profile

Options:
  -h, --help     Show help                                             [boolean]
      --version  Show version number                                   [boolean]
```

### Get list of pages
```
confluence pages <space> [--profile=<profile>] [--verbose]

List Pages

Options:
      --version  Show version number                                                  [boolean]
  -h, --help     Show help                                                            [boolean]
  -v, --verbose  verbose logs                                                         [boolean]
      --debug    debug logs                                                           [boolean]
      --space    Id of confluence space                                                [string]
```

### Export page of pdf

To export specific page as pdf firstly [obtain pageId](#get-list-of-pages). Then use pageId as argument for next command:

```
confluence export <page> [--path=<path>] [--verbose] [--debug] [--profile=<profile>]

Export Page as pdf

Options:
      --version  Show version number                                                  [boolean]
  -h, --help     Show help                                                            [boolean]
  -v, --verbose  verbose logs                                                         [boolean]
      --debug    debug logs                                                           [boolean]
      --page     Id of space page                                                      [string]

```

Path to generated .pdf will be written to stdout.

## Contribute

Make the changes to the code and tests. Then commit to your branch. Be sure to follow the commit message conventions. Read [Contributing Guidelines](.github/CONTRIBUTING.md) for details.

[npm]: https://www.npmjs.com/package/atlassian
[github]: https://github.com/pustovitDmytro/atlassian
[coveralls]: https://coveralls.io/github/pustovitDmytro/atlassian?branch=master
[badge-deps]: https://img.shields.io/librariesio/release/npm/atlassian.svg
[badge-vuln]: https://img.shields.io/snyk/vulnerabilities/npm/atlassian.svg?style=popout
[badge-vers]: https://img.shields.io/npm/v/atlassian.svg
[badge-lic]: https://img.shields.io/github/license/pustovitDmytro/atlassian.svg
[badge-coverage]: https://coveralls.io/repos/github/pustovitDmytro/atlassian/badge.svg?branch=master
[url-coverage]: https://coveralls.io/github/pustovitDmytro/atlassian?branch=master

[snyk-badge]: https://snyk-widget.herokuapp.com/badge/npm/atlassian/badge.svg
[snyk-url]: https://snyk.io/advisor/npm-package/atlassian

[tests-badge]: https://img.shields.io/circleci/build/github/pustovitDmytro/atlassian
[tests-url]: https://app.circleci.com/pipelines/github/pustovitDmytro/atlassian

[codefactor-badge]: https://www.codefactor.io/repository/github/pustovitdmytro/atlassian/badge
[codefactor-url]: https://www.codefactor.io/repository/github/pustovitdmytro/atlassian

[commit-activity-badge]: https://img.shields.io/github/commit-activity/m/pustovitDmytro/atlassian

[scrutinizer-badge]: https://scrutinizer-ci.com/g/pustovitDmytro/atlassian/badges/quality-score.png?b=master
[scrutinizer-url]: https://scrutinizer-ci.com/g/pustovitDmytro/atlassian/?branch=master

[codacy-badge]: https://app.codacy.com/project/badge/Grade/8667aa23afaa4725854f098c4b5e8890
[codacy-url]: https://www.codacy.com/gh/pustovitDmytro/atlassian/dashboard?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=pustovitDmytro/atlassian&amp;utm_campaign=Badge_Grade

[sonarcloud-badge]: https://sonarcloud.io/api/project_badges/measure?project=pustovitDmytro_atlassian&metric=alert_status
[sonarcloud-url]: https://sonarcloud.io/dashboard?id=pustovitDmytro_atlassian

[npm-downloads-badge]: https://img.shields.io/npm/dw/atlassian
[npm-size-badge]: https://img.shields.io/bundlephobia/min/atlassian
[npm-size-url]: https://bundlephobia.com/result?p=atlassian

[node-ver-test-badge]: https://github.com/pustovitDmytro/atlassian/actions/workflows/npt.yml/badge.svg?branch=master
[node-ver-test-url]: https://github.com/pustovitDmytro/atlassian/actions?query=workflow%3A%22Node.js+versions%22

[fossa-badge]: https://app.fossa.com/api/projects/custom%2B24828%2Fatlassian.svg?type=shield
[fossa-url]: https://app.fossa.com/projects/custom%2B24828%2Fatlassian?ref=badge_shield

[ukr-badge]: https://img.shields.io/badge/made_in-ukraine-ffd700.svg?labelColor=0057b7
[ukr-link]: https://war.ukraine.ua
