"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.ATLASSIAN_ERROR = void 0;

var _baseApiClient = _interopRequireDefault(require("base-api-client"));

var _Error = _interopRequireDefault(require("base-api-client/lib/Error"));

var _dumpUtils = require("../utils/dumpUtils");

var _logger = _interopRequireDefault(require("../logger"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class ATLASSIAN_ERROR extends _Error.default {
  get message() {
    var _this$payload$respons, _inner$errorMessages;

    const messages = [this.payload.message];
    const inner = (_this$payload$respons = this.payload.response) === null || _this$payload$respons === void 0 ? void 0 : _this$payload$respons.data;

    if (inner !== null && inner !== void 0 && inner.message) {
      messages.push(inner.message);
    } else if (inner !== null && inner !== void 0 && (_inner$errorMessages = inner.errorMessages) !== null && _inner$errorMessages !== void 0 && _inner$errorMessages.length) {
      messages.push(...inner.errorMessages);
    } else if (inner) {
      messages.push(JSON.stringify(inner));
    }

    return messages.join(' ');
  }

}

exports.ATLASSIAN_ERROR = ATLASSIAN_ERROR;

class AtlassianApi extends _baseApiClient.default {
  constructor(url, auth) {
    super(url);
    this.auth = auth;
  }

  onError(error) {
    if (error.isAxiosError) throw new ATLASSIAN_ERROR(error);
    throw error;
  }

  initLogger(logger = _logger.default) {
    this.setLogger(logger);
  }

  setLogger(logger) {
    super.initLogger(logger);
    this.logger = logger;
  }

  async getMyself() {
    const res = await this.get('/rest/api/3/myself');
    return (0, _dumpUtils.dumpUser)(res);
  }

}

exports.default = AtlassianApi;