"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _htmlToText = require("html-to-text");

var _dumpUtils = require("../utils/dumpUtils");

var _AtlassianApi = _interopRequireWildcard(require("./AtlassianApi"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

class ConfluenceApi extends _AtlassianApi.default {
  async pagesList(space, opts = {}) {
    const {
      expandBodyStorage = true,
      limit = 10,
      start = 0
    } = opts;
    const params = {
      limit,
      start
    };
    if (expandBodyStorage) params.expand = 'body.storage';
    const res = await this.get(`/wiki/rest/api/space/${space}/content`, params);
    const {
      results,
      size
    } = res.page;
    const pages = results.map(p => (0, _dumpUtils.dumpPage)(p));

    if (size >= limit) {
      const nextPages = await this.pagesList(space, { ...opts,
        start: start + limit
      });
      return [...pages, ...nextPages];
    }

    return pages;
  }

  async pdfpageexport(pageId) {
    try {
      await this.get(`${this.host}/wiki/spaces/flyingpdf/pdfpageexport.action?pageId=${pageId}`);
    } catch (error) {
      const isGood = error instanceof _AtlassianApi.ATLASSIAN_ERROR;
      const pdfpageexportStatusCode = 403;

      if (isGood) {
        const {
          response
        } = error.payload;

        if (response.status === pdfpageexportStatusCode && response.headers['content-type'].match('text/html')) {
          const text = (0, _htmlToText.htmlToText)(response.data);

          if (text.match('PDF EXPORT - IN PROGRESS')) {
            const taskId = response.data.match(/ajs-taskid.*content="(\d+)/i)[1];
            return {
              status: 1,
              text,
              taskId
            };
          }
        }
      }

      throw error;
    }
  }

  async getLongTask(taskId) {
    const res = await this.get(`wiki/rest/api/longtask/${taskId}`);
    return (0, _dumpUtils.dumpLongTask)(res);
  }

  async downloadFile(downloadUrl) {
    return this.get(downloadUrl, {}, {
      responseType: 'stream'
    });
  }

}

exports.default = ConfluenceApi;