"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.levels = exports.level = exports.default = exports.JSONFormats = void 0;

var _winston = require("winston");

var _package = require("../package.json");

/* eslint-disable camelcase */
const appNameFormat = (0, _winston.format)(info => {
  info[_package.name] = _package.version; // eslint-disable-line no-param-reassign

  return info;
});
const {
  npm_config_loglevel,
  ATLASSIAN_DEBUG,
  ATLASSIAN_LOG_LEVEL
} = process.env;
const level = ATLASSIAN_LOG_LEVEL || ATLASSIAN_DEBUG && 'debug' || npm_config_loglevel || 'notice';
exports.level = level;
const levels = {
  error: 0,
  warn: 1,
  info: 2,
  notice: 3,
  verbose: 4,
  debug: 5
};
exports.levels = levels;
const JSONFormats = [_winston.format.splat(), appNameFormat(), _winston.format.timestamp(), _winston.format.json()];
exports.JSONFormats = JSONFormats;

var _default = (0, _winston.createLogger)({
  level,
  levels,
  format: _winston.format.combine(...JSONFormats),
  transports: [new _winston.transports.Console({})]
});

exports.default = _default;