"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dumpComment = dumpComment;
exports.dumpLongTask = dumpLongTask;
exports.dumpPage = dumpPage;
exports.dumpSprint = dumpSprint;
exports.dumpStatus = dumpStatus;
exports.dumpTask = dumpTask;
exports.dumpTransition = dumpTransition;
exports.dumpUser = dumpUser;
exports.dumpWorklog = dumpWorklog;

var _myrmidon = require("myrmidon");

const MS_TO_SEC = 1000; // JIRA

function dumpTask(issue = {}) {
  var _issue$fields$project, _issue$fields$assigne, _issue$fields$assigne2, _issue$fields$priorit, _issue$fields$status, _issue$fields$status2, _issue$fields$worklog, _issue$fields$comment;

  const history = issue.changelog ? (0, _myrmidon.flatten)(issue.changelog.histories.map(h => h.items.map(i => ({
    item: i,
    history: h
  })))) : [];
  return {
    id: issue.key,
    key: issue.key,
    project: (_issue$fields$project = issue.fields.project) === null || _issue$fields$project === void 0 ? void 0 : _issue$fields$project.name,
    created: issue.fields.created,
    updated: issue.fields.updated,
    assignee: (_issue$fields$assigne = issue.fields.assignee) === null || _issue$fields$assigne === void 0 ? void 0 : _issue$fields$assigne.accountId,
    assigneeName: (_issue$fields$assigne2 = issue.fields.assignee) === null || _issue$fields$assigne2 === void 0 ? void 0 : _issue$fields$assigne2.displayName,
    summary: issue.fields.summary,
    description: issue.fields.description,
    time: issue.fields.aggregatetimespent,
    priority: (_issue$fields$priorit = issue.fields.priority) === null || _issue$fields$priorit === void 0 ? void 0 : _issue$fields$priorit.name,
    status: (_issue$fields$status = issue.fields.status) === null || _issue$fields$status === void 0 ? void 0 : _issue$fields$status.id,
    statusName: (_issue$fields$status2 = issue.fields.status) === null || _issue$fields$status2 === void 0 ? void 0 : _issue$fields$status2.name,
    worklog: issue._worklog || ((_issue$fields$worklog = issue.fields.worklog) === null || _issue$fields$worklog === void 0 ? void 0 : _issue$fields$worklog.worklogs.map(w => dumpWorklog(w))) || [],
    comments: issue._comments || ((_issue$fields$comment = issue.fields.comment) === null || _issue$fields$comment === void 0 ? void 0 : _issue$fields$comment.comments.map(c => dumpComment(c))) || [],
    history: history.filter(({
      item
    }) => {
      return item.field === 'status';
    }).map(h => dumpHistory(h)),
    transitions: issue._transitions || []
  };
}

function dumpHistory(h) {
  return {
    author: h.history.author.accountId,
    date: h.history.created,
    // from   : h.item.fromString,
    // to     : h.item.toString
    from: h.item.from,
    to: h.item.to
  };
}

function dumpWorklog(w) {
  return {
    id: w.id,
    time: w.timeSpentSeconds * MS_TO_SEC,
    author: w.author.accountId,
    start: w.started
  };
}

function dumpUser(user) {
  return {
    email: user.emailAddress,
    id: user.accountId,
    name: user.displayName
  };
}

function dumpSprint(s) {
  return {
    id: s.id,
    state: s.state,
    // closed, future, active
    name: s.name,
    goal: s.goal,
    startDate: s.startDate,
    endDate: s.endDate,
    completeDate: s.completeDate
  };
}

function dumpStatus(s) {
  return {
    id: s.id,
    name: s.name,
    // eslint-disable-next-line censor/no-swear
    category: s.statusCategory.name
  };
}

function dumpTransition(t) {
  return {
    id: t.id,
    name: t.name,
    to: {
      id: t.to.id,
      name: t.to.name
    }
  };
}

function dumpComment(c) {
  return {
    author: c.author.accountId,
    authorName: c.author.displayName,
    text: c.body,
    date: c.updated
  };
} // Confluence


function dumpPage(p) {
  return {
    id: p.id,
    type: p.type,
    status: p.status,
    title: p.title
  };
}

function dumpLongTask(t) {
  var _t$messages;

  return {
    id: t.id,
    elapsedTime: t.elapsedTime,
    percentageComplete: t.percentageComplete,
    successful: t.successful,
    finished: t.finished,
    text: (_t$messages = t.messages) === null || _t$messages === void 0 ? void 0 : _t$messages[0].translation
  };
}