"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _path = _interopRequireDefault(require("path"));

var _fsExtra = _interopRequireDefault(require("fs-extra"));

var _myrmidon = require("myrmidon");

var _ConfluenceApi = _interopRequireDefault(require("./api/ConfluenceApi"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const CONFLUENCE_LOG_POLLING_INTERVAL = 500;

class Confluence extends _ConfluenceApi.default {
  constructor(config, logger) {
    super(config.host, {
      username: config.email,
      password: config.token
    });
    this.userId = config.userId;
    this.host = config.host;
    this.initLogger(logger);
  }

  async getPages(space) {
    return this.pagesList(space);
  }

  async resolveLongTask(taskId) {
    const task = await this.getLongTask(taskId);
    if (task.finished) return task;
    await (0, _myrmidon.pause)(CONFLUENCE_LOG_POLLING_INTERVAL);
    return this.resolveLongTask(taskId);
  }

  async exportPage(pageId, filename) {
    const pdfpageexport = await this.pdfpageexport(pageId);
    if (!(pdfpageexport !== null && pdfpageexport !== void 0 && pdfpageexport.taskId)) throw new Error('Task has not been started by pdfpageexport');
    const task = await this.resolveLongTask(pdfpageexport.taskId);
    const downloadUrl = task.text.match(/<a class="space-export-download-path" href="([^">]*)">/i)[1];

    const filePath = _path.default.resolve(filename);

    const writer = _fsExtra.default.createWriteStream(filePath);

    this.logger.log('verbose', {
      downloadUrl: `${this.host}${downloadUrl}`
    });
    const stream = await this.downloadFile(downloadUrl);
    stream.pipe(writer);
    await new Promise((resolve, reject) => {
      writer.on('finish', resolve);
      writer.on('error', reject);
    });
    this.logger.log('info', `written to ${filePath}`);
    return filePath;
  }

}

exports.default = Confluence;