#!/usr/bin/env node
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = run;

var _path = _interopRequireDefault(require("path"));

var _os = _interopRequireDefault(require("os"));

var _yargs = _interopRequireDefault(require("yargs/yargs"));

var _uuid = require("uuid");

var _Confluence = _interopRequireDefault(require("../Confluence"));

var _package = _interopRequireDefault(require("../../package.json"));

var _utils = require("./utils");

var _init = _interopRequireDefault(require("./init"));

var _logger = _interopRequireDefault(require("./logger"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const isMain = !module.parent;
const onYargsFail = (0, _utils.getYargsFail)(isMain, _logger.default);
const cliCommand = (0, _utils.getCLIRunner)({
  isMain,
  profile: 'confluence'
});

async function listPages(args, profile) {
  const confluence = new _Confluence.default(profile, _logger.default);
  const pages = await confluence.getPages(args.space);

  for (const p of pages) {
    _logger.default.info(`%s ${p.title}`, p.id);
  }
}

async function exportPage(args, profile) {
  const fileName = args.path ? _path.default.resolve(args.path) : _path.default.resolve(_os.default.tmpdir(), `${(0, _uuid.v4)()}.pdf`);
  const confluence = new _Confluence.default(profile, _logger.default);
  await confluence.exportPage(args.page, fileName);
}

async function run(cmd) {
  await (0, _yargs.default)(cmd).usage('Usage: $0 <command> [options]').command({
    command: 'init',
    desc: 'Add attlasian profile',
    handler: cliCommand(_init.default, {
      noLoadProfile: true
    })
  }).command({
    command: `pages <space> ${_utils.commonCommandArgs}`,
    aliases: ['ls', 'list'],
    builder: y => (0, _utils.commonYargsOpts)(y).option('space', {
      describe: 'Id of confluence space',
      type: 'string'
    }).alias('-p', '--profile'),
    desc: 'List Pages',
    handler: cliCommand(listPages)
  }).command({
    command: `export <page> [--path=<path>] ${_utils.commonCommandArgs}`,
    builder: y => (0, _utils.commonYargsOpts)(y).option('page', {
      describe: 'Id of space page',
      type: 'string'
    }).alias('-p', '--profile'),
    desc: 'Export Page as pdf',
    handler: cliCommand(exportPage)
  }).help('h').alias('h', 'help').wrap(Math.min(_utils.minTerminalWidth, process.stdout.columns)).showHelpOnFail(true).demandCommand(1, '').recommendCommands().strict().epilog(`${_package.default.name} v.${_package.default.version}`).fail(onYargsFail).argv;
}

if (isMain) {
  const firstCmdArgIndex = 2;
  run(process.argv.slice(firstCmdArgIndex));
}