"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _winston = require("winston");

var _chalk = _interopRequireDefault(require("chalk"));

var _tripleBeam = require("triple-beam");

var _logger = require("../logger");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* eslint-disable no-param-reassign */
const splatChalkFormat = (0, _winston.format)(info => {
  if (info[_tripleBeam.SPLAT]) {
    info[_tripleBeam.SPLAT] = info[_tripleBeam.SPLAT].map(s => _chalk.default.bold(s));
  }

  return info;
});
const levelTags = {
  warn: {
    color: '#b3b300',
    name: 'Warning'
  },
  error: {
    color: '#b30000',
    name: 'Error',
    fillMessage: true
  }
};
const simpleChalkFormat = (0, _winston.format)(info => {
  const levelTag = levelTags[info.level];
  const messages = [];
  if (levelTag) messages.push(_chalk.default.hex(levelTag.color).bold(`${levelTag.name}: `));
  messages.push(levelTag !== null && levelTag !== void 0 && levelTag.fillMessage ? _chalk.default.hex(levelTag.color)(info.message) : info.message);
  info[_tripleBeam.MESSAGE] = messages.join('');
  return info;
});

const levelsFilter = (lvs = [], ...rest) => (0, _winston.format)(info => {
  if (lvs.includes(info[_tripleBeam.LEVEL])) {
    return info;
  }
})(...rest);

var _default = (0, _winston.createLogger)({
  level: _logger.level,
  levels: _logger.levels,
  transports: [new _winston.transports.Console({
    format: _winston.format.combine(splatChalkFormat(), _winston.format.splat(), simpleChalkFormat()),
    level: 'info'
  }), new _winston.transports.Console({
    format: _winston.format.combine(levelsFilter(['debug', 'verbose', 'notice']), ..._logger.JSONFormats)
  })]
});

exports.default = _default;