"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.workingDays = workingDays;

var _date = _interopRequireDefault(require("../date"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const WEEKEND_INDEXES = new Set([0, 6]); // eslint-disable-line no-magic-numbers

function workingDays({
  include = [],
  exclude = [],
  to,
  from
}) {
  const start = _date.default.min([(0, _date.default)(from), ...include]);

  const end = _date.default.max([(0, _date.default)(to), ...include]);

  const totalDays = (0, _date.default)(end).diff((0, _date.default)(start), 'day') + 1;
  const days = [];

  for (let i = 0; i < totalDays; i++) {
    const day = (0, _date.default)(from).add(i, 'days').startOf('day');
    let insert = !WEEKEND_INDEXES.has(day.day());

    if (exclude.some(d => d.isSame(day, 'day'))) {
      insert = false;
    }

    if (day > (0, _date.default)(to) || day < (0, _date.default)(from)) {
      insert = false;
    }

    if (include.some(d => d.isSame(day, 'day'))) {
      insert = true;
    }

    if (insert) days.push(day);
  }

  return days;
}