"use strict";

var _interopRequireWildcard = function (obj) { return obj && obj.__esModule ? obj : { "default": obj }; };

exports._params = _params;
exports._method = _method;
exports.FunctionExpression = FunctionExpression;
exports.ArrowFunctionExpression = ArrowFunctionExpression;
exports.__esModule = true;

var t = _interopRequireWildcard(require("../../types"));

function _params(node, print) {
  var _this = this;

  print(node.typeParameters);
  this.push("(");
  print.list(node.params, {
    iterator: function (node) {
      if (node.optional) _this.push("?");
      print(node.typeAnnotation);
    }
  });
  this.push(")");

  if (node.returnType) {
    print(node.returnType);
  }
}

function _method(node, print) {
  var value = node.value;
  var kind = node.kind;
  var key = node.key;

  if (!kind || kind === "init") {
    if (value.generator) {
      this.push("*");
    }
  } else {
    this.push(kind + " ");
  }

  if (value.async) this.push("async ");

  if (node.computed) {
    this.push("[");
    print(key);
    this.push("]");
  } else {
    print(key);
  }

  this._params(value, print);
  this.push(" ");
  print(value.body);
}

function FunctionExpression(node, print) {
  if (node.async) this.push("async ");
  this.push("function");
  if (node.generator) this.push("*");

  if (node.id) {
    this.push(" ");
    print(node.id);
  } else {
    this.space();
  }

  this._params(node, print);
  this.space();
  print(node.body);
}

exports.FunctionDeclaration = FunctionExpression;

function ArrowFunctionExpression(node, print) {
  if (node.async) this.push("async ");

  if (node.params.length === 1 && t.isIdentifier(node.params[0])) {
    print(node.params[0]);
  } else {
    this._params(node, print);
  }

  this.push(" => ");
  print(node.body);
}