# center-align [![NPM version](https://img.shields.io/npm/v/center-align.svg?style=flat)](https://www.npmjs.com/package/center-align) [![NPM monthly downloads](https://img.shields.io/npm/dm/center-align.svg?style=flat)](https://npmjs.org/package/center-align) [![NPM total downloads](https://img.shields.io/npm/dt/center-align.svg?style=flat)](https://npmjs.org/package/center-align) [![Linux Build Status](https://img.shields.io/travis/jonschlinkert/center-align.svg?style=flat&label=Travis)](https://travis-ci.org/jonschlinkert/center-align)

> Center-align the text in a string.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save center-align
```

## Usage

```js
var center = require('center-align');
center(val, width);
```

**Params**

* `val` **{String|Array}**: the string or array of strings to center align
* `width` **{Number}** (optional): the total width of each line in the expected result, after it's centered.

## Examples

```js
console.log(center('foo')); //=> 'foo' (does nothing)
console.log(center('foo', 12)); //=> '    foo    '
console.log(center('foo', 10)); //=> '   foo   '
console.log(center('foo', 8));  //=> '  foo  '
```

### Multiple lines

If expected `width` is not provided, the _length of the longest line_ will be used.

**Example**

If used on the following:

```js
// value can be a string, or an array of strings
center([
  'Lorem ipsum dolor sit amet,',
  'consectetur adipiscing',
  'elit, sed do eiusmod tempor incididunt',
  'ut labore et dolore',
  'magna aliqua. Ut enim ad minim',
  'veniam, quis'
]);
```

The result would be:

```
     Lorem ipsum dolor sit amet,
        consectetur adipiscing
elit, sed do eiusmod tempor incididunt
         ut labore et dolore
    magna aliqua. Ut enim ad minim
             veniam, quis
```

## About

### Related projects

* [align-text](https://www.npmjs.com/package/align-text): Align the text in a string. | [homepage](https://github.com/jonschlinkert/align-text "Align the text in a string.")
* [justified](https://www.npmjs.com/package/justified): Wrap words to a specified length and justified the text. | [homepage](https://github.com/jonschlinkert/justified "Wrap words to a specified length and justified the text.")
* [right-align](https://www.npmjs.com/package/right-align): Right-align the text in a string. | [homepage](https://github.com/jonschlinkert/right-align "Right-align the text in a string.")
* [word-wrap](https://www.npmjs.com/package/word-wrap): Wrap words to a specified length. | [homepage](https://github.com/jonschlinkert/word-wrap "Wrap words to a specified length.")

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

### Building docs

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

### Running tests

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](https://twitter.com/jonschlinkert)

### License

Copyright © 2017, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.6.0, on May 26, 2017._