// Elix is a JavaScript project, but we define TypeScript declarations so we can
// confirm our code is type safe, and to support TypeScript users.

/// <reference path="../core/shared.d.ts"/>

import ReactiveElement from "../core/ReactiveElement.js";
import DelegateFocusMixin from "./DelegateFocusMixin.js";
import { defaultTabIndex } from "./internal.js";

export default class WrappedStandardElement extends DelegateFocusMixin(
  ReactiveElement
) {
  [defaultTabIndex]: number;
  readonly inner: HTMLElement;
  setInnerProperty(name: string, value: any): void;
  static wrap(extendsTag: string): Constructor<WrappedStandardElement>;
}
