import { template } from "../base/internal.js";
import MenuItem from "../base/MenuItem.js";
import { templateFrom } from "../core/htmlLiterals.js";

/**
 * MenuItem component in the Plain reference design system
 *
 * @inherits MenuItem
 */
class PlainMenuItem extends MenuItem {
  get [template]() {
    // Apply variety of system fonts.
    // Checkmark icon from Material Design.
    return templateFrom.html`
      <style>
        :host {
          font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
          font-size: 10pt;
          white-space: nowrap;
        }

        :host([disabled]) {
          opacity: 0.5;
        }

        #checkmark {
          height: 1em;
          visibility: hidden;
          width: 1em;
        }

        :host([selected]) #checkmark {
          visibility: visible;
        }
      </style>
      <svg id="checkmark" xmlns="http://www.w3.org/2000/svg" viewBox="4 6 18 12">
        <path d="M0 0h24v24H0V0z" fill="none"/>
        <path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41L9 16.17z"/>
      </svg>
      <slot></slot>
    `;
  }
}

export default PlainMenuItem;
