/**
 * Constants used by Elix mixins and components
 *
 * Sharing these constants allows for greater consistency in things such as user
 * interface timings.
 *
 * @module constants
 */

/**
 * Time in milliseconds after which the user is considered to have stopped
 * typing.
 *
 * This is used by
 * [KeyboardPrefixCursorMixin](KeyboardPrefixCursorMixin).
 *
 * @const {number} TYPING_TIMEOUT_DURATION
 */
export const TYPING_TIMEOUT_DURATION = 1000;
