'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) subClass.__proto__ = superClass; }

var _react = require('react');

var _EnterUtils = require('./EnterUtils');

var startAnimation = require('./StartAnimation');
//const defaultKey = 'enter_' + Date.now();

var EnterAnimationChild = (function (_Component) {
  _inherits(EnterAnimationChild, _Component);

  function EnterAnimationChild(props) {
    _classCallCheck(this, EnterAnimationChild);

    _get(Object.getPrototypeOf(EnterAnimationChild.prototype), 'constructor', this).apply(this, arguments);
    this.state = {
      enter: props.enter,
      leave: props.leave,
      children: this.props.children
    };
    this.dataArr = [];
    this.key = [];
    this.direction = '';
    this.defaultType = !this.state.enter && !this.state.leave ? 'right' : this.direction === 'leave' ? this.state.leave.type || this.state.leave.style || this.state.enter.type || this.state.enter.style || 'right' : this.state.enter.type || this.state.enter.style || 'right';
  }

  /*遍历children里的dataEnter*/

  _createClass(EnterAnimationChild, [{
    key: 'callChildrenDataEnter',
    value: function callChildrenDataEnter(props, mc, arr, i) {
      var self = this,
          enter,
          leave;

      arr[i] = { enter: {}, leave: {} };

      if (props) {
        enter = (0, _EnterUtils.isPropsPushData)(props['enter-data'], props['data-enter'], self.defaultType);
        leave = (0, _EnterUtils.isPropsPushData)(props['leave-data'], props['data-leave'], enter.type || enter.style || self.defaultType);

        arr[i].enter = enter;
        //出场如果没有效果，继承进场效果；
        arr[i].leave = (0, _EnterUtils.leaveInherit)(leave, enter);

        if (typeof props.children === 'object') {
          arr[i].children = [];
          self.componentChildrenDataEnter(props.children, mc.children, arr[i].children);
        }
      } else {
        var _enter = mc.getAttribute('data-enter'),
            _leave = mc.getAttribute('data-leave');
        enter = (0, _EnterUtils.noPropsPushData)(_enter, self.defaultType);
        leave = (0, _EnterUtils.noPropsPushData)(_leave, enter.type || enter.style || self.defaultType);

        arr[i].enter = enter;
        arr[i].leave = (0, _EnterUtils.leaveInherit)(leave, enter);
        if (mc.children.length > 0) {
          arr[i].children = [];
          self.componentChildrenDataEnter(null, mc.children, arr[i].children);
        }
      }
      if (arr[i].enter.type || arr[i].enter.style || arr[i].leave.type || arr[i].leave.style) {
        self.dataArr.cBool = true;
      }
    }
  }, {
    key: 'componentChildrenDataEnter',
    value: function componentChildrenDataEnter(children, dom, arr) {
      var self = this,
          props = undefined,
          mc = undefined;
      if (children && typeof children === 'object' && children.length) {
        //有react时
        //要处理children里的enter-data,dom里的data-enter;

        children.map(function (re, i) {
          props = re.props;
          mc = dom[i];
          self.callChildrenDataEnter(props, mc, arr, i);
        });
      } else if (children) {
        props = children ? children.props : null;
        self.callChildrenDataEnter(props, dom[0], arr, 0);
      } else if (dom) {
        //router时；
        for (var i = 0; i < dom.length || 0; i++) {
          mc = dom[i];
          self.callChildrenDataEnter(null, mc, arr, i);
        }
      } else {
        return console.warn('Warning: Not perform EnterAnimation, Children is null.');
      }
    }
  }, {
    key: 'callEnterAnimation',
    value: function callEnterAnimation(dom, wap) {
      var _this = this;

      var state = this.state;

      var enter = state.enter || {},
          leave = state.leave || null;
      var transition = this.dataArr;
      var direction = this.direction;
      if (!this.dataArr.cBool) {
        transition = enter.type || enter.style || 'right';
        if (direction === 'leave' && leave) {
          transition = leave.type || leave.style || transition;
        }
      }
      var callFunc = function callFunc() {
        enter.callback.call(_this, { ReactElement: wap, target: dom, direction: direction });
      };
      var callBack = typeof enter.callback === 'function' ? callFunc : null,
          reverse = enter.reverse,
          duration = enter.duration,
          delay = enter.delay,
          interval = enter.interval,
          ease = enter.ease;
      if (direction === 'leave') {
        callBack = function () {
          //动画后;
          if (leave && typeof leave.callback === 'function') {
            leave.callback.call(_this, { ReactElement: wap, target: dom, direction: direction });
          } else if (typeof enter.callback === 'function') {
            enter.callback.call(_this, { ReactElement: wap, target: dom, direction: direction });
          }
          //出场周期结束；
          _this.props.callback.call(_this, wap, direction);
        };
        //大标签上的继承
        if (leave) {
          reverse = leave.reverse || enter.reverse;
          duration = typeof leave.duration === 'number' ? leave.duration : enter.duration;
          delay = typeof leave.delay === 'number' ? leave.delay : enter.delay;
          interval = typeof leave.interval === 'number' ? leave.interval : enter.interval;
          ease = leave.ease || enter.ease;
        }
      }
      startAnimation(dom, {
        duration: duration,
        data: transition,
        delay: delay,
        direction: direction,
        interval: interval,
        reverse: reverse,
        ease: ease,
        onComplete: callBack
      });
    }
  }, {
    key: 'setDomKey',
    value: function setDomKey() {
      //取出dom下的要做动画的节点，如果没key，自动加上

      var dom = (0, _react.findDOMNode)(this);
      if (typeof this.props.children === 'string') {
        return console.warn('Warning: Not perform EnterAnimation, Elements is String(' + this.props.children + ').');
      }
      if (typeof dom.children === 'string') {
        return console.warn('Warning: Not perform EnterAnimation, Elements is String(' + dom.children + ').');
      }
      var children = this.props.children instanceof Array ? this.props.children : this.props.children.props.children;
      var domChildren = dom.children.length >= 1 ? dom.children : dom.children.children;
      if (typeof children === 'string') {
        return console.warn('Warning: Not perform EnterAnimation, Elements is String(' + children + ').');
      }
      if (typeof domChildren === 'string') {
        return console.warn('Warning: Not perform EnterAnimation, Elements is String(' + domChildren + ').');
      }
      //dom的data-enter或reactElement的props的enter-data;
      this.componentChildrenDataEnter(children, domChildren, this.dataArr);
      //console.log(this.dataArr)
    }
  }, {
    key: 'componentDidMount',
    value: function componentDidMount() {
      //第一次进入；默认给enter；
      this.direction = 'enter';
      this.componentWillReceiveProps(this.props);
    }
  }, {
    key: 'componentDidUpdate',
    value: function componentDidUpdate() {
      var dom = (0, _react.findDOMNode)(this);
      var wap = this.props.children;
      if (this.props.direction) {
        this.props.onStart();
        this.direction = this.props.direction;
        this.callEnterAnimation(dom, wap);
      }
    }
  }, {
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      //要对新插入元素做动画;
      if (nextProps.direction) {

        var dom = (0, _react.findDOMNode)(this);
        if (nextProps.position) {
          dom.style.position = 'absolute';
        } else {
          dom.style.position = '';
        }
        this.direction = nextProps.direction;
        this.defaultType = !nextProps.enter && !nextProps.leave ? 'right' : this.direction === 'leave' && nextProps.leave ? nextProps.leave.type || nextProps.leave.style || nextProps.enter.type || nextProps.enter.style || 'right' : nextProps.enter.type || nextProps.enter.style || 'right';
        this.setDomKey();
        this.setState({
          enter: nextProps.enter,
          leave: nextProps.leave
        });
      }
    }
  }, {
    key: 'render',
    value: function render() {

      return this.props.children;
    }
  }]);

  return EnterAnimationChild;
})(_react.Component);

exports['default'] = EnterAnimationChild;
module.exports = exports['default'];