/**
 * Created by jljsj on 15/9/1.
 */
'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var utils = {
  toArrayChildren: function toArrayChildren(children) {
    var ret = [];
    _react2['default'].Children.forEach(children, function (c) {
      ret.push(c);
    });
    return ret;
  },
  //getChildrenFromProps: function (props) {
  //  const children = props.children;
  //  if (React.isValidElement(children)) {
  //    if (!children.key) {
  //      return React.cloneElement(children, {
  //        key: defaultKey
  //      });
  //    }
  //  }
  //  return obj;
  //},

  extend: function extend(des, src, override) {
    var i = undefined,
        len = src.length;
    if (src instanceof Array) {
      for (i = 0; i < len; i++) {
        utils.extend(des, src[i], override);
      }
    } else {
      for (i in src) {
        if (override || !(i in des)) {
          des[i] = src[i];
        }
      }
    }
    return des;
  },
  deleteRepeatKeyArr: function deleteRepeatKeyArr(arr) {
    var result = [],
        hash = {};
    for (var i = 0; i < arr.length; i++) {
      var elem = arr[i];
      if (elem) {
        if (elem.key) {
          if (elem && !hash[elem.key]) {
            result.push(elem);
            hash[elem.key] = true;
          }
        } else {
          result.push(elem);
        }
      }
    }
    return result;
  },
  contrastArr: function contrastArr(_a, _b, callback) {
    var _this = this;

    var a = _a,
        b = _b.concat();
    if (a.length === 0) {
      b.map(function (m) {
        callback.call(_this, m);
      });
    } else {
      a.map(function (m) {
        if (!m || !m.key) {
          return;
        }
        for (var i = 0; i < b.length; i++) {
          var cm = b[i];
          if (!cm || !cm.key || cm.key === m.key) {
            b.splice(i, 1);
          }
        }
      });
      b.map(function (m) {
        callback.call(_this, m);
      });
    }
  },
  isPropsPushData: function isPropsPushData(data, tagData, enterDataType) {
    var _data = {};
    if (data || tagData) {
      data = data || {};
      if (typeof data === 'boolean') {
        data = {};
      }
      if (typeof tagData === 'string') {
        tagData = JSON.parse(tagData);
      }
      tagData = tagData || {};
      _data = utils.extend({}, [data, tagData]);

      if (!_data.type && !_data.style) {
        _data.type = enterDataType;
      }
    }
    return _data;
  },
  noPropsPushData: function noPropsPushData(tagData, enterDataType) {
    if (typeof tagData === 'string') {
      tagData = JSON.parse(tagData);
    }
    if (tagData) {
      if (typeof tagData === 'boolean') {
        tagData = {};
      }
      if (!tagData.type && !tagData.style) {
        tagData.type = enterDataType;
      }
    }
    return tagData || {};
  },
  leaveInherit: function leaveInherit(leave, enter) {
    if (leave.type || enter.type) {
      leave.type = leave.type || enter.type;
    }
    if (leave.style || enter.style) {
      leave.style = leave.style || enter.style;
    }
    if (typeof leave.duration === 'number' || enter.duration) {
      leave.duration = typeof leave.duration === 'number' ? leave.duration : enter.duration;
    }
    if (leave.ease || enter.ease) {
      leave.ease = leave.ease || enter.ease;
    }
    if (typeof leave.delay === 'number' || enter.delay) {
      leave.delay = typeof leave.delay === 'number' ? leave.delay : enter.delay;
    }
    if (typeof leave.queueId === 'number' || enter.queueId) {
      leave.queueId = typeof leave.queueId === 'number' ? leave.queueId : enter.queueId;
    }
    return leave;
  }
};
exports['default'] = utils;
module.exports = exports['default'];