/**
 * Style declaration value parser.
 */
export default class CSSStyleDeclarationValueParser {
    /**
     * Returns length.
     *
     * @param value Value.
     * @returns Parsed value.
     */
    static getLength(value: string): string | null;
    /**
     * Returns percentance.
     *
     * @param value Value.
     * @returns Parsed value.
     */
    static getPercentage(value: string): string | null;
    /**
     * Returns degree.
     *
     * @param value Value.
     * @returns Parsed value.
     */
    static getDegree(value: string): string | null;
    /**
     * Returns calc.
     *
     * @param value Value.
     * @returns Parsed value.
     */
    static getCalc(value: string): string | null;
    /**
     * Returns fit content.
     *
     * @param value Value.
     * @returns Parsed value.
     */
    static getFitContent(value: string): string | null;
    /**
     * Returns measurement.
     *
     * @param value Value.
     * @returns Parsed value.
     */
    static getMeasurement(value: string): string | null;
    /**
     * Returns measurement or auto, min-content, max-content or fit-content.
     *
     * @param value Value.
     * @returns Parsed value.
     */
    static getContentMeasurement(value: string): string | null;
    /**
     * Returns measurement or auto, min-content, max-content or fit-content.
     *
     * @param value Value.
     * @returns Parsed value.
     */
    static getAutoMeasurement(value: string): string | null;
    /**
     * Returns integer.
     *
     * @param value Value.
     * @returns Parsed value.
     */
    static getInteger(value: string): string | null;
    /**
     * Returns float.
     *
     * @param value Value.
     * @returns Parsed value.
     */
    static getFloat(value: string): string | null;
    /**
     * Returns gradient.
     *
     * @param value Value.
     * @returns Parsed value.
     */
    static getGradient(value: string): string | null;
    /**
     * Returns color.
     *
     * @param value Value.
     * @returns Parsed value.
     */
    static getColor(value: string): string | null;
    /**
     * Returns URL.
     *
     * Based on:
     * https://github.com/jsdom/cssstyle/blob/master/lib/parsers.js#L222
     *
     * @param value Value.
     * @returns Parsed value.
     */
    static getURL(value: string): string | null;
    /**
     * Returns global initial value.
     *
     * @param value Value.
     * @returns Parsed value.
     */
    static getInitial(value: string): string | null;
    /**
     * Returns CSS variable.
     *
     * @param value Value.
     * @returns Parsed value.
     */
    static getVariable(value: string): string | null;
    /**
     * Returns global.
     *
     * @param value Value.
     * @returns Parsed value.
     */
    static getGlobal(value: string): string | null;
    /**
     * Returns global, unless it is not set to 'initial' as it is sometimes treated different.
     *
     * @param value Value.
     * @returns Parsed value.
     */
    static getGlobalExceptInitial(value: string): string | null;
}
//# sourceMappingURL=CSSStyleDeclarationValueParser.d.ts.map