"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const PropertySymbol = __importStar(require("../PropertySymbol.cjs"));
const WindowBrowserContext_js_1 = __importDefault(require("../window/WindowBrowserContext.cjs"));
/**
 * Custom element reaction stack.
 *
 * @see https://html.spec.whatwg.org/multipage/custom-elements.html#custom-element-reactions-stack
 */
class CustomElementReactionStack {
    window;
    /**
     * Constructor.
     *
     * @param window Window.
     */
    constructor(window) {
        this.window = window;
    }
    /**
     * Enqueues a custom element reaction.
     *
     * @see https://html.spec.whatwg.org/multipage/custom-elements.html#enqueue-a-custom-element-callback-reaction
     * @see https://html.spec.whatwg.org/multipage/custom-elements.html#enqueue-an-element-on-the-appropriate-element-queue
     * @param element Element.
     * @param callbackName Callback name.
     * @param [args] Arguments.
     */
    enqueueReaction(element, callbackName, args) {
        // If a polyfill is used, [PropertySymbol.registry] may be undefined
        const definition = this.window.customElements[PropertySymbol.registry]?.get(element.localName);
        if (!definition) {
            return;
        }
        // If the element is not connected to the main document, we should not invoke the callback.
        if (element[PropertySymbol.ownerDocument] !== this.window.document) {
            return;
        }
        // According to the spec, we should use a queue for each element and then invoke the reactions in the order they were enqueued asynchronously.
        // However, the browser seem to always invoke the reactions synchronously.
        // TODO: Can we find an example where the reactions are invoked asynchronously? In that case we should use a queue for those cases.
        switch (callbackName) {
            case 'connectedCallback':
                if (definition.livecycleCallbacks.connectedCallback) {
                    const returnValue = definition.livecycleCallbacks.connectedCallback?.call(element);
                    /**
                     * It is common to import dependencies in the connectedCallback() method of web components.
                     * As Happy DOM doesn't have support for dynamic imports yet, this is a temporary solution to wait for imports in connectedCallback().
                     *
                     * @see https://github.com/capricorn86/happy-dom/issues/1442
                     */
                    if (returnValue instanceof Promise) {
                        const asyncTaskManager = new WindowBrowserContext_js_1.default(this.window).getAsyncTaskManager();
                        if (asyncTaskManager) {
                            const taskID = asyncTaskManager.startTask();
                            returnValue
                                .then(() => asyncTaskManager.endTask(taskID))
                                .catch(() => asyncTaskManager.endTask(taskID));
                        }
                    }
                }
                break;
            case 'disconnectedCallback':
                if (definition.livecycleCallbacks.disconnectedCallback) {
                    definition.livecycleCallbacks.disconnectedCallback.call(element);
                }
                break;
            case 'attributeChangedCallback':
                if (definition.livecycleCallbacks.attributeChangedCallback &&
                    args?.length &&
                    definition.observedAttributes.has(args[0])) {
                    definition.livecycleCallbacks.attributeChangedCallback.apply(element, args);
                }
                break;
        }
    }
}
exports.default = CustomElementReactionStack;
//# sourceMappingURL=CustomElementReactionStack.cjs.map