"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const Document_js_1 = __importDefault(require("../document/Document.cjs"));
const PropertySymbol = __importStar(require("../../PropertySymbol.cjs"));
const NodeTypeEnum_js_1 = __importDefault(require("../node/NodeTypeEnum.cjs"));
/**
 * Document.
 */
class HTMLDocument extends Document_js_1.default {
    /**
     * Constructor.
     */
    constructor() {
        super();
        // Default document elements
        const documentElement = this.createElement('html');
        const bodyElement = this.createElement('body');
        const headElement = this.createElement('head');
        this.appendChild(documentElement);
        documentElement.appendChild(headElement);
        documentElement.appendChild(bodyElement);
    }
    /**
     * @override
     */
    [PropertySymbol.appendChild](node, disableValidations = false) {
        if (node[PropertySymbol.nodeType] === NodeTypeEnum_js_1.default.textNode) {
            throw new this[PropertySymbol.window].Error(`Failed to execute 'appendChild' on 'Node': Nodes of type '#text' may not be inserted inside nodes of type '#document'.`);
        }
        if (node[PropertySymbol.nodeType] === NodeTypeEnum_js_1.default.documentFragmentNode) {
            return node;
        }
        if (node[PropertySymbol.nodeType] === NodeTypeEnum_js_1.default.elementNode &&
            this[PropertySymbol.elementArray].length !== 0) {
            throw new this[PropertySymbol.window].Error(`Failed to execute 'appendChild' on 'Node': Only one element on document allowed.`);
        }
        return super[PropertySymbol.appendChild](node, disableValidations);
    }
    /**
     * @override
     */
    [PropertySymbol.insertBefore](newNode, referenceNode, disableValidations = false) {
        if (newNode[PropertySymbol.nodeType] === NodeTypeEnum_js_1.default.textNode) {
            throw new this[PropertySymbol.window].Error(`Failed to execute 'insertBefore' on 'Node': Nodes of type '#text' may not be inserted inside nodes of type '#document'.`);
        }
        if (newNode[PropertySymbol.nodeType] === NodeTypeEnum_js_1.default.documentFragmentNode) {
            return newNode;
        }
        if (newNode[PropertySymbol.nodeType] === NodeTypeEnum_js_1.default.elementNode &&
            this[PropertySymbol.elementArray].length !== 0) {
            throw new this[PropertySymbol.window].Error(`Failed to execute 'insertBefore' on 'Node': Only one element on document allowed.`);
        }
        return super[PropertySymbol.insertBefore](newNode, referenceNode, disableValidations);
    }
}
exports.default = HTMLDocument;
//# sourceMappingURL=HTMLDocument.cjs.map