import HTMLElement from '../html-element/HTMLElement.cjs';
import * as PropertySymbol from '../../PropertySymbol.cjs';
import Text from '../text/Text.cjs';
import Element from '../element/Element.cjs';
import Node from '../node/Node.cjs';
import Event from '../../event/Event.cjs';
import Attr from '../attr/Attr.cjs';
/**
 * HTML Slot Element.
 *
 * Reference:
 * https://developer.mozilla.org/en-US/docs/Web/API/HTMLSlotElement.
 */
export default class HTMLSlotElement extends HTMLElement {
    #private;
    cloneNode: (deep?: boolean) => HTMLSlotElement;
    [PropertySymbol.assignedNodes]: Node[];
    get onslotchange(): ((event: Event) => void) | null;
    set onslotchange(value: ((event: Event) => void) | null);
    /**
     * Returns name.
     *
     * @returns Name.
     */
    get name(): string;
    /**
     * Sets name.
     *
     * @param name Name.
     */
    set name(name: string);
    /**
     * Sets the slot's manually assigned nodes to an ordered set of slottables.
     *
     * @param nodes Nodes.
     */
    assign(...nodes: Array<Text | Element>): void;
    /**
     * Returns assigned nodes.
     *
     * @param [options] Options.
     * @param [options.flatten] A boolean value indicating whether to return the assigned nodes of any available child <slot> elements (true) or not (false). Defaults to false.
     * @returns Nodes.
     */
    assignedNodes(options?: {
        flatten?: boolean;
    }): Node[];
    /**
     * Returns assigned elements.
     *
     * @param [options] Options.
     * @param [options.flatten] A boolean value indicating whether to return the assigned elements of any available child <slot> elements (true) or not (false). Defaults to false.
     * @returns Nodes.
     */
    assignedElements(options?: {
        flatten?: boolean;
    }): Element[];
    /**
     * @override
     */
    [PropertySymbol.cloneNode](deep?: boolean): HTMLSlotElement;
    /**
     * @override
     */
    [PropertySymbol.onSetAttribute](attribute: Attr, replacedAttribute: Attr | null): void;
    /**
     * @override
     */
    [PropertySymbol.onRemoveAttribute](removedAttribute: Attr): void;
}
//# sourceMappingURL=HTMLSlotElement.d.ts.map