import HTMLElement from '../html-element/HTMLElement.cjs';
/**
 * HTMLTableCellElement
 *
 * @see https://developer.mozilla.org/en-US/docs/Web/API/HTMLTableCellElement
 */
export default class HTMLTableCellElement extends HTMLElement {
    /**
     * Returns abbr.
     *
     * @returns Abbr.
     */
    get abbr(): string;
    /**
     * Sets abbr.
     *
     * @param value Abbr.
     */
    set abbr(value: string);
    /**
     * A number representing the cell's position in the cells collection of the <tr> the cell is contained within. If the cell doesn't belong to a <tr>, it returns -1.
     *
     * @returns Cell index.
     */
    get cellIndex(): number;
    /**
     * Returns colspan.
     *
     * @returns Colspan.
     */
    get colSpan(): number;
    /**
     * Sets colspan.
     *
     * @param value Colspan.
     */
    set colSpan(value: number);
    /**
     * Returns headers.
     *
     * @returns headers.
     */
    get headers(): string;
    /**
     * Sets headers.
     *
     * @param value headers.
     */
    set headers(value: string);
    /**
     * Returns rowspan.
     *
     * @returns Rowspan.
     */
    get rowSpan(): number;
    /**
     * Sets rowspan.
     *
     * @param value Rowspan.
     */
    set rowSpan(value: number);
    /**
     * Returns scope.
     *
     * @returns Scope.
     */
    get scope(): string;
    /**
     * Sets scope.
     *
     * @param value Scope.
     */
    set scope(value: string);
}
//# sourceMappingURL=HTMLTableCellElement.d.ts.map