import DocumentFragment from '../document-fragment/DocumentFragment.cjs';
import * as PropertySymbol from '../../PropertySymbol.cjs';
import Element from '../element/Element.cjs';
import CSSStyleSheet from '../../css/CSSStyleSheet.cjs';
import HTMLElement from '../../nodes/html-element/HTMLElement.cjs';
import Event from '../../event/Event.cjs';
import SVGElement from '../svg-element/SVGElement.cjs';
/**
 * ShadowRoot.
 */
export default class ShadowRoot extends DocumentFragment {
    cloneNode: (deep?: boolean) => ShadowRoot;
    [PropertySymbol.adoptedStyleSheets]: CSSStyleSheet[];
    [PropertySymbol.mode]: string;
    [PropertySymbol.host]: Element | null;
    [PropertySymbol.clonable]: boolean;
    [PropertySymbol.delegatesFocus]: boolean;
    [PropertySymbol.serializable]: boolean;
    [PropertySymbol.slotAssignment]: 'named' | 'manual';
    [PropertySymbol.propertyEventListeners]: Map<string, ((event: Event) => void) | null>;
    get onslotchange(): ((event: Event) => void) | null;
    set onslotchange(value: ((event: Event) => void) | null);
    /**
     * Returns mode.
     *
     * @returns Mode.
     */
    get mode(): string;
    /**
     * Returns host.
     *
     * @returns Host.
     */
    get host(): Element | null;
    /**
     * Returns clonable.
     *
     * @returns Clonable.
     */
    get clonable(): boolean;
    /**
     * Returns delegates focus.
     *
     * @returns Delegates focus.
     */
    get delegatesFocus(): boolean;
    /**
     * Returns serializable.
     *
     * @returns Serializable.
     */
    get serializable(): boolean;
    /**
     * Returns slot assignment.
     *
     * @returns Slot assignment.
     */
    get slotAssignment(): 'named' | 'manual';
    /**
     * The element that's currently in full screen mode for this shadow tree.
     *
     * @returns Fullscreen element.
     */
    get fullscreenElement(): Element | null;
    /**
     * Returns the Element within the shadow tree that is currently being presented in picture-in-picture mode.
     *
     * @returns Picture-in-picture element.
     */
    get pictureInPictureElement(): Element | null;
    /**
     * Returns the Element set as the target for mouse events while the pointer is locked. null if lock is pending, pointer is unlocked, or if the target is in another tree.
     *
     * @returns Pointer lock element.
     */
    get pointerLockElement(): Element | null;
    /**
     * Returns inner HTML.
     *
     * @returns HTML.
     */
    get innerHTML(): string;
    /**
     * Sets inner HTML.
     *
     * @param html HTML.
     */
    set innerHTML(html: string);
    /**
     * Returns adopted style sheets.
     *
     * @returns Adopted style sheets.
     */
    get adoptedStyleSheets(): CSSStyleSheet[];
    /**
     * Sets adopted style sheets.
     *
     * @param value Adopted style sheets.
     */
    set adoptedStyleSheets(value: CSSStyleSheet[]);
    /**
     * Returns active element.
     *
     * @returns Active element.
     */
    get activeElement(): HTMLElement | SVGElement | null;
    /**
     * Returns an array of all Animation objects currently in effect, whose target elements are descendants of the shadow tree.
     *
     * @returns Array of animations.
     */
    getAnimations(): object[];
    /**
     * Parses a string of HTML into a document fragment, without sanitization, which then replaces the shadowroot's original subtree. The HTML string may include declarative shadow roots, which would be parsed as template elements the HTML was set using ShadowRoot.innerHTML.
     *
     * @param html HTML.
     */
    setHTMLUnsafe(html: string): void;
    /**
     * Converts to string.
     *
     * @returns String.
     */
    toString(): string;
    /**
     * @override
     */
    [PropertySymbol.cloneNode](deep?: boolean): ShadowRoot;
}
//# sourceMappingURL=ShadowRoot.d.ts.map