import CSSStyleDeclaration from '../../css/declaration/CSSStyleDeclaration.cjs';
import * as PropertySymbol from '../../PropertySymbol.cjs';
import Element from '../element/Element.cjs';
import SVGSVGElement from '../svg-svg-element/SVGSVGElement.cjs';
import Event from '../../event/Event.cjs';
import DOMStringMap from '../../dom/DOMStringMap.cjs';
/**
 * SVG Element.
 *
 * Reference:
 * https://developer.mozilla.org/en-US/docs/Web/API/SVGElement.
 */
export default class SVGElement extends Element {
    #private;
    [PropertySymbol.style]: CSSStyleDeclaration | null;
    get onabort(): ((event: Event) => void) | null;
    set onabort(value: ((event: Event) => void) | null);
    get onanimationend(): ((event: Event) => void) | null;
    set onanimationend(value: ((event: Event) => void) | null);
    get onanimationiteration(): ((event: Event) => void) | null;
    set onanimationiteration(value: ((event: Event) => void) | null);
    get onanimationstart(): ((event: Event) => void) | null;
    set onanimationstart(value: ((event: Event) => void) | null);
    get onauxclick(): ((event: Event) => void) | null;
    set onauxclick(value: ((event: Event) => void) | null);
    get onblur(): ((event: Event) => void) | null;
    set onblur(value: ((event: Event) => void) | null);
    get oncancel(): ((event: Event) => void) | null;
    set oncancel(value: ((event: Event) => void) | null);
    get oncanplay(): ((event: Event) => void) | null;
    set oncanplay(value: ((event: Event) => void) | null);
    get oncanplaythrough(): ((event: Event) => void) | null;
    set oncanplaythrough(value: ((event: Event) => void) | null);
    get onchange(): ((event: Event) => void) | null;
    set onchange(value: ((event: Event) => void) | null);
    get onclick(): ((event: Event) => void) | null;
    set onclick(value: ((event: Event) => void) | null);
    get onclose(): ((event: Event) => void) | null;
    set onclose(value: ((event: Event) => void) | null);
    get oncontextmenu(): ((event: Event) => void) | null;
    set oncontextmenu(value: ((event: Event) => void) | null);
    get oncopy(): ((event: Event) => void) | null;
    set oncopy(value: ((event: Event) => void) | null);
    get oncuechange(): ((event: Event) => void) | null;
    set oncuechange(value: ((event: Event) => void) | null);
    get oncut(): ((event: Event) => void) | null;
    set oncut(value: ((event: Event) => void) | null);
    get ondblclick(): ((event: Event) => void) | null;
    set ondblclick(value: ((event: Event) => void) | null);
    get ondrag(): ((event: Event) => void) | null;
    set ondrag(value: ((event: Event) => void) | null);
    get ondragend(): ((event: Event) => void) | null;
    set ondragend(value: ((event: Event) => void) | null);
    get ondragenter(): ((event: Event) => void) | null;
    set ondragenter(value: ((event: Event) => void) | null);
    get ondragleave(): ((event: Event) => void) | null;
    set ondragleave(value: ((event: Event) => void) | null);
    get ondragover(): ((event: Event) => void) | null;
    set ondragover(value: ((event: Event) => void) | null);
    get ondragstart(): ((event: Event) => void) | null;
    set ondragstart(value: ((event: Event) => void) | null);
    get ondrop(): ((event: Event) => void) | null;
    set ondrop(value: ((event: Event) => void) | null);
    get ondurationchange(): ((event: Event) => void) | null;
    set ondurationchange(value: ((event: Event) => void) | null);
    get onemptied(): ((event: Event) => void) | null;
    set onemptied(value: ((event: Event) => void) | null);
    get onended(): ((event: Event) => void) | null;
    set onended(value: ((event: Event) => void) | null);
    get onerror(): ((event: Event) => void) | null;
    set onerror(value: ((event: Event) => void) | null);
    get onfocus(): ((event: Event) => void) | null;
    set onfocus(value: ((event: Event) => void) | null);
    get onformdata(): ((event: Event) => void) | null;
    set onformdata(value: ((event: Event) => void) | null);
    get ongotpointercapture(): ((event: Event) => void) | null;
    set ongotpointercapture(value: ((event: Event) => void) | null);
    get oninput(): ((event: Event) => void) | null;
    set oninput(value: ((event: Event) => void) | null);
    get oninvalid(): ((event: Event) => void) | null;
    set oninvalid(value: ((event: Event) => void) | null);
    get onkeydown(): ((event: Event) => void) | null;
    set onkeydown(value: ((event: Event) => void) | null);
    get onkeypress(): ((event: Event) => void) | null;
    set onkeypress(value: ((event: Event) => void) | null);
    get onkeyup(): ((event: Event) => void) | null;
    set onkeyup(value: ((event: Event) => void) | null);
    get onload(): ((event: Event) => void) | null;
    set onload(value: ((event: Event) => void) | null);
    get onloadeddata(): ((event: Event) => void) | null;
    set onloadeddata(value: ((event: Event) => void) | null);
    get onloadedmetadata(): ((event: Event) => void) | null;
    set onloadedmetadata(value: ((event: Event) => void) | null);
    get onloadstart(): ((event: Event) => void) | null;
    set onloadstart(value: ((event: Event) => void) | null);
    get onlostpointercapture(): ((event: Event) => void) | null;
    set onlostpointercapture(value: ((event: Event) => void) | null);
    get onmousedown(): ((event: Event) => void) | null;
    set onmousedown(value: ((event: Event) => void) | null);
    get onmouseenter(): ((event: Event) => void) | null;
    set onmouseenter(value: ((event: Event) => void) | null);
    get onmouseleave(): ((event: Event) => void) | null;
    set onmouseleave(value: ((event: Event) => void) | null);
    get onmousemove(): ((event: Event) => void) | null;
    set onmousemove(value: ((event: Event) => void) | null);
    get onmouseout(): ((event: Event) => void) | null;
    set onmouseout(value: ((event: Event) => void) | null);
    get onmouseover(): ((event: Event) => void) | null;
    set onmouseover(value: ((event: Event) => void) | null);
    get onmouseup(): ((event: Event) => void) | null;
    set onmouseup(value: ((event: Event) => void) | null);
    get onmousewheel(): ((event: Event) => void) | null;
    set onmousewheel(value: ((event: Event) => void) | null);
    get onpaste(): ((event: Event) => void) | null;
    set onpaste(value: ((event: Event) => void) | null);
    get onpause(): ((event: Event) => void) | null;
    set onpause(value: ((event: Event) => void) | null);
    get onplay(): ((event: Event) => void) | null;
    set onplay(value: ((event: Event) => void) | null);
    get onplaying(): ((event: Event) => void) | null;
    set onplaying(value: ((event: Event) => void) | null);
    get onpointercancel(): ((event: Event) => void) | null;
    set onpointercancel(value: ((event: Event) => void) | null);
    get onpointerdown(): ((event: Event) => void) | null;
    set onpointerdown(value: ((event: Event) => void) | null);
    get onpointerenter(): ((event: Event) => void) | null;
    set onpointerenter(value: ((event: Event) => void) | null);
    get onpointerleave(): ((event: Event) => void) | null;
    set onpointerleave(value: ((event: Event) => void) | null);
    get onpointermove(): ((event: Event) => void) | null;
    set onpointermove(value: ((event: Event) => void) | null);
    get onpointerout(): ((event: Event) => void) | null;
    set onpointerout(value: ((event: Event) => void) | null);
    get onpointerover(): ((event: Event) => void) | null;
    set onpointerover(value: ((event: Event) => void) | null);
    get onpointerrawupdate(): ((event: Event) => void) | null;
    set onpointerrawupdate(value: ((event: Event) => void) | null);
    get onpointerup(): ((event: Event) => void) | null;
    set onpointerup(value: ((event: Event) => void) | null);
    get onprogress(): ((event: Event) => void) | null;
    set onprogress(value: ((event: Event) => void) | null);
    get onratechange(): ((event: Event) => void) | null;
    set onratechange(value: ((event: Event) => void) | null);
    get onreset(): ((event: Event) => void) | null;
    set onreset(value: ((event: Event) => void) | null);
    get onresize(): ((event: Event) => void) | null;
    set onresize(value: ((event: Event) => void) | null);
    get onscroll(): ((event: Event) => void) | null;
    set onscroll(value: ((event: Event) => void) | null);
    get onscrollend(): ((event: Event) => void) | null;
    set onscrollend(value: ((event: Event) => void) | null);
    get onscrollsnapchange(): ((event: Event) => void) | null;
    set onscrollsnapchange(value: ((event: Event) => void) | null);
    get onscrollsnapchanging(): ((event: Event) => void) | null;
    set onscrollsnapchanging(value: ((event: Event) => void) | null);
    get onsecuritypolicyviolation(): ((event: Event) => void) | null;
    set onsecuritypolicyviolation(value: ((event: Event) => void) | null);
    get onseeked(): ((event: Event) => void) | null;
    set onseeked(value: ((event: Event) => void) | null);
    get onseeking(): ((event: Event) => void) | null;
    set onseeking(value: ((event: Event) => void) | null);
    get onselect(): ((event: Event) => void) | null;
    set onselect(value: ((event: Event) => void) | null);
    get onselectionchange(): ((event: Event) => void) | null;
    set onselectionchange(value: ((event: Event) => void) | null);
    get onselectstart(): ((event: Event) => void) | null;
    set onselectstart(value: ((event: Event) => void) | null);
    get onslotchange(): ((event: Event) => void) | null;
    set onslotchange(value: ((event: Event) => void) | null);
    get onstalled(): ((event: Event) => void) | null;
    set onstalled(value: ((event: Event) => void) | null);
    get onsubmit(): ((event: Event) => void) | null;
    set onsubmit(value: ((event: Event) => void) | null);
    get onsuspend(): ((event: Event) => void) | null;
    set onsuspend(value: ((event: Event) => void) | null);
    get ontimeupdate(): ((event: Event) => void) | null;
    set ontimeupdate(value: ((event: Event) => void) | null);
    get ontoggle(): ((event: Event) => void) | null;
    set ontoggle(value: ((event: Event) => void) | null);
    get ontransitioncancel(): ((event: Event) => void) | null;
    set ontransitioncancel(value: ((event: Event) => void) | null);
    get ontransitionend(): ((event: Event) => void) | null;
    set ontransitionend(value: ((event: Event) => void) | null);
    get ontransitionrun(): ((event: Event) => void) | null;
    set ontransitionrun(value: ((event: Event) => void) | null);
    get ontransitionstart(): ((event: Event) => void) | null;
    set ontransitionstart(value: ((event: Event) => void) | null);
    get onvolumechange(): ((event: Event) => void) | null;
    set onvolumechange(value: ((event: Event) => void) | null);
    get onwaiting(): ((event: Event) => void) | null;
    set onwaiting(value: ((event: Event) => void) | null);
    get onwheel(): ((event: Event) => void) | null;
    set onwheel(value: ((event: Event) => void) | null);
    /**
     * Returns current translate.
     *
     * @returns Element.
     */
    get ownerSVGElement(): SVGSVGElement | null;
    /**
     * Returns the SVGElement which established the current viewport. Often the nearest ancestor <svg> element. null if the given element is the outermost <svg> element.
     *
     * @returns SVG element.
     */
    get viewportElement(): SVGElement | null;
    /**
     * Returns data set.
     *
     * @returns Data set.
     */
    get dataset(): DOMStringMap;
    /**
     * Returns style.
     *
     * @returns Style.
     */
    get style(): CSSStyleDeclaration;
    /**
     * Returns tab index.
     *
     * @returns Tab index.
     */
    get tabIndex(): number;
    /**
     * Returns tab index.
     *
     * @param tabIndex Tab index.
     */
    set tabIndex(tabIndex: number);
    /**
     * Triggers a blur event.
     */
    blur(): void;
    /**
     * Triggers a focus event.
     */
    focus(): void;
}
//# sourceMappingURL=SVGElement.d.ts.map