"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const ClassMethodBinder_js_1 = __importDefault(require("../utilities/ClassMethodBinder.cjs"));
const PropertySymbol = __importStar(require("../PropertySymbol.cjs"));
/**
 * Storage.
 *
 * @see https://developer.mozilla.org/en-US/docs/Web/API/Storage
 */
class Storage {
    [PropertySymbol.data] = {};
    /**
     * Constructor.
     */
    constructor() {
        const data = this[PropertySymbol.data];
        const methodBinder = new ClassMethodBinder_js_1.default(this, [Storage]);
        return new Proxy(this, {
            get: (target, property) => {
                if (property in target || typeof property === 'symbol') {
                    methodBinder.bind(property);
                    return target[property];
                }
                if (property in data) {
                    return data[property];
                }
            },
            set(target, property, newValue) {
                methodBinder.bind(property);
                if (property in target || typeof property === 'symbol') {
                    return true;
                }
                data[String(property)] = String(newValue);
                return true;
            },
            deleteProperty(_target, property) {
                if (property in data) {
                    delete data[String(property)];
                    return true;
                }
                return false;
            },
            ownKeys() {
                return Object.keys(data);
            },
            has(target, property) {
                if (property in target || property in data) {
                    return true;
                }
                return false;
            },
            defineProperty(target, property, descriptor) {
                methodBinder.preventBinding(property);
                if (property in target) {
                    Object.defineProperty(target, property, descriptor);
                    return true;
                }
                if (descriptor.value !== undefined) {
                    data[String(property)] = String(descriptor.value);
                    return true;
                }
                return false;
            },
            getOwnPropertyDescriptor(target, property) {
                if (property in target) {
                    return;
                }
                const value = data[String(property)];
                if (value !== undefined) {
                    return {
                        value: value,
                        writable: true,
                        enumerable: true,
                        configurable: true
                    };
                }
            }
        });
    }
    /**
     * Returns length.
     *
     * @returns Length.
     */
    get length() {
        return Object.keys(this[PropertySymbol.data]).length;
    }
    /**
     * Returns name of the nth key.
     *
     * @param index Index.
     * @returns Name.
     */
    key(index) {
        const name = Object.keys(this[PropertySymbol.data])[index];
        return name !== undefined ? name : null;
    }
    /**
     * Sets item.
     *
     * @param name Name.
     * @param item Item.
     */
    setItem(name, item) {
        this[PropertySymbol.data][name] = String(item);
    }
    /**
     * Returns item.
     *
     * @param name Name.
     * @returns Item.
     */
    getItem(name) {
        return this[PropertySymbol.data][name] !== undefined ? this[PropertySymbol.data][name] : null;
    }
    /**
     * Removes item.
     *
     * @param name Name.
     */
    removeItem(name) {
        delete this[PropertySymbol.data][name];
    }
    /**
     * Clears storage.
     */
    clear() {
        const data = this[PropertySymbol.data];
        for (const key of Object.keys(data)) {
            delete data[key];
        }
    }
}
exports.default = Storage;
//# sourceMappingURL=Storage.cjs.map