import { Buffer } from 'buffer';
import { webcrypto } from 'crypto';
import { TextEncoder, TextDecoder } from 'util';
import Stream from 'stream';
import { ReadableStream } from 'stream/web';
import { URLSearchParams } from 'url';
import * as PropertySymbol from '../PropertySymbol.cjs';
import IBrowserFrame from '../browser/types/IBrowserFrame.cjs';
import Clipboard from '../clipboard/Clipboard.cjs';
import ClipboardItem from '../clipboard/ClipboardItem.cjs';
import CSS from '../css/CSS.cjs';
import CSSRule from '../css/CSSRule.cjs';
import CSSStyleSheet from '../css/CSSStyleSheet.cjs';
import CSSUnitValue from '../css/CSSUnitValue.cjs';
import CSSStyleDeclaration from '../css/declaration/CSSStyleDeclaration.cjs';
import CSSContainerRule from '../css/rules/CSSContainerRule.cjs';
import CSSFontFaceRule from '../css/rules/CSSFontFaceRule.cjs';
import CSSKeyframeRule from '../css/rules/CSSKeyframeRule.cjs';
import CSSKeyframesRule from '../css/rules/CSSKeyframesRule.cjs';
import CSSMediaRule from '../css/rules/CSSMediaRule.cjs';
import CSSStyleRule from '../css/rules/CSSStyleRule.cjs';
import CSSSupportsRule from '../css/rules/CSSSupportsRule.cjs';
import CustomElementRegistry from '../custom-element/CustomElementRegistry.cjs';
import DOMParser from '../dom-parser/DOMParser.cjs';
import DataTransfer from '../event/DataTransfer.cjs';
import DataTransferItem from '../event/DataTransferItem.cjs';
import DataTransferItemList from '../event/DataTransferItemList.cjs';
import Event from '../event/Event.cjs';
import EventTarget from '../event/EventTarget.cjs';
import MessagePort from '../event/MessagePort.cjs';
import Touch from '../event/Touch.cjs';
import UIEvent from '../event/UIEvent.cjs';
import AnimationEvent from '../event/events/AnimationEvent.cjs';
import ClipboardEvent from '../event/events/ClipboardEvent.cjs';
import CustomEvent from '../event/events/CustomEvent.cjs';
import ErrorEvent from '../event/events/ErrorEvent.cjs';
import FocusEvent from '../event/events/FocusEvent.cjs';
import HashChangeEvent from '../event/events/HashChangeEvent.cjs';
import InputEvent from '../event/events/InputEvent.cjs';
import KeyboardEvent from '../event/events/KeyboardEvent.cjs';
import MediaQueryListEvent from '../event/events/MediaQueryListEvent.cjs';
import MessageEvent from '../event/events/MessageEvent.cjs';
import MouseEvent from '../event/events/MouseEvent.cjs';
import PointerEvent from '../event/events/PointerEvent.cjs';
import ProgressEvent from '../event/events/ProgressEvent.cjs';
import StorageEvent from '../event/events/StorageEvent.cjs';
import SubmitEvent from '../event/events/SubmitEvent.cjs';
import TouchEvent from '../event/events/TouchEvent.cjs';
import WheelEvent from '../event/events/WheelEvent.cjs';
import DOMException from '../exception/DOMException.cjs';
import AbortController from '../fetch/AbortController.cjs';
import AbortSignal from '../fetch/AbortSignal.cjs';
import Headers from '../fetch/Headers.cjs';
import Request from '../fetch/Request.cjs';
import Response from '../fetch/Response.cjs';
import IRequestInfo from '../fetch/types/IRequestInfo.cjs';
import IRequestInit from '../fetch/types/IRequestInit.cjs';
import Blob from '../file/Blob.cjs';
import File from '../file/File.cjs';
import FileReader from '../file/FileReader.cjs';
import FormData from '../form-data/FormData.cjs';
import History from '../history/History.cjs';
import IntersectionObserver from '../intersection-observer/IntersectionObserver.cjs';
import IntersectionObserverEntry from '../intersection-observer/IntersectionObserverEntry.cjs';
import Location from '../location/Location.cjs';
import MediaQueryList from '../match-media/MediaQueryList.cjs';
import MutationObserver from '../mutation-observer/MutationObserver.cjs';
import MutationRecord from '../mutation-observer/MutationRecord.cjs';
import MimeType from '../navigator/MimeType.cjs';
import MimeTypeArray from '../navigator/MimeTypeArray.cjs';
import Navigator from '../navigator/Navigator.cjs';
import Plugin from '../navigator/Plugin.cjs';
import PluginArray from '../navigator/PluginArray.cjs';
import Attr from '../nodes/attr/Attr.cjs';
import CharacterData from '../nodes/character-data/CharacterData.cjs';
import Comment from '../nodes/comment/Comment.cjs';
import DocumentFragment from '../nodes/document-fragment/DocumentFragment.cjs';
import DocumentType from '../nodes/document-type/DocumentType.cjs';
import Document from '../nodes/document/Document.cjs';
import DocumentReadyStateManager from '../nodes/document/DocumentReadyStateManager.cjs';
import DOMRect from '../dom/DOMRect.cjs';
import DOMRectReadOnly from '../dom/DOMRectReadOnly.cjs';
import Element from '../nodes/element/Element.cjs';
import HTMLCollection from '../nodes/element/HTMLCollection.cjs';
import NamedNodeMap from '../nodes/element/NamedNodeMap.cjs';
import HTMLAnchorElement from '../nodes/html-anchor-element/HTMLAnchorElement.cjs';
import HTMLAreaElement from '../nodes/html-area-element/HTMLAreaElement.cjs';
import Audio from '../nodes/html-audio-element/Audio.cjs';
import HTMLAudioElement from '../nodes/html-audio-element/HTMLAudioElement.cjs';
import HTMLBaseElement from '../nodes/html-base-element/HTMLBaseElement.cjs';
import HTMLBodyElement from '../nodes/html-body-element/HTMLBodyElement.cjs';
import HTMLBRElement from '../nodes/html-br-element/HTMLBRElement.cjs';
import HTMLButtonElement from '../nodes/html-button-element/HTMLButtonElement.cjs';
import HTMLCanvasElement from '../nodes/html-canvas-element/HTMLCanvasElement.cjs';
import HTMLDListElement from '../nodes/html-d-list-element/HTMLDListElement.cjs';
import HTMLDataElement from '../nodes/html-data-element/HTMLDataElement.cjs';
import HTMLDataListElement from '../nodes/html-data-list-element/HTMLDataListElement.cjs';
import HTMLDetailsElement from '../nodes/html-details-element/HTMLDetailsElement.cjs';
import HTMLDialogElement from '../nodes/html-dialog-element/HTMLDialogElement.cjs';
import HTMLDivElement from '../nodes/html-div-element/HTMLDivElement.cjs';
import HTMLDocument from '../nodes/html-document/HTMLDocument.cjs';
import HTMLElement from '../nodes/html-element/HTMLElement.cjs';
import HTMLEmbedElement from '../nodes/html-embed-element/HTMLEmbedElement.cjs';
import HTMLFieldSetElement from '../nodes/html-field-set-element/HTMLFieldSetElement.cjs';
import HTMLFormControlsCollection from '../nodes/html-form-element/HTMLFormControlsCollection.cjs';
import HTMLFormElement from '../nodes/html-form-element/HTMLFormElement.cjs';
import RadioNodeList from '../nodes/html-form-element/RadioNodeList.cjs';
import HTMLHeadElement from '../nodes/html-head-element/HTMLHeadElement.cjs';
import HTMLHeadingElement from '../nodes/html-heading-element/HTMLHeadingElement.cjs';
import HTMLHRElement from '../nodes/html-hr-element/HTMLHRElement.cjs';
import HTMLHtmlElement from '../nodes/html-html-element/HTMLHtmlElement.cjs';
import HTMLIFrameElement from '../nodes/html-iframe-element/HTMLIFrameElement.cjs';
import HTMLImageElement from '../nodes/html-image-element/HTMLImageElement.cjs';
import Image from '../nodes/html-image-element/Image.cjs';
import FileList from '../nodes/html-input-element/FileList.cjs';
import HTMLInputElement from '../nodes/html-input-element/HTMLInputElement.cjs';
import HTMLLabelElement from '../nodes/html-label-element/HTMLLabelElement.cjs';
import HTMLLegendElement from '../nodes/html-legend-element/HTMLLegendElement.cjs';
import HTMLLIElement from '../nodes/html-li-element/HTMLLIElement.cjs';
import HTMLLinkElement from '../nodes/html-link-element/HTMLLinkElement.cjs';
import HTMLMapElement from '../nodes/html-map-element/HTMLMapElement.cjs';
import HTMLMediaElement from '../nodes/html-media-element/HTMLMediaElement.cjs';
import MediaStream from '../nodes/html-media-element/MediaStream.cjs';
import MediaStreamTrack from '../nodes/html-media-element/MediaStreamTrack.cjs';
import RemotePlayback from '../nodes/html-media-element/RemotePlayback.cjs';
import TextTrack from '../nodes/html-media-element/TextTrack.cjs';
import TextTrackCue from '../nodes/html-media-element/TextTrackCue.cjs';
import TextTrackCueList from '../nodes/html-media-element/TextTrackCueList.cjs';
import TextTrackList from '../nodes/html-media-element/TextTrackList.cjs';
import TimeRanges from '../nodes/html-media-element/TimeRanges.cjs';
import VTTCue from '../nodes/html-media-element/VTTCue.cjs';
import HTMLMenuElement from '../nodes/html-menu-element/HTMLMenuElement.cjs';
import HTMLMetaElement from '../nodes/html-meta-element/HTMLMetaElement.cjs';
import HTMLMeterElement from '../nodes/html-meter-element/HTMLMeterElement.cjs';
import HTMLModElement from '../nodes/html-mod-element/HTMLModElement.cjs';
import HTMLOListElement from '../nodes/html-o-list-element/HTMLOListElement.cjs';
import HTMLObjectElement from '../nodes/html-object-element/HTMLObjectElement.cjs';
import HTMLOptGroupElement from '../nodes/html-opt-group-element/HTMLOptGroupElement.cjs';
import HTMLOptionElement from '../nodes/html-option-element/HTMLOptionElement.cjs';
import HTMLOutputElement from '../nodes/html-output-element/HTMLOutputElement.cjs';
import HTMLParagraphElement from '../nodes/html-paragraph-element/HTMLParagraphElement.cjs';
import HTMLParamElement from '../nodes/html-param-element/HTMLParamElement.cjs';
import HTMLPictureElement from '../nodes/html-picture-element/HTMLPictureElement.cjs';
import HTMLPreElement from '../nodes/html-pre-element/HTMLPreElement.cjs';
import HTMLProgressElement from '../nodes/html-progress-element/HTMLProgressElement.cjs';
import HTMLQuoteElement from '../nodes/html-quote-element/HTMLQuoteElement.cjs';
import HTMLScriptElement from '../nodes/html-script-element/HTMLScriptElement.cjs';
import HTMLSelectElement from '../nodes/html-select-element/HTMLSelectElement.cjs';
import HTMLSlotElement from '../nodes/html-slot-element/HTMLSlotElement.cjs';
import HTMLSourceElement from '../nodes/html-source-element/HTMLSourceElement.cjs';
import HTMLSpanElement from '../nodes/html-span-element/HTMLSpanElement.cjs';
import HTMLStyleElement from '../nodes/html-style-element/HTMLStyleElement.cjs';
import HTMLTableCaptionElement from '../nodes/html-table-caption-element/HTMLTableCaptionElement.cjs';
import HTMLTableCellElement from '../nodes/html-table-cell-element/HTMLTableCellElement.cjs';
import HTMLTableColElement from '../nodes/html-table-col-element/HTMLTableColElement.cjs';
import HTMLTableElement from '../nodes/html-table-element/HTMLTableElement.cjs';
import HTMLTableRowElement from '../nodes/html-table-row-element/HTMLTableRowElement.cjs';
import HTMLTableSectionElement from '../nodes/html-table-section-element/HTMLTableSectionElement.cjs';
import HTMLTemplateElement from '../nodes/html-template-element/HTMLTemplateElement.cjs';
import HTMLTextAreaElement from '../nodes/html-text-area-element/HTMLTextAreaElement.cjs';
import HTMLTimeElement from '../nodes/html-time-element/HTMLTimeElement.cjs';
import HTMLTitleElement from '../nodes/html-title-element/HTMLTitleElement.cjs';
import HTMLTrackElement from '../nodes/html-track-element/HTMLTrackElement.cjs';
import HTMLUListElement from '../nodes/html-u-list-element/HTMLUListElement.cjs';
import HTMLUnknownElement from '../nodes/html-unknown-element/HTMLUnknownElement.cjs';
import HTMLVideoElement from '../nodes/html-video-element/HTMLVideoElement.cjs';
import Node from '../nodes/node/Node.cjs';
import NodeList from '../nodes/node/NodeList.cjs';
import ProcessingInstruction from '../nodes/processing-instruction/ProcessingInstruction.cjs';
import ShadowRoot from '../nodes/shadow-root/ShadowRoot.cjs';
import SVGElement from '../nodes/svg-element/SVGElement.cjs';
import Text from '../nodes/text/Text.cjs';
import XMLDocument from '../nodes/xml-document/XMLDocument.cjs';
import PermissionStatus from '../permissions/PermissionStatus.cjs';
import Permissions from '../permissions/Permissions.cjs';
import Range from '../range/Range.cjs';
import ResizeObserver from '../resize-observer/ResizeObserver.cjs';
import Screen from '../screen/Screen.cjs';
import Selection from '../selection/Selection.cjs';
import Storage from '../storage/Storage.cjs';
import NodeIterator from '../tree-walker/NodeIterator.cjs';
import TreeWalker from '../tree-walker/TreeWalker.cjs';
import URL from '../url/URL.cjs';
import ValidityState from '../validity-state/ValidityState.cjs';
import XMLHttpRequest from '../xml-http-request/XMLHttpRequest.cjs';
import XMLHttpRequestEventTarget from '../xml-http-request/XMLHttpRequestEventTarget.cjs';
import XMLHttpRequestUpload from '../xml-http-request/XMLHttpRequestUpload.cjs';
import XMLSerializer from '../xml-serializer/XMLSerializer.cjs';
import CrossOriginBrowserWindow from './CrossOriginBrowserWindow.cjs';
import INodeJSGlobal from './INodeJSGlobal.cjs';
import { PerformanceObserver, PerformanceEntry, PerformanceObserverEntryList as IPerformanceObserverEntryList } from 'node:perf_hooks';
import HTMLOptionsCollection from '../nodes/html-select-element/HTMLOptionsCollection.cjs';
import CanvasCaptureMediaStreamTrack from '../nodes/html-canvas-element/CanvasCaptureMediaStreamTrack.cjs';
import SVGSVGElement from '../nodes/svg-svg-element/SVGSVGElement.cjs';
import SVGGraphicsElement from '../nodes/svg-graphics-element/SVGGraphicsElement.cjs';
import SVGAnimateElement from '../nodes/svg-animate-element/SVGAnimateElement.cjs';
import SVGAnimateMotionElement from '../nodes/svg-animate-motion-element/SVGAnimateMotionElement.cjs';
import SVGAnimateTransformElement from '../nodes/svg-animate-transform-element/SVGAnimateTransformElement.cjs';
import SVGCircleElement from '../nodes/svg-circle-element/SVGCircleElement.cjs';
import SVGClipPathElement from '../nodes/svg-clip-path-element/SVGClipPathElement.cjs';
import SVGDefsElement from '../nodes/svg-defs-element/SVGDefsElement.cjs';
import SVGDescElement from '../nodes/svg-desc-element/SVGDescElement.cjs';
import SVGEllipseElement from '../nodes/svg-ellipse-element/SVGEllipseElement.cjs';
import SVGFEBlendElement from '../nodes/svg-fe-blend-element/SVGFEBlendElement.cjs';
import SVGFEColorMatrixElement from '../nodes/svg-fe-color-matrix-element/SVGFEColorMatrixElement.cjs';
import SVGFEComponentTransferElement from '../nodes/svg-fe-component-transfer-element/SVGFEComponentTransferElement.cjs';
import SVGFECompositeElement from '../nodes/svg-fe-composite-element/SVGFECompositeElement.cjs';
import SVGFEConvolveMatrixElement from '../nodes/svg-fe-convolve-matrix-element/SVGFEConvolveMatrixElement.cjs';
import SVGFEDiffuseLightingElement from '../nodes/svg-fe-diffuse-lighting-element/SVGFEDiffuseLightingElement.cjs';
import SVGFEDisplacementMapElement from '../nodes/svg-fe-displacement-map-element/SVGFEDisplacementMapElement.cjs';
import SVGFEDistantLightElement from '../nodes/svg-fe-distant-light-element/SVGFEDistantLightElement.cjs';
import SVGFEDropShadowElement from '../nodes/svg-fe-drop-shadow-element/SVGFEDropShadowElement.cjs';
import SVGFEFloodElement from '../nodes/svg-fe-flood-element/SVGFEFloodElement.cjs';
import SVGFEFuncAElement from '../nodes/svg-fe-func-a-element/SVGFEFuncAElement.cjs';
import SVGFEFuncBElement from '../nodes/svg-fe-func-b-element/SVGFEFuncBElement.cjs';
import SVGFEFuncGElement from '../nodes/svg-fe-func-g-element/SVGFEFuncGElement.cjs';
import SVGFEFuncRElement from '../nodes/svg-fe-func-r-element/SVGFEFuncRElement.cjs';
import SVGFEGaussianBlurElement from '../nodes/svg-fe-gaussian-blur-element/SVGFEGaussianBlurElement.cjs';
import SVGFEImageElement from '../nodes/svg-fe-image-element/SVGFEImageElement.cjs';
import SVGFEMergeElement from '../nodes/svg-fe-merge-element/SVGFEMergeElement.cjs';
import SVGFEMergeNodeElement from '../nodes/svg-fe-merge-node-element/SVGFEMergeNodeElement.cjs';
import SVGFEMorphologyElement from '../nodes/svg-fe-morphology-element/SVGFEMorphologyElement.cjs';
import SVGFEOffsetElement from '../nodes/svg-fe-offset-element/SVGFEOffsetElement.cjs';
import SVGFEPointLightElement from '../nodes/svg-fe-point-light-element/SVGFEPointLightElement.cjs';
import SVGFESpecularLightingElement from '../nodes/svg-fe-specular-lighting-element/SVGFESpecularLightingElement.cjs';
import SVGFESpotLightElement from '../nodes/svg-fe-spot-light-element/SVGFESpotLightElement.cjs';
import SVGFETileElement from '../nodes/svg-fe-tile-element/SVGFETileElement.cjs';
import SVGFETurbulenceElement from '../nodes/svg-fe-turbulence-element/SVGFETurbulenceElement.cjs';
import SVGFilterElement from '../nodes/svg-filter-element/SVGFilterElement.cjs';
import SVGForeignObjectElement from '../nodes/svg-foreign-object-element/SVGForeignObjectElement.cjs';
import SVGGElement from '../nodes/svg-g-element/SVGGElement.cjs';
import SVGImageElement from '../nodes/svg-image-element/SVGImageElement.cjs';
import SVGLineElement from '../nodes/svg-line-element/SVGLineElement.cjs';
import SVGLinearGradientElement from '../nodes/svg-linear-gradient-element/SVGLinearGradientElement.cjs';
import SVGMarkerElement from '../nodes/svg-marker-element/SVGMarkerElement.cjs';
import SVGMaskElement from '../nodes/svg-mask-element/SVGMaskElement.cjs';
import SVGMetadataElement from '../nodes/svg-metadata-element/SVGMetadataElement.cjs';
import SVGMPathElement from '../nodes/svg-m-path-element/SVGMPathElement.cjs';
import SVGPathElement from '../nodes/svg-path-element/SVGPathElement.cjs';
import SVGPatternElement from '../nodes/svg-pattern-element/SVGPatternElement.cjs';
import SVGPolygonElement from '../nodes/svg-polygon-element/SVGPolygonElement.cjs';
import SVGPolylineElement from '../nodes/svg-polyline-element/SVGPolylineElement.cjs';
import SVGRadialGradientElement from '../nodes/svg-radial-gradient-element/SVGRadialGradientElement.cjs';
import SVGRectElement from '../nodes/svg-rect-element/SVGRectElement.cjs';
import SVGScriptElement from '../nodes/svg-script-element/SVGScriptElement.cjs';
import SVGSetElement from '../nodes/svg-set-element/SVGSetElement.cjs';
import SVGStopElement from '../nodes/svg-stop-element/SVGStopElement.cjs';
import SVGStyleElement from '../nodes/svg-style-element/SVGStyleElement.cjs';
import SVGSwitchElement from '../nodes/svg-switch-element/SVGSwitchElement.cjs';
import SVGSymbolElement from '../nodes/svg-symbol-element/SVGSymbolElement.cjs';
import SVGTextElement from '../nodes/svg-text-element/SVGTextElement.cjs';
import SVGTextPathElement from '../nodes/svg-text-path-element/SVGTextPathElement.cjs';
import SVGTitleElement from '../nodes/svg-title-element/SVGTitleElement.cjs';
import SVGTSpanElement from '../nodes/svg-t-span-element/SVGTSpanElement.cjs';
import SVGUseElement from '../nodes/svg-use-element/SVGUseElement.cjs';
import SVGViewElement from '../nodes/svg-view-element/SVGViewElement.cjs';
import SVGAnimationElement from '../nodes/svg-animation-element/SVGAnimationElement.cjs';
import SVGComponentTransferFunctionElement from '../nodes/svg-component-transfer-function-element/SVGComponentTransferFunctionElement.cjs';
import SVGGeometryElement from '../nodes/svg-geometry-element/SVGGeometryElement.cjs';
import SVGGradientElement from '../nodes/svg-gradient-element/SVGGradientElement.cjs';
import SVGTextPositioningElement from '../nodes/svg-text-positioning-element/SVGTextPositioningElement.cjs';
import DOMMatrixReadOnly from '../dom/dom-matrix/DOMMatrixReadOnly.cjs';
import DOMMatrix from '../dom/dom-matrix/DOMMatrix.cjs';
import SVGAngle from '../svg/SVGAngle.cjs';
import SVGAnimatedAngle from '../svg/SVGAnimatedAngle.cjs';
import SVGAnimatedBoolean from '../svg/SVGAnimatedBoolean.cjs';
import SVGAnimatedEnumeration from '../svg/SVGAnimatedEnumeration.cjs';
import SVGAnimatedInteger from '../svg/SVGAnimatedInteger.cjs';
import SVGAnimatedLength from '../svg/SVGAnimatedLength.cjs';
import SVGLength from '../svg/SVGLength.cjs';
import SVGAnimatedNumber from '../svg/SVGAnimatedNumber.cjs';
import SVGAnimatedNumberList from '../svg/SVGAnimatedNumberList.cjs';
import SVGAnimatedPreserveAspectRatio from '../svg/SVGAnimatedPreserveAspectRatio.cjs';
import SVGAnimatedRect from '../svg/SVGAnimatedRect.cjs';
import SVGAnimatedString from '../svg/SVGAnimatedString.cjs';
import SVGAnimatedTransformList from '../svg/SVGAnimatedTransformList.cjs';
import SVGLengthList from '../svg/SVGLengthList.cjs';
import SVGMatrix from '../svg/SVGMatrix.cjs';
import SVGNumber from '../svg/SVGNumber.cjs';
import SVGNumberList from '../svg/SVGNumberList.cjs';
import SVGPoint from '../svg/SVGPoint.cjs';
import SVGPointList from '../svg/SVGPointList.cjs';
import SVGPreserveAspectRatio from '../svg/SVGPreserveAspectRatio.cjs';
import SVGRect from '../svg/SVGRect.cjs';
import SVGStringList from '../svg/SVGStringList.cjs';
import SVGTransform from '../svg/SVGTransform.cjs';
import SVGTransformList from '../svg/SVGTransformList.cjs';
import SVGUnitTypes from '../svg/SVGUnitTypes.cjs';
import DOMPoint from '../dom/DOMPoint.cjs';
import SVGAnimatedLengthList from '../svg/SVGAnimatedLengthList.cjs';
import CustomElementReactionStack from '../custom-element/CustomElementReactionStack.cjs';
import IScrollToOptions from './IScrollToOptions.cjs';
import IModule from '../module/IModule.cjs';
import IModuleImportMap from '../module/IModuleImportMap.cjs';
/**
 * Browser window.
 *
 * Reference:
 * https://developer.mozilla.org/en-US/docs/Web/API/Window.
 */
export default class BrowserWindow extends EventTarget implements INodeJSGlobal {
    #private;
    readonly Node: typeof Node;
    readonly Attr: typeof Attr;
    readonly ShadowRoot: typeof ShadowRoot;
    readonly ProcessingInstruction: typeof ProcessingInstruction;
    readonly Element: typeof Element;
    readonly CharacterData: typeof CharacterData;
    readonly DocumentType: typeof DocumentType;
    readonly Document: typeof Document;
    readonly HTMLDocument: typeof HTMLDocument;
    readonly XMLDocument: typeof XMLDocument;
    readonly DocumentFragment: typeof DocumentFragment;
    readonly Text: typeof Text;
    readonly Comment: typeof Comment;
    readonly Image: typeof Image;
    readonly Audio: typeof Audio;
    readonly HTMLAnchorElement: typeof HTMLAnchorElement;
    readonly HTMLButtonElement: typeof HTMLButtonElement;
    readonly HTMLOptGroupElement: typeof HTMLOptGroupElement;
    readonly HTMLOptionElement: typeof HTMLOptionElement;
    readonly HTMLElement: typeof HTMLElement;
    readonly HTMLUnknownElement: typeof HTMLUnknownElement;
    readonly HTMLTemplateElement: typeof HTMLTemplateElement;
    readonly HTMLInputElement: typeof HTMLInputElement;
    readonly HTMLSelectElement: typeof HTMLSelectElement;
    readonly HTMLTextAreaElement: typeof HTMLTextAreaElement;
    readonly HTMLImageElement: typeof HTMLImageElement;
    readonly HTMLStyleElement: typeof HTMLStyleElement;
    readonly HTMLLabelElement: typeof HTMLLabelElement;
    readonly HTMLSlotElement: typeof HTMLSlotElement;
    readonly HTMLMetaElement: typeof HTMLMetaElement;
    readonly HTMLMediaElement: typeof HTMLMediaElement;
    readonly HTMLAudioElement: typeof HTMLAudioElement;
    readonly HTMLVideoElement: typeof HTMLVideoElement;
    readonly HTMLBaseElement: typeof HTMLBaseElement;
    readonly HTMLDialogElement: typeof HTMLDialogElement;
    readonly HTMLScriptElement: typeof HTMLScriptElement;
    readonly HTMLLinkElement: typeof HTMLLinkElement;
    readonly HTMLIFrameElement: typeof HTMLIFrameElement;
    readonly HTMLFormElement: typeof HTMLFormElement;
    readonly HTMLUListElement: typeof HTMLUListElement;
    readonly HTMLTrackElement: typeof HTMLTrackElement;
    readonly HTMLTableRowElement: typeof HTMLTableRowElement;
    readonly HTMLTitleElement: typeof HTMLTitleElement;
    readonly HTMLTimeElement: typeof HTMLTimeElement;
    readonly HTMLTableSectionElement: typeof HTMLTableSectionElement;
    readonly HTMLTableCellElement: typeof HTMLTableCellElement;
    readonly HTMLTableElement: typeof HTMLTableElement;
    readonly HTMLSpanElement: typeof HTMLSpanElement;
    readonly HTMLSourceElement: typeof HTMLSourceElement;
    readonly HTMLQuoteElement: typeof HTMLQuoteElement;
    readonly HTMLProgressElement: typeof HTMLProgressElement;
    readonly HTMLPreElement: typeof HTMLPreElement;
    readonly HTMLPictureElement: typeof HTMLPictureElement;
    readonly HTMLParamElement: typeof HTMLParamElement;
    readonly HTMLParagraphElement: typeof HTMLParagraphElement;
    readonly HTMLOutputElement: typeof HTMLOutputElement;
    readonly HTMLOListElement: typeof HTMLOListElement;
    readonly HTMLObjectElement: typeof HTMLObjectElement;
    readonly HTMLMeterElement: typeof HTMLMeterElement;
    readonly HTMLMenuElement: typeof HTMLMenuElement;
    readonly HTMLMapElement: typeof HTMLMapElement;
    readonly HTMLLIElement: typeof HTMLLIElement;
    readonly HTMLLegendElement: typeof HTMLLegendElement;
    readonly HTMLModElement: typeof HTMLModElement;
    readonly HTMLHtmlElement: typeof HTMLHtmlElement;
    readonly HTMLHRElement: typeof HTMLHRElement;
    readonly HTMLHeadElement: typeof HTMLHeadElement;
    readonly HTMLHeadingElement: typeof HTMLHeadingElement;
    readonly HTMLFieldSetElement: typeof HTMLFieldSetElement;
    readonly HTMLEmbedElement: typeof HTMLEmbedElement;
    readonly HTMLDListElement: typeof HTMLDListElement;
    readonly HTMLDivElement: typeof HTMLDivElement;
    readonly HTMLDetailsElement: typeof HTMLDetailsElement;
    readonly HTMLDataListElement: typeof HTMLDataListElement;
    readonly HTMLDataElement: typeof HTMLDataElement;
    readonly HTMLTableColElement: typeof HTMLTableColElement;
    readonly HTMLTableCaptionElement: typeof HTMLTableCaptionElement;
    readonly HTMLCanvasElement: typeof HTMLCanvasElement;
    readonly HTMLBRElement: typeof HTMLBRElement;
    readonly HTMLBodyElement: typeof HTMLBodyElement;
    readonly HTMLAreaElement: typeof HTMLAreaElement;
    readonly SVGSVGElement: typeof SVGSVGElement;
    readonly SVGAnimateElement: typeof SVGAnimateElement;
    readonly SVGAnimateMotionElement: typeof SVGAnimateMotionElement;
    readonly SVGAnimateTransformElement: typeof SVGAnimateTransformElement;
    readonly SVGCircleElement: typeof SVGCircleElement;
    readonly SVGClipPathElement: typeof SVGClipPathElement;
    readonly SVGDefsElement: typeof SVGDefsElement;
    readonly SVGDescElement: typeof SVGDescElement;
    readonly SVGEllipseElement: typeof SVGEllipseElement;
    readonly SVGFEBlendElement: typeof SVGFEBlendElement;
    readonly SVGFEColorMatrixElement: typeof SVGFEColorMatrixElement;
    readonly SVGFEComponentTransferElement: typeof SVGFEComponentTransferElement;
    readonly SVGFECompositeElement: typeof SVGFECompositeElement;
    readonly SVGFEConvolveMatrixElement: typeof SVGFEConvolveMatrixElement;
    readonly SVGFEDiffuseLightingElement: typeof SVGFEDiffuseLightingElement;
    readonly SVGFEDisplacementMapElement: typeof SVGFEDisplacementMapElement;
    readonly SVGFEDistantLightElement: typeof SVGFEDistantLightElement;
    readonly SVGFEDropShadowElement: typeof SVGFEDropShadowElement;
    readonly SVGFEFloodElement: typeof SVGFEFloodElement;
    readonly SVGFEFuncAElement: typeof SVGFEFuncAElement;
    readonly SVGFEFuncBElement: typeof SVGFEFuncBElement;
    readonly SVGFEFuncGElement: typeof SVGFEFuncGElement;
    readonly SVGFEFuncRElement: typeof SVGFEFuncRElement;
    readonly SVGFEGaussianBlurElement: typeof SVGFEGaussianBlurElement;
    readonly SVGFEImageElement: typeof SVGFEImageElement;
    readonly SVGFEMergeElement: typeof SVGFEMergeElement;
    readonly SVGFEMergeNodeElement: typeof SVGFEMergeNodeElement;
    readonly SVGFEMorphologyElement: typeof SVGFEMorphologyElement;
    readonly SVGFEOffsetElement: typeof SVGFEOffsetElement;
    readonly SVGFEPointLightElement: typeof SVGFEPointLightElement;
    readonly SVGFESpecularLightingElement: typeof SVGFESpecularLightingElement;
    readonly SVGFESpotLightElement: typeof SVGFESpotLightElement;
    readonly SVGFETileElement: typeof SVGFETileElement;
    readonly SVGFETurbulenceElement: typeof SVGFETurbulenceElement;
    readonly SVGFilterElement: typeof SVGFilterElement;
    readonly SVGForeignObjectElement: typeof SVGForeignObjectElement;
    readonly SVGGElement: typeof SVGGElement;
    readonly SVGImageElement: typeof SVGImageElement;
    readonly SVGLineElement: typeof SVGLineElement;
    readonly SVGLinearGradientElement: typeof SVGLinearGradientElement;
    readonly SVGMarkerElement: typeof SVGMarkerElement;
    readonly SVGMaskElement: typeof SVGMaskElement;
    readonly SVGMetadataElement: typeof SVGMetadataElement;
    readonly SVGMPathElement: typeof SVGMPathElement;
    readonly SVGPathElement: typeof SVGPathElement;
    readonly SVGPatternElement: typeof SVGPatternElement;
    readonly SVGPolygonElement: typeof SVGPolygonElement;
    readonly SVGPolylineElement: typeof SVGPolylineElement;
    readonly SVGRadialGradientElement: typeof SVGRadialGradientElement;
    readonly SVGRectElement: typeof SVGRectElement;
    readonly SVGScriptElement: typeof SVGScriptElement;
    readonly SVGSetElement: typeof SVGSetElement;
    readonly SVGStopElement: typeof SVGStopElement;
    readonly SVGStyleElement: typeof SVGStyleElement;
    readonly SVGSwitchElement: typeof SVGSwitchElement;
    readonly SVGSymbolElement: typeof SVGSymbolElement;
    readonly SVGTextElement: typeof SVGTextElement;
    readonly SVGTextPathElement: typeof SVGTextPathElement;
    readonly SVGTitleElement: typeof SVGTitleElement;
    readonly SVGTSpanElement: typeof SVGTSpanElement;
    readonly SVGUseElement: typeof SVGUseElement;
    readonly SVGViewElement: typeof SVGViewElement;
    readonly SVGElement: typeof SVGElement;
    readonly SVGAnimationElement: typeof SVGAnimationElement;
    readonly SVGComponentTransferFunctionElement: typeof SVGComponentTransferFunctionElement;
    readonly SVGGeometryElement: typeof SVGGeometryElement;
    readonly SVGGradientElement: typeof SVGGradientElement;
    readonly SVGTextPositioningElement: typeof SVGTextPositioningElement;
    readonly SVGGraphicsElement: typeof SVGGraphicsElement;
    readonly Event: typeof Event;
    readonly UIEvent: typeof UIEvent;
    readonly CustomEvent: typeof CustomEvent;
    readonly AnimationEvent: typeof AnimationEvent;
    readonly KeyboardEvent: typeof KeyboardEvent;
    readonly MessageEvent: typeof MessageEvent;
    readonly MouseEvent: typeof MouseEvent;
    readonly PointerEvent: typeof PointerEvent;
    readonly FocusEvent: typeof FocusEvent;
    readonly WheelEvent: typeof WheelEvent;
    readonly InputEvent: typeof InputEvent;
    readonly ErrorEvent: typeof ErrorEvent;
    readonly StorageEvent: typeof StorageEvent;
    readonly SubmitEvent: typeof SubmitEvent;
    readonly ProgressEvent: typeof ProgressEvent;
    readonly MediaQueryListEvent: typeof MediaQueryListEvent;
    readonly HashChangeEvent: typeof HashChangeEvent;
    readonly ClipboardEvent: typeof ClipboardEvent;
    readonly TouchEvent: typeof TouchEvent;
    readonly Touch: typeof Touch;
    readonly AudioProcessingEvent: typeof Event;
    readonly BeforeInputEvent: typeof Event;
    readonly BeforeUnloadEvent: typeof Event;
    readonly BlobEvent: typeof Event;
    readonly CloseEvent: typeof Event;
    readonly CompositionEvent: typeof Event;
    readonly CSSFontFaceLoadEvent: typeof Event;
    readonly DeviceLightEvent: typeof Event;
    readonly DeviceMotionEvent: typeof Event;
    readonly DeviceOrientationEvent: typeof Event;
    readonly DeviceProximityEvent: typeof Event;
    readonly DOMTransactionEvent: typeof Event;
    readonly DragEvent: typeof Event;
    readonly EditingBeforeInputEvent: typeof Event;
    readonly FetchEvent: typeof Event;
    readonly GamepadEvent: typeof Event;
    readonly IDBVersionChangeEvent: typeof Event;
    readonly MediaStreamEvent: typeof Event;
    readonly MutationEvent: typeof Event;
    readonly OfflineAudioCompletionEvent: typeof Event;
    readonly OverconstrainedError: typeof Event;
    readonly PageTransitionEvent: typeof Event;
    readonly PaymentRequestUpdateEvent: typeof Event;
    readonly PopStateEvent: typeof Event;
    readonly RelatedEvent: typeof Event;
    readonly RTCDataChannelEvent: typeof Event;
    readonly RTCIdentityErrorEvent: typeof Event;
    readonly RTCIdentityEvent: typeof Event;
    readonly RTCPeerConnectionIceEvent: typeof Event;
    readonly SensorEvent: typeof Event;
    readonly SVGEvent: typeof Event;
    readonly SVGZoomEvent: typeof Event;
    readonly TimeEvent: typeof Event;
    readonly TrackEvent: typeof Event;
    readonly TransitionEvent: typeof Event;
    readonly UserProximityEvent: typeof Event;
    readonly WebGLContextEvent: typeof Event;
    readonly TextEvent: typeof Event;
    readonly MutationObserver: typeof MutationObserver;
    readonly MessagePort: typeof MessagePort;
    readonly CSSStyleSheet: typeof CSSStyleSheet;
    readonly DOMException: typeof DOMException;
    readonly Request: typeof Request;
    readonly Response: typeof Response;
    readonly EventTarget: typeof EventTarget;
    readonly XMLHttpRequestUpload: typeof XMLHttpRequestUpload;
    readonly XMLHttpRequestEventTarget: typeof XMLHttpRequestEventTarget;
    readonly AbortController: typeof AbortController;
    readonly AbortSignal: typeof AbortSignal;
    readonly FormData: typeof FormData;
    readonly PermissionStatus: typeof PermissionStatus;
    readonly XMLHttpRequest: typeof XMLHttpRequest;
    readonly DOMParser: typeof DOMParser;
    readonly Range: typeof Range;
    readonly VTTCue: typeof VTTCue;
    readonly FileReader: typeof FileReader;
    readonly MediaStream: typeof MediaStream;
    readonly MediaStreamTrack: typeof MediaStreamTrack;
    readonly CanvasCaptureMediaStreamTrack: typeof CanvasCaptureMediaStreamTrack;
    readonly TextTrack: typeof TextTrack;
    readonly TextTrackList: typeof TextTrackList;
    readonly TextTrackCue: typeof TextTrackCue;
    readonly RemotePlayback: typeof RemotePlayback;
    readonly Permissions: typeof Permissions;
    readonly History: typeof History;
    readonly Navigator: typeof Navigator;
    readonly Clipboard: typeof Clipboard;
    readonly TimeRanges: typeof TimeRanges;
    readonly TextTrackCueList: typeof TextTrackCueList;
    readonly ValidityState: typeof ValidityState;
    readonly MutationRecord: typeof MutationRecord;
    readonly IntersectionObserver: typeof IntersectionObserver;
    readonly IntersectionObserverEntry: typeof IntersectionObserverEntry;
    readonly CSSStyleDeclaration: typeof CSSStyleDeclaration;
    readonly CSSRule: typeof CSSRule;
    readonly CSSContainerRule: typeof CSSContainerRule;
    readonly CSSFontFaceRule: typeof CSSFontFaceRule;
    readonly CSSKeyframeRule: typeof CSSKeyframeRule;
    readonly CSSKeyframesRule: typeof CSSKeyframesRule;
    readonly CSSMediaRule: typeof CSSMediaRule;
    readonly CSSStyleRule: typeof CSSStyleRule;
    readonly CSSSupportsRule: typeof CSSSupportsRule;
    readonly DOMRect: typeof DOMRect;
    readonly DOMRectReadOnly: typeof DOMRectReadOnly;
    readonly Plugin: typeof Plugin;
    readonly PluginArray: typeof PluginArray;
    readonly Location: typeof Location;
    readonly CustomElementRegistry: typeof CustomElementRegistry;
    readonly ResizeObserver: typeof ResizeObserver;
    readonly URL: typeof URL;
    readonly Blob: typeof Blob;
    readonly File: typeof File;
    readonly Storage: typeof Storage;
    readonly MimeType: typeof MimeType;
    readonly MimeTypeArray: typeof MimeTypeArray;
    readonly NodeFilter: {
        FILTER_ACCEPT: number;
        FILTER_REJECT: number;
        FILTER_SKIP: number;
        SHOW_ALL: number;
        SHOW_ELEMENT: number;
        SHOW_ATTRIBUTE: number;
        SHOW_TEXT: number;
        SHOW_CDATA_SECTION: number;
        SHOW_ENTITY_REFERENCE: number;
        SHOW_ENTITY: number;
        SHOW_PROCESSING_INSTRUCTION: number;
        SHOW_COMMENT: number;
        SHOW_DOCUMENT: number;
        SHOW_DOCUMENT_TYPE: number;
        SHOW_DOCUMENT_FRAGMENT: number;
        SHOW_NOTATION: number;
    };
    readonly HTMLCollection: typeof HTMLCollection;
    readonly HTMLFormControlCollection: typeof HTMLFormControlsCollection;
    readonly HTMLOptionsCollection: typeof HTMLOptionsCollection;
    readonly NodeList: typeof NodeList;
    readonly RadioNodeList: typeof RadioNodeList;
    readonly FileList: typeof FileList;
    readonly Screen: typeof Screen;
    readonly DOMMatrixReadOnly: typeof DOMMatrixReadOnly;
    readonly DOMMatrix: typeof DOMMatrix;
    readonly NamedNodeMap: typeof NamedNodeMap;
    readonly TreeWalker: typeof TreeWalker;
    readonly NodeIterator: typeof NodeIterator;
    readonly DataTransfer: typeof DataTransfer;
    readonly DataTransferItem: typeof DataTransferItem;
    readonly DataTransferItemList: typeof DataTransferItemList;
    readonly Headers: typeof Headers;
    readonly XMLSerializer: typeof XMLSerializer;
    readonly ClipboardItem: typeof ClipboardItem;
    readonly Selection: typeof Selection;
    readonly CSSUnitValue: typeof CSSUnitValue;
    readonly SVGAngle: typeof SVGAngle;
    readonly SVGAnimatedAngle: typeof SVGAnimatedAngle;
    readonly SVGAnimatedBoolean: typeof SVGAnimatedBoolean;
    readonly SVGAnimatedEnumeration: typeof SVGAnimatedEnumeration;
    readonly SVGAnimatedInteger: typeof SVGAnimatedInteger;
    readonly SVGAnimatedLength: typeof SVGAnimatedLength;
    readonly SVGAnimatedNumber: typeof SVGAnimatedNumber;
    readonly SVGAnimatedNumberList: typeof SVGAnimatedNumberList;
    readonly SVGAnimatedPreserveAspectRatio: typeof SVGAnimatedPreserveAspectRatio;
    readonly SVGAnimatedRect: typeof SVGAnimatedRect;
    readonly SVGAnimatedString: typeof SVGAnimatedString;
    readonly SVGAnimatedTransformList: typeof SVGAnimatedTransformList;
    readonly SVGLength: typeof SVGLength;
    readonly SVGLengthList: typeof SVGLengthList;
    readonly SVGMatrix: typeof SVGMatrix;
    readonly SVGNumber: typeof SVGNumber;
    readonly SVGNumberList: typeof SVGNumberList;
    readonly SVGPoint: typeof SVGPoint;
    readonly SVGPointList: typeof SVGPointList;
    readonly SVGPreserveAspectRatio: typeof SVGPreserveAspectRatio;
    readonly SVGRect: typeof SVGRect;
    readonly SVGStringList: typeof SVGStringList;
    readonly SVGTransform: typeof SVGTransform;
    readonly SVGTransformList: typeof SVGTransformList;
    readonly SVGAnimatedLengthList: typeof SVGAnimatedLengthList;
    readonly SVGUnitTypes: typeof SVGUnitTypes;
    readonly DOMPoint: typeof DOMPoint;
    readonly Window: typeof BrowserWindow;
    readonly URLSearchParams: typeof URLSearchParams;
    readonly WritableStream: typeof Stream.Writable;
    readonly ReadableStream: {
        new (underlyingSource: import("stream/web").UnderlyingByteSource, strategy?: import("stream/web").QueuingStrategy<Uint8Array>): ReadableStream<Uint8Array>;
        new <R = any>(underlyingSource?: import("stream/web").UnderlyingSource<R>, strategy?: import("stream/web").QueuingStrategy<R>): ReadableStream<R>;
        prototype: ReadableStream;
        from<T>(iterable: Iterable<T> | AsyncIterable<T>): ReadableStream<T>;
    };
    readonly TransformStream: typeof Stream.Transform;
    readonly PerformanceObserver: typeof PerformanceObserver;
    readonly PerformanceEntry: typeof PerformanceEntry;
    readonly PerformanceObserverEntryList: new () => IPerformanceObserverEntryList;
    onload: ((event: Event) => void) | null;
    onerror: ((event: ErrorEvent) => void) | null;
    readonly document: Document;
    readonly customElements: CustomElementRegistry;
    readonly window: BrowserWindow;
    readonly globalThis: BrowserWindow;
    readonly performance: typeof performance;
    readonly screenLeft: number;
    readonly screenTop: number;
    readonly screenX: number;
    readonly screenY: number;
    readonly crypto: typeof webcrypto;
    readonly TextEncoder: typeof TextEncoder;
    readonly TextDecoder: typeof TextDecoder;
    readonly closed = false;
    console: Console;
    name: string;
    Array: typeof Array;
    ArrayBuffer: typeof ArrayBuffer;
    Boolean: typeof Boolean;
    Buffer: typeof Buffer;
    DataView: typeof DataView;
    Date: typeof Date;
    Error: typeof Error;
    EvalError: typeof EvalError;
    Float32Array: typeof Float32Array;
    Float64Array: typeof Float64Array;
    Function: typeof Function;
    Infinity: typeof Infinity;
    Int16Array: typeof Int16Array;
    Int32Array: typeof Int32Array;
    Int8Array: typeof Int8Array;
    Intl: typeof Intl;
    JSON: typeof JSON;
    Map: MapConstructor;
    Math: typeof Math;
    NaN: typeof NaN;
    Number: typeof Number;
    Object: typeof Object;
    Promise: typeof Promise;
    RangeError: typeof RangeError;
    ReferenceError: typeof ReferenceError;
    RegExp: typeof RegExp;
    Set: SetConstructor;
    String: typeof String;
    Symbol: Function;
    SyntaxError: typeof SyntaxError;
    TypeError: typeof TypeError;
    URIError: typeof URIError;
    Uint16Array: typeof Uint16Array;
    Uint32Array: typeof Uint32Array;
    Uint8Array: typeof Uint8Array;
    Uint8ClampedArray: typeof Uint8ClampedArray;
    WeakMap: WeakMapConstructor;
    WeakSet: WeakSetConstructor;
    decodeURI: typeof decodeURI;
    decodeURIComponent: typeof decodeURIComponent;
    encodeURI: typeof encodeURI;
    encodeURIComponent: typeof encodeURIComponent;
    eval: typeof eval;
    /**
     * @deprecated
     */
    escape: (str: string) => string;
    global: typeof globalThis;
    isFinite: typeof isFinite;
    isNaN: typeof isNaN;
    parseFloat: typeof parseFloat;
    parseInt: typeof parseInt;
    undefined: typeof undefined;
    /**
     * @deprecated
     */
    unescape: (str: string) => string;
    gc: () => void;
    v8debug?: unknown;
    [PropertySymbol.mutationObservers]: MutationObserver[];
    readonly [PropertySymbol.readyStateManager]: DocumentReadyStateManager;
    [PropertySymbol.location]: Location;
    [PropertySymbol.history]: History;
    [PropertySymbol.navigator]: Navigator;
    [PropertySymbol.screen]: Screen;
    [PropertySymbol.sessionStorage]: Storage;
    [PropertySymbol.localStorage]: Storage;
    [PropertySymbol.self]: BrowserWindow | null;
    [PropertySymbol.top]: BrowserWindow | null;
    [PropertySymbol.parent]: BrowserWindow | null;
    [PropertySymbol.window]: BrowserWindow;
    [PropertySymbol.internalId]: number;
    [PropertySymbol.customElementReactionStack]: CustomElementReactionStack;
    [PropertySymbol.modules]: {
        json: Map<string, IModule>;
        css: Map<string, IModule>;
        esm: Map<string, IModule>;
    };
    [PropertySymbol.moduleImportMap]: IModuleImportMap | null;
    /**
     * Constructor.
     *
     * @param browserFrame Browser frame.
     * @param [options] Options.
     * @param [options.url] URL.
     */
    constructor(browserFrame: IBrowserFrame, options?: {
        url?: string;
    });
    /**
     * Returns self.
     *
     * @returns Self.
     */
    get self(): BrowserWindow;
    /**
     * Returns self.
     *
     * @param self Self.
     */
    set self(self: BrowserWindow | null);
    /**
     * Returns top.
     *
     * @returns Top.
     */
    get top(): BrowserWindow;
    /**
     * Returns parent.
     *
     * @returns Parent.
     */
    get parent(): BrowserWindow;
    /**
     * Returns parent.
     *
     * @param parent Parent.
     */
    set parent(parent: BrowserWindow | null);
    /**
     * Returns location.
     */
    get location(): Location;
    /**
     * Returns location.
     *
     * @param href Href.
     */
    set location(href: string);
    /**
     * Returns history.
     */
    get history(): History;
    /**
     * Returns navigator.
     */
    get navigator(): Navigator;
    /**
     * Returns screen.
     */
    get screen(): Screen;
    /**
     * Returns session storage.
     */
    get sessionStorage(): Storage;
    /**
     * Returns local storage.
     */
    get localStorage(): Storage;
    /**
     * Returns opener.
     *
     * @returns Opener.
     */
    get opener(): BrowserWindow | CrossOriginBrowserWindow | null;
    /**
     * The number of pixels that the document is currently scrolled horizontally.
     *
     * @returns Scroll X.
     */
    get scrollX(): number;
    /**
     * The read-only Window property pageXOffset is an alias for scrollX.
     *
     * @returns Scroll X.
     */
    get pageXOffset(): number;
    /**
     * The number of pixels that the document is currently scrolled vertically.
     *
     * @returns Scroll Y.
     */
    get scrollY(): number;
    /**
     * The read-only Window property pageYOffset is an alias for scrollY.
     *
     * @returns Scroll Y.
     */
    get pageYOffset(): number;
    /**
     * The CSS interface holds useful CSS-related methods.
     *
     * @returns CSS interface.
     */
    get CSS(): CSS;
    /**
     * Returns inner width.
     *
     * @returns Inner width.
     */
    get innerWidth(): number;
    /**
     * Sets inner width.
     *
     * @param value Inner width.
     */
    set innerWidth(value: number);
    /**
     * Returns inner height.
     *
     * @returns Inner height.
     */
    get innerHeight(): number;
    /**
     * Sets inner height.
     *
     * @param value Inner height.
     */
    set innerHeight(value: number);
    /**
     * Returns outer width.
     *
     * @returns Outer width.
     */
    get outerWidth(): number;
    /**
     * Sets outer width.
     *
     * @param value Outer width.
     */
    set outerWidth(value: number);
    /**
     * Returns outer height.
     *
     * @returns Outer height.
     */
    get outerHeight(): number;
    /**
     * Sets outer height.
     *
     * @param value Outer height.
     */
    set outerHeight(value: number);
    /**
     * Returns device pixel ratio.
     *
     * @returns Device pixel ratio.
     */
    get devicePixelRatio(): number;
    /**
     * Sets device pixel ratio.
     *
     * @param value Device pixel ratio.
     */
    set devicePixelRatio(value: number);
    /**
     * Returns an object containing the values of all CSS properties of an element.
     *
     * @param element Element.
     * @returns CSS style declaration.
     */
    getComputedStyle(element: Element): CSSStyleDeclaration;
    /**
     * Returns selection.
     *
     * @returns Selection.
     */
    getSelection(): Selection;
    /**
     * Scrolls to a particular set of coordinates.
     *
     * @param x X position or options object.
     * @param y Y position.
     */
    scroll(x: IScrollToOptions | number, y?: number): void;
    /**
     * Scrolls to a particular set of coordinates.
     *
     * @param x X position or options object.
     * @param y Y position.
     */
    scrollTo(x: IScrollToOptions | number, y?: number): void;
    /**
     * Scrolls by a relative amount from the current position.
     *
     * @param x Pixels to scroll by from top or scroll options object.
     * @param y Pixels to scroll by from left.
     */
    scrollBy(x: IScrollToOptions | number, y?: number): void;
    /**
     * Shifts focus away from the window.
     */
    blur(): void;
    /**
     * Gives focus to the window.
     */
    focus(): void;
    /**
     * Loads a specified resource into a new or existing browsing context (that is, a tab, a window, or an iframe) under a specified name.
     *
     * @param [url] URL.
     * @param [target] Target.
     * @param [features] Window features.
     * @returns Window.
     */
    open(url?: string, target?: string, features?: string): BrowserWindow | CrossOriginBrowserWindow | null;
    /**
     * Closes the window.
     */
    close(): void;
    /**
     * Returns a new MediaQueryList object that can then be used to determine if the document matches the media query string.
     *
     * @param mediaQueryString A string specifying the media query to parse into a MediaQueryList.
     * @returns A new MediaQueryList.
     */
    matchMedia(mediaQueryString: string): MediaQueryList;
    /**
     * Sets a timer which executes a function once the timer expires.
     *
     * @param callback Function to be executed.
     * @param [delay=0] Delay in ms.
     * @param args Arguments passed to the callback function.
     * @returns Timeout ID.
     */
    setTimeout(callback: Function, delay?: number, ...args: unknown[]): NodeJS.Timeout;
    /**
     * Cancels a timeout previously established by calling setTimeout().
     *
     * @param id ID of the timeout.
     */
    clearTimeout(id: NodeJS.Timeout): void;
    /**
     * Calls a function with a fixed time delay between each call.
     *
     * @param callback Function to be executed.
     * @param [delay=0] Delay in ms.
     * @param args Arguments passed to the callback function.
     * @returns Interval ID.
     */
    setInterval(callback: Function, delay?: number, ...args: unknown[]): NodeJS.Timeout;
    /**
     * Cancels a timed repeating action which was previously established by a call to setInterval().
     *
     * @param id ID of the interval.
     */
    clearInterval(id: NodeJS.Timeout): void;
    /**
     * Mock animation frames with timeouts.
     *
     * @param callback Callback.
     * @returns ID.
     */
    requestAnimationFrame(callback: (timestamp: number) => void): NodeJS.Immediate;
    /**
     * Mock animation frames with timeouts.
     *
     * @param id ID.
     */
    cancelAnimationFrame(id: NodeJS.Immediate): void;
    /**
     * Queues a microtask to be executed at a safe time prior to control returning to the browser's event loop.
     *
     * @param callback Function to be executed.
     */
    queueMicrotask(callback: Function): void;
    /**
     * This method provides an easy, logical way to fetch resources asynchronously across the network.
     *
     * @param url URL.
     * @param [init] Init.
     * @returns Promise.
     */
    fetch(url: IRequestInfo, init?: IRequestInit): Promise<Response>;
    /**
     * Creates a Base64-encoded ASCII string from a binary string (i.e., a string in which each character in the string is treated as a byte of binary data).
     *
     * @see https://developer.mozilla.org/en-US/docs/Web/API/btoa
     * @param data Binay data.
     * @returns Base64-encoded string.
     */
    btoa(data: unknown): string;
    /**
     * Decodes a string of data which has been encoded using Base64 encoding.
     *
     * @see https://developer.mozilla.org/en-US/docs/Web/API/atob
     * @see https://infra.spec.whatwg.org/#forgiving-base64-encode.
     * @see Https://html.spec.whatwg.org/multipage/webappapis.html#btoa.
     * @param data Binay string.
     * @returns An ASCII string containing decoded data from encodedData.
     */
    atob(data: unknown): string;
    /**
     * Safely enables cross-origin communication between Window objects; e.g., between a page and a pop-up that it spawned, or between a page and an iframe embedded within it.
     *
     * @param message Message.
     * @param [targetOrigin=*] Target origin.
     * @param _transfer Transfer. Not implemented.
     */
    postMessage(message: unknown, targetOrigin?: string, _transfer?: unknown[]): void;
    /**
     * Resizes the window.
     *
     * @param width Width.
     * @param height Height.
     */
    resizeTo(width: number, height: number): void;
    /**
     * Resizes the current window by a specified amount.
     *
     * @param width Width.
     * @param height Height.
     */
    resizeBy(width: number, height: number): void;
    /**
     * Dispatches an error event and outputs the error to the console.
     *
     * @param error Error.
     */
    [PropertySymbol.dispatchError](error: Error): void;
    /**
     * Setup of VM context.
     */
    protected [PropertySymbol.setupVMContext](): void;
    /**
     * Destroys the window.
     */
    [PropertySymbol.destroy](): void;
    /**
     * Binds methods to a window as scope.
     */
    [PropertySymbol.bindMethods](): void;
}
//# sourceMappingURL=BrowserWindow.d.ts.map