import CSSUnitValue from './CSSUnitValue.js';
/**
 * The CSS interface holds useful CSS-related methods.
 *
 * Reference:
 * https://developer.mozilla.org/en-US/docs/Web/API/CSS.
 */
export default class CSS {
    readonly Hz: (value: number) => CSSUnitValue;
    readonly Q: (value: number) => CSSUnitValue;
    readonly ch: (value: number) => CSSUnitValue;
    readonly cm: (value: number) => CSSUnitValue;
    readonly deg: (value: number) => CSSUnitValue;
    readonly dpcm: (value: number) => CSSUnitValue;
    readonly dpi: (value: number) => CSSUnitValue;
    readonly dppx: (value: number) => CSSUnitValue;
    readonly em: (value: number) => CSSUnitValue;
    readonly ex: (value: number) => CSSUnitValue;
    readonly fr: (value: number) => CSSUnitValue;
    readonly grad: (value: number) => CSSUnitValue;
    readonly in: (value: number) => CSSUnitValue;
    readonly kHz: (value: number) => CSSUnitValue;
    readonly mm: (value: number) => CSSUnitValue;
    readonly ms: (value: number) => CSSUnitValue;
    readonly number: (value: number) => CSSUnitValue;
    readonly pc: (value: number) => CSSUnitValue;
    readonly percent: (value: number) => CSSUnitValue;
    readonly pt: (value: number) => CSSUnitValue;
    readonly px: (value: number) => CSSUnitValue;
    readonly rad: (value: number) => CSSUnitValue;
    readonly rem: (value: number) => CSSUnitValue;
    readonly s: (value: number) => CSSUnitValue;
    readonly turn: (value: number) => CSSUnitValue;
    readonly vh: (value: number) => CSSUnitValue;
    readonly vmax: (value: number) => CSSUnitValue;
    readonly vmin: (value: number) => CSSUnitValue;
    readonly vw: (value: number) => CSSUnitValue;
    /**
     * Returns a Boolean indicating if the pair property-value, or the condition, given in parameter is supported.
     *
     * TODO: Always returns "true" for now, but it should probably be improved in the future.
     *
     * @param _condition Property name or condition.
     * @param [_value] Value when using property name.
     * @returns "true" if supported.
     */
    supports(_condition: string, _value?: string): boolean;
    /**
     * Escapes a value.
     *
     * @param value Value to escape.
     * @returns Escaped string.
     */
    escape(value: string): string;
}
//# sourceMappingURL=CSS.d.ts.map