import IEventInit from './IEventInit.js';
import * as PropertySymbol from '../PropertySymbol.js';
import EventTarget from './EventTarget.js';
import EventPhaseEnum from './EventPhaseEnum.js';
/**
 * Event.
 */
export default class Event {
    static NONE: EventPhaseEnum;
    static CAPTURING_PHASE: EventPhaseEnum;
    static AT_TARGET: EventPhaseEnum;
    static BUBBLING_PHASE: EventPhaseEnum;
    NONE: EventPhaseEnum;
    CAPTURING_PHASE: EventPhaseEnum;
    AT_TARGET: EventPhaseEnum;
    BUBBLING_PHASE: EventPhaseEnum;
    [PropertySymbol.composed]: boolean;
    [PropertySymbol.bubbles]: boolean;
    [PropertySymbol.cancelable]: boolean;
    [PropertySymbol.defaultPrevented]: boolean;
    [PropertySymbol.eventPhase]: EventPhaseEnum;
    [PropertySymbol.timeStamp]: number;
    [PropertySymbol.type]: string;
    [PropertySymbol.dispatching]: boolean;
    [PropertySymbol.immediatePropagationStopped]: boolean;
    [PropertySymbol.propagationStopped]: boolean;
    [PropertySymbol.target]: EventTarget | null;
    [PropertySymbol.currentTarget]: EventTarget | null;
    [PropertySymbol.isInPassiveEventListener]: boolean;
    /**
     * Constructor.
     *
     * @param type Event type.
     * @param [eventInit] Event init.
     */
    constructor(type: string, eventInit?: IEventInit | null);
    /**
     * Returns composed.
     *
     * @returns Composed.
     */
    get composed(): boolean;
    /**
     * Returns bubbles.
     *
     * @returns Bubbles.
     */
    get bubbles(): boolean;
    /**
     * Returns cancelable.
     *
     * @returns Cancelable.
     */
    get cancelable(): boolean;
    /**
     * Returns defaultPrevented.
     *
     * @returns Default prevented.
     */
    get defaultPrevented(): boolean;
    /**
     * Returns eventPhase.
     *
     * @returns Event phase.
     */
    get eventPhase(): EventPhaseEnum;
    /**
     * Returns timeStamp.
     *
     * @returns Time stamp.
     */
    get timeStamp(): number;
    /**
     * Returns type.
     *
     * @returns Type.
     */
    get type(): string;
    /**
     * Returns target.
     *
     * @returns Target.
     */
    get target(): EventTarget;
    /**
     * Returns target.
     *
     * @returns Target.
     */
    get currentTarget(): EventTarget;
    /**
     * Returns "true" if propagation has been stopped.
     *
     * @returns "true" if propagation has been stopped.
     */
    get cancelBubble(): boolean;
    /**
     * Returns composed path.
     *
     * @returns Composed path.
     */
    composedPath(): EventTarget[];
    /**
     * Init event.
     *
     * @deprecated
     * @param type Type.
     * @param [bubbles=false] "true" if it bubbles.
     * @param [cancelable=false] "true" if it cancelable.
     */
    initEvent(type: string, bubbles?: boolean, cancelable?: boolean): void;
    /**
     * Prevents default.
     */
    preventDefault(): void;
    /**
     * Stops immediate propagation.
     */
    stopImmediatePropagation(): void;
    /**
     * Stops propagation.
     */
    stopPropagation(): void;
}
//# sourceMappingURL=Event.d.ts.map