import Node from '../node/Node.js';
import * as PropertySymbol from '../../PropertySymbol.js';
import ShadowRoot from '../shadow-root/ShadowRoot.js';
import DOMRect from '../../dom/DOMRect.js';
import DOMTokenList from '../../dom/DOMTokenList.js';
import HTMLCollection from './HTMLCollection.js';
import DOMRectList from '../../dom/DOMRectList.js';
import Attr from '../attr/Attr.js';
import NamedNodeMap from './NamedNodeMap.js';
import Event from '../../event/Event.js';
import NodeTypeEnum from '../node/NodeTypeEnum.js';
import IHTMLElementTagNameMap from '../../config/IHTMLElementTagNameMap.js';
import ISVGElementTagNameMap from '../../config/ISVGElementTagNameMap.js';
import IChildNode from '../child-node/IChildNode.js';
import INonDocumentTypeChildNode from '../child-node/INonDocumentTypeChildNode.js';
import IParentNode from '../parent-node/IParentNode.js';
import NodeList from '../node/NodeList.js';
import CSSStyleDeclaration from '../../css/declaration/CSSStyleDeclaration.js';
import IScrollToOptions from '../../window/IScrollToOptions.js';
type InsertAdjacentPosition = 'beforebegin' | 'afterbegin' | 'beforeend' | 'afterend';
/**
 * Element.
 */
export default class Element extends Node implements IChildNode, INonDocumentTypeChildNode, IParentNode {
    #private;
    static [PropertySymbol.tagName]: string | null;
    static [PropertySymbol.localName]: string | null;
    static [PropertySymbol.namespaceURI]: string | null;
    cloneNode: (deep?: boolean) => Element;
    [PropertySymbol.classList]: DOMTokenList | null;
    [PropertySymbol.isValue]: string | null;
    [PropertySymbol.nodeType]: NodeTypeEnum;
    [PropertySymbol.prefix]: string | null;
    [PropertySymbol.shadowRoot]: ShadowRoot | null;
    [PropertySymbol.scrollHeight]: number;
    [PropertySymbol.scrollWidth]: number;
    [PropertySymbol.scrollTop]: number;
    [PropertySymbol.scrollLeft]: number;
    [PropertySymbol.attributes]: NamedNodeMap;
    [PropertySymbol.attributesProxy]: NamedNodeMap | null;
    [PropertySymbol.children]: HTMLCollection<Element> | null;
    [PropertySymbol.computedStyle]: CSSStyleDeclaration | null;
    [PropertySymbol.propertyEventListeners]: Map<string, ((event: Event) => void) | null>;
    [PropertySymbol.tagName]: string | null;
    [PropertySymbol.localName]: string | null;
    [PropertySymbol.namespaceURI]: string | null;
    /**
     * Constructor.
     */
    constructor();
    get onfullscreenerror(): ((event: Event) => void) | null;
    set onfullscreenerror(value: ((event: Event) => void) | null);
    get onfullscreenchange(): ((event: Event) => void) | null;
    set onfullscreenchange(value: ((event: Event) => void) | null);
    get onbeforecopy(): ((event: Event) => void) | null;
    set onbeforecopy(value: ((event: Event) => void) | null);
    get onbeforecut(): ((event: Event) => void) | null;
    set onbeforecut(value: ((event: Event) => void) | null);
    get onbeforepaste(): ((event: Event) => void) | null;
    set onbeforepaste(value: ((event: Event) => void) | null);
    get onsearch(): ((event: Event) => void) | null;
    set onsearch(value: ((event: Event) => void) | null);
    /**
     * Returns tag name.
     *
     * @returns Tag name.
     */
    get tagName(): string;
    /**
     * Returns prefix.
     *
     * @returns Prefix.
     */
    get prefix(): string | null;
    /**
     * Returns shadow root.
     *
     * @returns Shadow root.
     */
    get shadowRoot(): ShadowRoot | null;
    /**
     * Returns scroll height.
     *
     * @returns Scroll height.
     */
    get scrollHeight(): number;
    /**
     * Returns scroll width.
     *
     * @returns Scroll width.
     */
    get scrollWidth(): number;
    /**
     * Returns scroll top.
     *
     * @returns Scroll top.
     */
    get scrollTop(): number;
    /**
     * Sets scroll top.
     *
     * @param value Scroll top.
     */
    set scrollTop(value: number);
    /**
     * Returns scroll left.
     *
     * @returns Scroll left.
     */
    get scrollLeft(): number;
    /**
     * Sets scroll left.
     *
     * @param value Scroll left.
     */
    set scrollLeft(value: number);
    /**
     * Returns attributes.
     *
     * @returns Attributes.
     */
    get attributes(): NamedNodeMap;
    /**
     * Returns namespace URI.
     *
     * @returns Namespace URI.
     */
    get namespaceURI(): string | null;
    /**
     * Returns element children.
     */
    get children(): HTMLCollection<Element>;
    /**
     * Returns class list.
     *
     * @returns Class list.
     */
    get classList(): DOMTokenList;
    /**
     * Sets class list.
     *
     * @param value Class list.
     */
    set classList(value: string);
    /**
     * Returns ID.
     *
     * @returns ID.
     */
    get id(): string;
    /**
     * Sets ID.
     *
     * @param id ID.
     */
    set id(id: string);
    /**
     * Returns class name.
     *
     * @returns Class name.
     */
    get className(): string;
    /**
     * Sets class name.
     *
     * @param className Class name.
     */
    set className(className: string);
    /**
     * Node name.
     *
     * @returns Node name.
     */
    get nodeName(): string;
    /**
     * Local name.
     *
     * @returns Local name.
     */
    get localName(): string;
    /**
     * Returns role.
     *
     * @returns Role.
     */
    get role(): string;
    /**
     * Sets role.
     *
     * @param role Role.
     */
    set role(role: string);
    /**
     * Previous element sibling.
     *
     * @returns Element.
     */
    get previousElementSibling(): Element;
    /**
     * Next element sibling.
     *
     * @returns Element.
     */
    get nextElementSibling(): Element;
    /**
     * Get text value of children.
     *
     * @returns Text content.
     */
    get textContent(): string;
    /**
     * Sets text content.
     *
     * @param textContent Text content.
     */
    set textContent(textContent: string);
    /**
     * Returns inner HTML.
     *
     * @returns HTML.
     */
    get innerHTML(): string;
    /**
     * Sets inner HTML.
     *
     * @param html HTML.
     */
    set innerHTML(html: string);
    /**
     * Returns outer HTML.
     *
     * @returns HTML.
     */
    get outerHTML(): string;
    /**
     * Returns outer HTML.
     *
     * @param html HTML.
     */
    set outerHTML(html: string);
    /**
     * Last element child.
     *
     * @returns Element.
     */
    get childElementCount(): number;
    /**
     * First element child.
     *
     * @returns Element.
     */
    get firstElementChild(): Element;
    /**
     * Last element child.
     *
     * @returns Element.
     */
    get lastElementChild(): Element;
    /**
     * Returns slot.
     *
     * @returns Slot.
     */
    get slot(): string;
    /**
     * Returns slot.
     *
     * @param slot Slot.
     */
    set slot(title: string);
    /**
     * Returns inner HTML and optionally the content of shadow roots.
     *
     * @deprecated
     * @param [options] Options.
     * @param [options.includeShadowRoots] Set to "true" to include shadow roots.
     * @returns HTML.
     */
    getInnerHTML(options?: {
        includeShadowRoots?: boolean;
    }): string;
    /**
     * Returns inner HTML and optionally the content of shadow roots.
     *
     * @param [options] Options.
     * @param [options.serializableShadowRoots] A boolean value that specifies whether to include serializable shadow roots. The default value is false.
     * @param [options.shadowRoots] An array of ShadowRoot objects to serialize. These are included regardless of whether they are marked as serializable, or if they are open or closed. The default value is an empty array.
     * @returns HTML.
     */
    getHTML(options?: {
        serializableShadowRoots?: boolean;
        shadowRoots?: ShadowRoot[];
    }): string;
    /**
     * @override
     */
    [PropertySymbol.cloneNode](deep?: boolean): Element;
    /**
     * Removes the node from its parent.
     */
    remove(): void;
    /**
     * The Node.replaceWith() method replaces this Node in the children list of its parent with a set of Node or DOMString objects.
     *
     * @param nodes List of Node or DOMString.
     */
    replaceWith(...nodes: (Node | string)[]): void;
    /**
     * Inserts a set of Node or DOMString objects in the children list of this ChildNode's parent, just before this ChildNode. DOMString objects are inserted as equivalent Text nodes.
     *
     * @param nodes List of Node or DOMString.
     */
    before(...nodes: (string | Node)[]): void;
    /**
     * Inserts a set of Node or DOMString objects in the children list of this ChildNode's parent, just after this ChildNode. DOMString objects are inserted as equivalent Text nodes.
     *
     * @param nodes List of Node or DOMString.
     */
    after(...nodes: (string | Node)[]): void;
    /**
     * Inserts a set of Node objects or DOMString objects after the last child of the ParentNode. DOMString objects are inserted as equivalent Text nodes.
     *
     * @param nodes List of Node or DOMString.
     */
    append(...nodes: (string | Node)[]): void;
    /**
     * Inserts a set of Node objects or DOMString objects before the first child of the ParentNode. DOMString objects are inserted as equivalent Text nodes.
     *
     * @param nodes List of Node or DOMString.
     */
    prepend(...nodes: (string | Node)[]): void;
    /**
     * Replaces the existing children of a node with a specified new set of children.
     *
     * @param nodes List of Node or DOMString.
     */
    replaceChildren(...nodes: (string | Node)[]): void;
    /**
     * Inserts a node to the given position.
     *
     * @param position Position to insert element.
     * @param element Node to insert.
     * @returns Inserted node or null if couldn't insert.
     */
    insertAdjacentElement(position: InsertAdjacentPosition, element: Node): Node | null;
    /**
     * Inserts an HTML string to the given position.
     *
     * @param position Position to insert text.
     * @param text HTML string to insert.
     */
    insertAdjacentHTML(position: InsertAdjacentPosition, text: string): void;
    /**
     * Inserts text to the given position.
     *
     * @param position Position to insert text.
     * @param text String to insert.
     */
    insertAdjacentText(position: InsertAdjacentPosition, text: string): void;
    /**
     * Sets an attribute.
     *
     * @param name Name.
     * @param value Value.
     */
    setAttribute(name: string, value: string): void;
    /**
     * Sets a namespace attribute.
     *
     * @param namespaceURI Namespace URI.
     * @param name Name.
     * @param value Value.
     */
    setAttributeNS(namespaceURI: string, name: string, value: string): void;
    /**
     * Returns attribute names.
     *
     * @returns Attribute names.
     */
    getAttributeNames(): string[];
    /**
     * Returns attribute value.
     *
     * @param name Name.
     */
    getAttribute(name: string): string | null;
    /**
     * Toggle an attribute.
     * Returns `true` if attribute name is eventually present, and `false` otherwise.
     *
     * @param name A DOMString specifying the name of the attribute to be toggled.
     * @param force A boolean value to determine whether the attribute should be added or removed, no matter whether the attribute is present or not at the moment.
     */
    toggleAttribute(name: string, force?: boolean): boolean;
    /**
     * Returns namespace attribute value.
     *
     * @param namespace Namespace URI.
     * @param localName Local name.
     */
    getAttributeNS(namespace: string | null, localName: string): string | null;
    /**
     * Returns a boolean value indicating whether the specified element has the attribute or not.
     *
     * @param name Attribute name.
     * @returns True if attribute exists, false otherwise.
     */
    hasAttribute(name: string): boolean;
    /**
     * Returns a boolean value indicating whether the specified element has the namespace attribute or not.
     *
     * @param namespace Namespace URI.
     * @param localName Local name.
     * @returns True if attribute exists, false otherwise.
     */
    hasAttributeNS(namespace: string | null, localName: string): boolean;
    /**
     * Returns "true" if the element has attributes.
     *
     * @returns "true" if the element has attributes.
     */
    hasAttributes(): boolean;
    /**
     * Removes an attribute.
     *
     * @param name Name.
     */
    removeAttribute(name: string): void;
    /**
     * Removes a namespace attribute.
     *
     * @param namespace Namespace URI.
     * @param localName Local name.
     */
    removeAttributeNS(namespace: string | null, localName: string): void;
    /**
     * Attaches a shadow root.
     *
     * @param init Shadow root init.
     * @param init.mode Shadow root mode.
     * @param [init.clonable] Clonable.
     * @param [init.delegateFocus] Delegate focus.
     * @param [init.serializable] Serializable.
     * @param [init.slotAssignment] Slot assignment.
     * @returns Shadow root.
     */
    attachShadow(init: {
        mode: 'open' | 'closed';
        clonable?: boolean;
        delegateFocus?: boolean;
        serializable?: boolean;
        slotAssignment?: 'named' | 'manual';
    }): ShadowRoot;
    /**
     * Converts to string.
     *
     * @returns String.
     */
    toString(): string;
    /**
     * Returns the size of an element and its position relative to the viewport.
     *
     * @returns DOM rect.
     */
    getBoundingClientRect(): DOMRect;
    /**
     * Returns a collection of DOMRect objects that indicate the bounding rectangles for each CSS border box in a client.
     *
     * @see https://developer.mozilla.org/en-US/docs/Web/API/Element/getClientRects
     * @returns DOM rect list.
     */
    getClientRects(): DOMRectList;
    /**
     * The matches() method checks to see if the Element would be selected by the provided selectorString.
     *
     * @param selector Selector.
     * @returns "true" if matching.
     */
    matches(selector: string): boolean;
    /**
     * Traverses the Element and its parents (heading toward the document root) until it finds a node that matches the provided selector string.
     *
     * @param selector Selector.
     * @returns Closest matching element.
     */
    closest(selector: string): Element | null;
    /**
     * Connected callback.
     */
    connectedCallback?(): void;
    /**
     * Disconnected callback.
     */
    disconnectedCallback?(): void;
    /**
     * Attribute changed callback.
     *
     * @param name Name.
     * @param oldValue Old value.
     * @param newValue New value.
     */
    attributeChangedCallback?(name: string, oldValue: string | null, newValue: string | null): void;
    /**
     * Query CSS selector to find matching nodes.
     *
     * @param selector CSS selector.
     * @returns Matching elements.
     */
    querySelectorAll<K extends keyof IHTMLElementTagNameMap>(selector: K): NodeList<IHTMLElementTagNameMap[K]>;
    /**
     * Query CSS selector to find matching elements.
     *
     * @param selector CSS selector.
     * @returns Matching elements.
     */
    querySelectorAll<K extends keyof ISVGElementTagNameMap>(selector: K): NodeList<ISVGElementTagNameMap[K]>;
    /**
     * Query CSS selector to find matching elements.
     *
     * @param selector CSS selector.
     * @returns Matching elements.
     */
    querySelectorAll(selector: string): NodeList<Element>;
    /**
     * Query CSS Selector to find matching node.
     *
     * @param selector CSS selector.
     * @returns Matching element.
     */
    querySelector<K extends keyof IHTMLElementTagNameMap>(selector: K): IHTMLElementTagNameMap[K] | null;
    /**
     * Query CSS Selector to find matching node.
     *
     * @param selector CSS selector.
     * @returns Matching element.
     */
    querySelector<K extends keyof ISVGElementTagNameMap>(selector: K): ISVGElementTagNameMap[K] | null;
    /**
     * Query CSS Selector to find matching node.
     *
     * @param selector CSS selector.
     * @returns Matching element.
     */
    querySelector(selector: string): Element | null;
    /**
     * Returns an elements by class name.
     *
     * @param className Tag name.
     * @returns Matching element.
     */
    getElementsByClassName(className: string): HTMLCollection<Element>;
    /**
     * Returns an elements by tag name.
     *
     * @param tagName Tag name.
     * @returns Matching element.
     */
    getElementsByTagName<K extends keyof IHTMLElementTagNameMap>(tagName: K): HTMLCollection<IHTMLElementTagNameMap[K]>;
    /**
     * Returns an elements by tag name.
     *
     * @param tagName Tag name.
     * @returns Matching element.
     */
    getElementsByTagName<K extends keyof ISVGElementTagNameMap>(tagName: K): HTMLCollection<ISVGElementTagNameMap[K]>;
    /**
     * Returns an elements by tag name.
     *
     * @param tagName Tag name.
     * @returns Matching element.
     */
    getElementsByTagName(tagName: string): HTMLCollection<Element>;
    /**
     * Returns an elements by tag name and namespace.
     *
     * @param namespaceURI Namespace URI.
     * @param tagName Tag name.
     * @returns Matching element.
     */
    getElementsByTagNameNS<K extends keyof IHTMLElementTagNameMap>(namespaceURI: 'http://www.w3.org/1999/xhtml', tagName: K): HTMLCollection<IHTMLElementTagNameMap[K]>;
    /**
     * Returns an elements by tag name and namespace.
     *
     * @param namespaceURI Namespace URI.
     * @param tagName Tag name.
     * @returns Matching element.
     */
    getElementsByTagNameNS<K extends keyof ISVGElementTagNameMap>(namespaceURI: 'http://www.w3.org/2000/svg', tagName: K): HTMLCollection<ISVGElementTagNameMap[K]>;
    /**
     * Returns an elements by tag name and namespace.
     *
     * @param namespaceURI Namespace URI.
     * @param tagName Tag name.
     * @returns Matching element.
     */
    getElementsByTagNameNS(namespaceURI: string, tagName: string): HTMLCollection<Element>;
    /**
     * The setAttributeNode() method adds a new Attr node to the specified element.
     *
     * @param attribute Attribute.
     * @returns Replaced attribute.
     */
    setAttributeNode(attribute: Attr): Attr | null;
    /**
     * The setAttributeNodeNS() method adds a new Attr node to the specified element.
     *
     * @param attribute Attribute.
     * @returns Replaced attribute.
     */
    setAttributeNodeNS(attribute: Attr): Attr | null;
    /**
     * Returns an Attr node.
     *
     * @param name Name.
     * @returns Replaced attribute.
     */
    getAttributeNode(name: string): Attr | null;
    /**
     * Returns a namespaced Attr node.
     *
     * @param namespace Namespace.
     * @param localName Name.
     * @returns Replaced attribute.
     */
    getAttributeNodeNS(namespace: string | null, localName: string): Attr | null;
    /**
     * Removes an Attr node.
     *
     * @param attribute Attribute.
     * @returns Removed attribute.
     */
    removeAttributeNode(attribute: Attr): Attr | null;
    /**
     * Scrolls to a particular set of coordinates.
     *
     * @param x X position or options object.
     * @param y Y position.
     */
    scroll(x: IScrollToOptions | number, y?: number): void;
    /**
     * Scrolls to a particular set of coordinates.
     *
     * @param x X position or options object.
     * @param y Y position.
     */
    scrollTo(x: IScrollToOptions | number, y?: number): void;
    /**
     * Scrolls by a relative amount from the current position.
     *
     * @param x Pixels to scroll by from top or scroll options object.
     * @param y Pixels to scroll by from left.
     */
    scrollBy(x: IScrollToOptions | number, y?: number): void;
    /**
     * Scrolls the element's ancestor containers such that the element on which scrollIntoView() is called is visible to the user.
     *
     * @param [_options] Options.
     */
    scrollIntoView(_options?: boolean | {
        behavior?: 'smooth' | 'instant' | 'auto';
        block?: 'start' | 'center' | 'end' | 'nearest';
        inline?: 'start' | 'center' | 'end' | 'nearest';
    }): void;
    /**
     * @override
     */
    [PropertySymbol.appendChild](node: Node, disableValidations?: boolean): Node;
    /**
     * @override
     */
    [PropertySymbol.removeChild](node: Node): Node;
    /**
     * @override
     */
    [PropertySymbol.insertBefore](newNode: Node, referenceNode: Node | null, disableValidations?: boolean): Node;
    /**
     * Triggered when an attribute is set.
     *
     * @param attribute Attribute.
     * @param replacedAttribute Replaced attribute.
     */
    [PropertySymbol.onSetAttribute](attribute: Attr, replacedAttribute: Attr | null): void;
    /**
     * Triggered when an attribute is set.
     *
     * @param removedAttribute Attribute.
     */
    [PropertySymbol.onRemoveAttribute](removedAttribute: Attr): void;
    /**
     * @override
     */
    [PropertySymbol.connectedToDocument](): void;
    /**
     * @override
     */
    [PropertySymbol.disconnectedFromDocument](): void;
}
export {};
//# sourceMappingURL=Element.d.ts.map