import ElementEventAttributeUtility from '../element/ElementEventAttributeUtility.js';
import HTMLElement from '../html-element/HTMLElement.js';
import * as PropertySymbol from '../../PropertySymbol.js';
/**
 * HTMLBodyElement
 *
 * @see https://developer.mozilla.org/en-US/docs/Web/API/HTMLBodyElement
 */
export default class HTMLBodyElement extends HTMLElement {
    // Events
    /* eslint-disable jsdoc/require-jsdoc */
    get onafterprint() {
        return ElementEventAttributeUtility.getEventListener(this, 'onafterprint');
    }
    set onafterprint(value) {
        this[PropertySymbol.propertyEventListeners].set('onafterprint', value);
    }
    get onbeforeprint() {
        return ElementEventAttributeUtility.getEventListener(this, 'onbeforeprint');
    }
    set onbeforeprint(value) {
        this[PropertySymbol.propertyEventListeners].set('onbeforeprint', value);
    }
    get onbeforeunload() {
        return ElementEventAttributeUtility.getEventListener(this, 'onbeforeunload');
    }
    set onbeforeunload(value) {
        this[PropertySymbol.propertyEventListeners].set('onbeforeunload', value);
    }
    get ongamepadconnected() {
        return ElementEventAttributeUtility.getEventListener(this, 'ongamepadconnected');
    }
    set ongamepadconnected(value) {
        this[PropertySymbol.propertyEventListeners].set('ongamepadconnected', value);
    }
    get ongamepaddisconnected() {
        return ElementEventAttributeUtility.getEventListener(this, 'ongamepaddisconnected');
    }
    set ongamepaddisconnected(value) {
        this[PropertySymbol.propertyEventListeners].set('ongamepaddisconnected', value);
    }
    get onhashchange() {
        return ElementEventAttributeUtility.getEventListener(this, 'onhashchange');
    }
    set onhashchange(value) {
        this[PropertySymbol.propertyEventListeners].set('onhashchange', value);
    }
    get onlanguagechange() {
        return ElementEventAttributeUtility.getEventListener(this, 'onlanguagechange');
    }
    set onlanguagechange(value) {
        this[PropertySymbol.propertyEventListeners].set('onlanguagechange', value);
    }
    get onmessage() {
        return ElementEventAttributeUtility.getEventListener(this, 'onmessage');
    }
    set onmessage(value) {
        this[PropertySymbol.propertyEventListeners].set('onmessage', value);
    }
    get onmessageerror() {
        return ElementEventAttributeUtility.getEventListener(this, 'onmessageerror');
    }
    set onmessageerror(value) {
        this[PropertySymbol.propertyEventListeners].set('onmessageerror', value);
    }
    get onoffline() {
        return ElementEventAttributeUtility.getEventListener(this, 'onoffline');
    }
    set onoffline(value) {
        this[PropertySymbol.propertyEventListeners].set('onoffline', value);
    }
    get ononline() {
        return ElementEventAttributeUtility.getEventListener(this, 'ononline');
    }
    set ononline(value) {
        this[PropertySymbol.propertyEventListeners].set('ononline', value);
    }
    get onpagehide() {
        return ElementEventAttributeUtility.getEventListener(this, 'onpagehide');
    }
    set onpagehide(value) {
        this[PropertySymbol.propertyEventListeners].set('onpagehide', value);
    }
    get onpageshow() {
        return ElementEventAttributeUtility.getEventListener(this, 'onpageshow');
    }
    set onpageshow(value) {
        this[PropertySymbol.propertyEventListeners].set('onpageshow', value);
    }
    get onpopstate() {
        return ElementEventAttributeUtility.getEventListener(this, 'onpopstate');
    }
    set onpopstate(value) {
        this[PropertySymbol.propertyEventListeners].set('onpopstate', value);
    }
    get onrejectionhandled() {
        return ElementEventAttributeUtility.getEventListener(this, 'onrejectionhandled');
    }
    set onrejectionhandled(value) {
        this[PropertySymbol.propertyEventListeners].set('onrejectionhandled', value);
    }
    get onstorage() {
        return ElementEventAttributeUtility.getEventListener(this, 'onstorage');
    }
    set onstorage(value) {
        this[PropertySymbol.propertyEventListeners].set('onstorage', value);
    }
    get onunhandledrejection() {
        return ElementEventAttributeUtility.getEventListener(this, 'onunhandledrejection');
    }
    set onunhandledrejection(value) {
        this[PropertySymbol.propertyEventListeners].set('onunhandledrejection', value);
    }
    get onunload() {
        return ElementEventAttributeUtility.getEventListener(this, 'onunload');
    }
    set onunload(value) {
        this[PropertySymbol.propertyEventListeners].set('onunload', value);
    }
}
//# sourceMappingURL=HTMLBodyElement.js.map