import Event from '../../event/Event.js';
import HTMLElement from '../html-element/HTMLElement.js';
import * as PropertySymbol from '../../PropertySymbol.js';
/**
 * HTML Dialog Element.
 *
 * @see https://developer.mozilla.org/en-US/docs/Web/API/HTMLDialogElement
 */
export default class HTMLDialogElement extends HTMLElement {
    [PropertySymbol.returnValue]: string;
    get oncancel(): ((event: Event) => void) | null;
    set oncancel(value: ((event: Event) => void) | null);
    get onclose(): ((event: Event) => void) | null;
    set onclose(value: ((event: Event) => void) | null);
    /**
     * Returns return value.
     *
     * @returns Return value.
     */
    get returnValue(): string;
    /**
     * Sets return value.
     *
     * @param value Return value.
     */
    set returnValue(value: string);
    /**
     * Sets the "open" attribute.
     *
     * @param open Open.
     */
    set open(open: boolean);
    /**
     * Returns open.
     *
     * @returns Open.
     */
    get open(): boolean;
    /**
     * Closes the dialog.
     *
     * @param [returnValue] ReturnValue.
     */
    close(returnValue?: string): void;
    /**
     * Shows the modal.
     */
    showModal(): void;
    /**
     * Shows the dialog.
     */
    show(): void;
}
//# sourceMappingURL=HTMLDialogElement.d.ts.map