"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const ClassMethodBinder_js_1 = __importDefault(require("../utilities/ClassMethodBinder.cjs"));
const PropertySymbol = __importStar(require("../PropertySymbol.cjs"));
const ATTRIBUTE_SPLIT_REGEXP = /[\t\f\n\r ]+/;
/**
 * DOM Token List.
 *
 * Reference:
 * https://developer.mozilla.org/en-US/docs/Web/API/DOMTokenList.
 */
class DOMTokenList {
    [PropertySymbol.ownerElement];
    [PropertySymbol.attributeName];
    [PropertySymbol.cache] = {
        items: [],
        attributeValue: ''
    };
    [PropertySymbol.supports];
    /**
     * Constructor.
     *
     * @param illegalConstructorSymbol Illegal constructor symbol.
     * @param ownerElement Owner element.
     * @param attributeName Attribute name.
     * @param [supports] Supports.
     */
    constructor(illegalConstructorSymbol, ownerElement, attributeName, supports) {
        if (illegalConstructorSymbol !== PropertySymbol.illegalConstructor) {
            throw new TypeError('Illegal constructor');
        }
        this[PropertySymbol.ownerElement] = ownerElement;
        this[PropertySymbol.attributeName] = attributeName;
        this[PropertySymbol.supports] = supports || [];
        const methodBinder = new ClassMethodBinder_js_1.default(this, [DOMTokenList]);
        return new Proxy(this, {
            get: (target, property) => {
                if (property === 'length') {
                    return target[PropertySymbol.getTokenList]().length;
                }
                if (property in target || typeof property === 'symbol') {
                    methodBinder.bind(property);
                    return target[property];
                }
                const index = Number(property);
                if (!isNaN(index)) {
                    return target[PropertySymbol.getTokenList]()[index];
                }
            },
            set(target, property, newValue) {
                methodBinder.bind(property);
                if (typeof property === 'symbol') {
                    target[property] = newValue;
                    return true;
                }
                const index = Number(property);
                if (isNaN(index)) {
                    target[property] = newValue;
                }
                return true;
            },
            deleteProperty(target, property) {
                if (typeof property === 'symbol') {
                    delete target[property];
                    return true;
                }
                const index = Number(property);
                if (isNaN(index)) {
                    delete target[property];
                }
                return true;
            },
            ownKeys(target) {
                return Object.keys(target[PropertySymbol.getTokenList]());
            },
            has(target, property) {
                if (property in target) {
                    return true;
                }
                if (typeof property === 'symbol') {
                    return false;
                }
                const index = Number(property);
                return !isNaN(index) && index >= 0 && index < target[PropertySymbol.getTokenList]().length;
            },
            defineProperty(target, property, descriptor) {
                methodBinder.preventBinding(property);
                if (property in target) {
                    Object.defineProperty(target, property, descriptor);
                    return true;
                }
                return false;
            },
            getOwnPropertyDescriptor(target, property) {
                if (property in target || typeof property === 'symbol') {
                    return;
                }
                const index = Number(property);
                const items = target[PropertySymbol.getTokenList]();
                if (!isNaN(index) && items[index]) {
                    return {
                        value: items[index],
                        writable: false,
                        enumerable: true,
                        configurable: true
                    };
                }
            }
        });
    }
    /**
     * Returns length.
     *
     * @returns Length.
     */
    get length() {
        return this[PropertySymbol.getTokenList]().length;
    }
    /**
     * Set value.
     *
     * @param value Value.
     */
    set value(value) {
        this[PropertySymbol.ownerElement].setAttribute(this[PropertySymbol.attributeName], value);
    }
    /**
     * Get value.
     */
    get value() {
        return this[PropertySymbol.ownerElement].getAttribute(this[PropertySymbol.attributeName]) || '';
    }
    /**
     * Returns an iterator, allowing you to go through all values of the key/value pairs contained in this object.
     */
    [Symbol.iterator]() {
        return this[PropertySymbol.getTokenList]().values();
    }
    /**
     * Get ClassName.
     *
     * @param index Index.
     * */
    item(index) {
        const items = this[PropertySymbol.getTokenList]();
        if (typeof index === 'number') {
            return items[index] ? items[index] : null;
        }
        index = Number(index);
        index = isNaN(index) ? 0 : index;
        return items[index] ? items[index] : null;
    }
    /**
     * Replace Token.
     *
     * @param token Token.
     * @param newToken NewToken.
     */
    replace(token, newToken) {
        const list = this[PropertySymbol.getTokenList]().slice();
        const index = list.indexOf(token);
        if (index === -1) {
            return false;
        }
        list[index] = newToken;
        this[PropertySymbol.ownerElement].setAttribute(this[PropertySymbol.attributeName], list.join(' '));
        return true;
    }
    /**
     * Supports.
     *
     * @param token Token.
     */
    supports(token) {
        return this[PropertySymbol.supports].includes(token);
    }
    /**
     * Returns an iterator, allowing you to go through all values of the key/value pairs contained in this object.
     */
    values() {
        return this[PropertySymbol.getTokenList]().values();
    }
    /**
     * Returns an iterator, allowing you to go through all key/value pairs contained in this object.
     */
    entries() {
        return this[PropertySymbol.getTokenList]().entries();
    }
    /**
     * Executes a provided callback function once for each DOMTokenList element.
     *
     * @param callback
     * @param thisArg
     */
    forEach(callback, thisArg) {
        return this[PropertySymbol.getTokenList]().forEach(callback, thisArg);
    }
    /**
     * Returns an iterator, allowing you to go through all keys of the key/value pairs contained in this object.
     *
     */
    keys() {
        return this[PropertySymbol.getTokenList]().keys();
    }
    /**
     * Adds tokens.
     *
     * @param tokens Tokens.
     */
    add(...tokens) {
        const list = this[PropertySymbol.getTokenList]().slice();
        for (const token of tokens) {
            const index = list.indexOf(token);
            if (index === -1) {
                list.push(token);
            }
        }
        this[PropertySymbol.ownerElement].setAttribute(this[PropertySymbol.attributeName], list.join(' '));
    }
    /**
     * Removes tokens.
     *
     * @param tokens Tokens.
     */
    remove(...tokens) {
        const list = this[PropertySymbol.getTokenList]().slice();
        for (const token of tokens) {
            const index = list.indexOf(token);
            if (index !== -1) {
                list.splice(index, 1);
            }
        }
        this[PropertySymbol.ownerElement].setAttribute(this[PropertySymbol.attributeName], list.join(' '));
    }
    /**
     * Check if the list contains a class.
     *
     * @param className Class name.
     * @returns TRUE if it contains.
     */
    contains(className) {
        return this[PropertySymbol.getTokenList]().includes(className);
    }
    /**
     * Toggle a class name.
     *
     * @param token A string representing the class name you want to toggle.
     * @param [force] If included, turns the toggle into a one way-only operation. If set to `false`, then class name will only be removed, but not added. If set to `true`, then class name will only be added, but not removed.
     * @returns A boolean value, `true` or `false`, indicating whether class name is in the list after the call or not.
     */
    toggle(token, force) {
        let shouldAdd;
        if (force !== undefined) {
            shouldAdd = force;
        }
        else {
            shouldAdd = !this.contains(token);
        }
        if (shouldAdd) {
            this.add(token);
            return true;
        }
        this.remove(token);
        return false;
    }
    /**
     * Returns token list from attribute value.
     *
     * @see https://infra.spec.whatwg.org/#split-on-ascii-whitespace
     */
    [PropertySymbol.getTokenList]() {
        const attributeValue = this[PropertySymbol.ownerElement].getAttribute(this[PropertySymbol.attributeName]) ?? '';
        const cache = this[PropertySymbol.cache];
        if (cache.attributeValue === attributeValue) {
            return cache.items;
        }
        // It is possible to make this statement shorter by using Array.from() and Set, but this is faster when comparing using a bench test.
        const items = [];
        const trimmed = attributeValue.trim();
        if (trimmed) {
            for (const item of trimmed.split(ATTRIBUTE_SPLIT_REGEXP)) {
                if (!items.includes(item)) {
                    items.push(item);
                }
            }
        }
        cache.attributeValue = attributeValue;
        cache.items = items;
        return items;
    }
    /**
     * Returns DOMTokenList value.
     */
    toString() {
        return this.value || '';
    }
}
exports.default = DOMTokenList;
//# sourceMappingURL=DOMTokenList.cjs.map