"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const HTMLCollection_js_1 = __importDefault(require("../element/HTMLCollection.cjs"));
const HTMLElement_js_1 = __importDefault(require("../html-element/HTMLElement.cjs"));
const PropertySymbol = __importStar(require("../../PropertySymbol.cjs"));
const QuerySelector_js_1 = __importDefault(require("../../query-selector/QuerySelector.cjs"));
const HTMLTableSectionElement_js_1 = __importDefault(require("../html-table-section-element/HTMLTableSectionElement.cjs"));
const DOMExceptionNameEnum_js_1 = __importDefault(require("../../exception/DOMExceptionNameEnum.cjs"));
/**
 * HTMLTableRowElement
 *
 * @see https://developer.mozilla.org/en-US/docs/Web/API/HTMLTableRowElement
 */
class HTMLTableRowElement extends HTMLElement_js_1.default {
    [PropertySymbol.cells] = null;
    /**
     * Returns cells.
     *
     * @returns Cells.
     */
    get cells() {
        if (!this[PropertySymbol.cells]) {
            this[PropertySymbol.cells] = new HTMLCollection_js_1.default(PropertySymbol.illegalConstructor, () => (QuerySelector_js_1.default.querySelectorAll(this, 'td,th')[PropertySymbol.items]));
        }
        return this[PropertySymbol.cells];
    }
    /**
     * Returns a number that gives the logical position of the row within the entire table. If the row is not part of a table, returns -1.
     *
     * @returns Row index.
     */
    get rowIndex() {
        let parent = this.parentNode;
        while (parent) {
            if (parent[PropertySymbol.tagName] === 'TABLE') {
                const rows = QuerySelector_js_1.default.querySelectorAll(parent, 'tr')[PropertySymbol.items];
                return rows.indexOf(this);
            }
            parent = parent.parentNode;
        }
        return -1;
    }
    /**
     * Returns a number that gives the logical position of the row within the table section it belongs to. If the row is not part of a section, returns -1.
     */
    get sectionRowIndex() {
        let parent = this.parentNode;
        while (parent) {
            if (parent instanceof HTMLTableSectionElement_js_1.default) {
                const rows = QuerySelector_js_1.default.querySelectorAll(parent, 'tr')[PropertySymbol.items];
                return rows.indexOf(this);
            }
            parent = parent.parentNode;
        }
        return -1;
    }
    /**
     * Returns an HTMLTableCellElement representing a new cell of the row. The cell is inserted in the collection of cells immediately before the given index position in the row. If index is -1, the new cell is appended to the collection. If index is less than -1 or greater than the number of cells in the collection, a DOMException with the value IndexSizeError is raised.
     *
     * @param [index] Index.
     * @returns Cell.
     */
    insertCell(index = -1) {
        if (typeof index !== 'number') {
            index = -1;
        }
        const cells = QuerySelector_js_1.default.querySelectorAll(this, 'td,th')[PropertySymbol.items];
        if (index < -1) {
            throw new this[PropertySymbol.window].DOMException(`Failed to execute 'insertCell' on 'HTMLTableRowElement': The index provided (${index}) is less than -1.`, DOMExceptionNameEnum_js_1.default.indexSizeError);
        }
        if (index > cells.length) {
            throw new this[PropertySymbol.window].DOMException(`Failed to execute 'insertCell' on 'HTMLTableRowElement': The index provided (${index}) is greater than the number of cells (${cells.length}).`, DOMExceptionNameEnum_js_1.default.indexSizeError);
        }
        const cell = this[PropertySymbol.ownerDocument].createElement('td');
        if (index === -1 || index === cells.length) {
            this.appendChild(cell);
            return cell;
        }
        cells[index].parentNode?.insertBefore(cell, cells[index]);
        return cell;
    }
    /**
     * Removes the cell corresponding to index. If index is -1, the last cell of the row is removed. If index is less than -1 or greater than the amount of cells in the collection, a DOMException with the value IndexSizeError is raised.
     *
     * @param index Index.
     */
    deleteCell(index) {
        if (arguments.length === 0) {
            throw new this[PropertySymbol.window].TypeError("Failed to execute 'deleteCell' on 'HTMLTableRowElement': 1 argument required, but only 0 present.");
        }
        if (typeof index !== 'number') {
            index = -1;
        }
        if (index < -1) {
            throw new this[PropertySymbol.window].DOMException(`Failed to execute 'deleteCell' on 'HTMLTableRowElement': The index provided (${index}) is less than -1.`, DOMExceptionNameEnum_js_1.default.indexSizeError);
        }
        const cells = QuerySelector_js_1.default.querySelectorAll(this, 'td,th')[PropertySymbol.items];
        if (index >= cells.length) {
            throw new this[PropertySymbol.window].DOMException(`Failed to execute 'deleteCell' on 'HTMLTableRowElement': The index provided (${index}) is greater than the number of cells in the row (${cells.length}).`, DOMExceptionNameEnum_js_1.default.indexSizeError);
        }
        if (index === -1) {
            index = cells.length - 1;
        }
        cells[index].remove();
    }
}
exports.default = HTMLTableRowElement;
//# sourceMappingURL=HTMLTableRowElement.cjs.map