"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const TreeWalker_js_1 = __importDefault(require("./TreeWalker.cjs"));
const PropertySymbol = __importStar(require("../PropertySymbol.cjs"));
const NodeFilter_js_1 = __importDefault(require("./NodeFilter.cjs"));
/**
 * The NodeIterator object represents the nodes of a document subtree and a position within them.
 *
 * Reference:
 * https://developer.mozilla.org/en-US/docs/Web/API/NodeIterator
 */
class NodeIterator {
    #root;
    #whatToShow = -1;
    #filter = null;
    #walker;
    #atRoot = true;
    /**
     * Constructor.
     *
     * @param root Root.
     * @param [whatToShow] What to show.
     * @param [filter] Filter.
     */
    constructor(root, whatToShow = -1, filter = null) {
        this.#root = root;
        this.#whatToShow = whatToShow;
        this.#filter = filter;
        this.#walker = new TreeWalker_js_1.default(root, whatToShow, filter);
    }
    /**
     * Returns root.
     *
     * @returns Root.
     */
    get root() {
        return this.#root;
    }
    /**
     * Returns what to show.
     *
     * @returns What to show.
     */
    get whatToShow() {
        return this.#whatToShow;
    }
    /**
     * Returns filter.
     *
     * @returns Filter.
     */
    get filter() {
        return this.#filter;
    }
    /**
     * Moves the current Node to the next visible node in the document order.
     *
     * @returns Current node.
     */
    nextNode() {
        if (this.#atRoot) {
            this.#atRoot = false;
            if (this.#walker[PropertySymbol.filterNode](this.#root) !== NodeFilter_js_1.default.FILTER_ACCEPT) {
                return this.#walker.nextNode();
            }
            return this.#root;
        }
        return this.#walker.nextNode();
    }
    /**
     * Moves the current Node to the previous visible node in the document order, and returns the found node. It also moves the current node to this one. If no such node exists, or if it is before that the root node defined at the object construction, returns null and the current node is not changed.
     *
     * @returns Current node.
     */
    previousNode() {
        return this.#walker.previousNode();
    }
}
exports.default = NodeIterator;
//# sourceMappingURL=NodeIterator.cjs.map