"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const CrossOriginBrowserWindow_js_1 = __importDefault(require("./CrossOriginBrowserWindow.cjs"));
const FetchCORSUtility_js_1 = __importDefault(require("../fetch/utilities/FetchCORSUtility.cjs"));
const BrowserFrameURL_js_1 = __importDefault(require("../browser/utilities/BrowserFrameURL.cjs"));
const url_1 = require("url");
const PropertySymbol = __importStar(require("../PropertySymbol.cjs"));
/**
 * Window page open handler.
 */
class WindowPageOpenUtility {
    /**
     * Opens a page.
     *
     * @param browserFrame Browser frame.
     * @param [options] Options.
     * @param [options.url] URL.
     * @param [options.target] Target.
     * @param [options.features] Window features.
     */
    static openPage(browserFrame, options) {
        const features = this.getWindowFeatures(options?.features || '');
        const target = options?.target !== undefined ? String(options.target) : null;
        const originURL = new url_1.URL(browserFrame.window.location.href);
        const targetURL = BrowserFrameURL_js_1.default.getRelativeURL(browserFrame, options?.url);
        const oldWindow = browserFrame.window;
        let targetFrame;
        if (browserFrame.window !== oldWindow) {
            return null;
        }
        switch (target) {
            case '_self':
                targetFrame = browserFrame;
                break;
            case '_top':
                targetFrame = browserFrame.page.mainFrame;
                break;
            case '_parent':
                targetFrame = browserFrame.parentFrame ?? browserFrame;
                break;
            case '_blank':
            default:
                const newPage = browserFrame.page.context.newPage();
                targetFrame = newPage.mainFrame;
                targetFrame[PropertySymbol.openerFrame] = browserFrame;
                break;
        }
        targetFrame
            .goto(targetURL.href, {
            referrer: features.noreferrer ? undefined : browserFrame.window.location.origin,
            referrerPolicy: features.noreferrer ? 'no-referrer' : undefined
        })
            .catch((error) => {
            targetFrame.page.console.error(error);
        });
        if (targetURL.protocol === 'javascript:') {
            return targetFrame.window;
        }
        // When using a detached Window instance directly and not via the Browser API we will not navigate and the window for the frame will not have changed.
        if (targetFrame === browserFrame && browserFrame.window === oldWindow) {
            return null;
        }
        if (features.popup && target !== '_self' && target !== '_top' && target !== '_parent') {
            targetFrame[PropertySymbol.popup] = true;
            if (features?.width || features?.height) {
                targetFrame.page.setViewport({
                    width: features?.width,
                    height: features?.height
                });
            }
            if (features?.left) {
                targetFrame.window.screenLeft = features.left;
                targetFrame.window.screenX = features.left;
            }
            if (features?.top) {
                targetFrame.window.screenTop = features.top;
                targetFrame.window.screenY = features.top;
            }
        }
        if (target &&
            target !== '_self' &&
            target !== '_top' &&
            target !== '_parent' &&
            target !== '_blank') {
            targetFrame.window.name = target;
        }
        const isCORS = FetchCORSUtility_js_1.default.isCORS(originURL, targetFrame.url);
        if (!features.noopener &&
            !features.noreferrer &&
            browserFrame.window &&
            targetFrame[PropertySymbol.openerFrame] &&
            targetFrame.window !== browserFrame.window) {
            targetFrame[PropertySymbol.openerWindow] = isCORS
                ? new CrossOriginBrowserWindow_js_1.default(browserFrame.window)
                : browserFrame.window;
        }
        if (features.noopener || features.noreferrer) {
            return null;
        }
        if (isCORS) {
            return new CrossOriginBrowserWindow_js_1.default(targetFrame.window, browserFrame.window);
        }
        return targetFrame.window;
    }
    /**
     * Returns window features.
     *
     * @param features Window features string.
     * @returns Window features.
     */
    static getWindowFeatures(features) {
        const parts = features.split(',');
        const result = {
            popup: false,
            width: 0,
            height: 0,
            left: 0,
            top: 0,
            noopener: false,
            noreferrer: false
        };
        for (const part of parts) {
            const [key, value] = part.split('=');
            switch (key) {
                case 'popup':
                    result.popup = !value || value === 'yes' || value === '1' || value === 'true';
                    break;
                case 'width':
                case 'innerWidth':
                    result.width = parseInt(value, 10);
                    break;
                case 'height':
                case 'innerHeight':
                    result.height = parseInt(value, 10);
                    break;
                case 'left':
                case 'screenX':
                    result.left = parseInt(value, 10);
                    break;
                case 'top':
                case 'screenY':
                    result.top = parseInt(value, 10);
                    break;
                case 'noopener':
                    result.noopener = true;
                    break;
                case 'noreferrer':
                    result.noreferrer = true;
                    break;
            }
        }
        return result;
    }
}
exports.default = WindowPageOpenUtility;
//# sourceMappingURL=WindowPageOpenUtility.cjs.map