"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const PropertySymbol = __importStar(require("../PropertySymbol.cjs"));
const Node_js_1 = __importDefault(require("../nodes/node/Node.cjs"));
const NodeTypeEnum_js_1 = __importDefault(require("../nodes/node/NodeTypeEnum.cjs"));
const HTMLElementConfig_js_1 = __importDefault(require("../config/HTMLElementConfig.cjs"));
const HTMLElementConfigContentModelEnum_js_1 = __importDefault(require("../config/HTMLElementConfigContentModelEnum.cjs"));
const NamespaceURI_js_1 = __importDefault(require("../config/NamespaceURI.cjs"));
const XMLEncodeUtility_js_1 = __importDefault(require("../utilities/XMLEncodeUtility.cjs"));
/**
 * Serializes a node into XML.
 *
 * @see https://developer.mozilla.org/en-US/docs/Web/API/XMLSerializer
 */
class XMLSerializer {
    /**
     * Serializes a node into XML.
     *
     * @param root Root node.
     * @returns Result.
     */
    serializeToString(root) {
        return this.#serializeToString(root);
    }
    /**
     * Serializes a node into XML.
     *
     * @param root Root node.
     * @param [inheritedDefaultNamespace] Default namespace.
     * @param [inheritedNamespacePrefixes] Inherited namespace prefixes.
     * @returns Result.
     */
    #serializeToString(root, inheritedDefaultNamespace = null, inheritedNamespacePrefixes = null) {
        switch (root[PropertySymbol.nodeType]) {
            case NodeTypeEnum_js_1.default.elementNode:
                const element = root;
                const localName = element[PropertySymbol.localName];
                let innerHTML = '';
                const namespacePrefixes = this.#getNamespacePrefixes(element, inheritedNamespacePrefixes);
                const elementPrefix = element[PropertySymbol.namespaceURI] === NamespaceURI_js_1.default.html
                    ? element[PropertySymbol.prefix]
                    : this.#getElementPrefix(element, namespacePrefixes);
                const tagName = `${elementPrefix ? elementPrefix + ':' : ''}${localName}`;
                const defaultNamespace = elementPrefix
                    ? inheritedDefaultNamespace
                    : element[PropertySymbol.namespaceURI] || inheritedDefaultNamespace;
                const attributes = this.#getAttributes(element, elementPrefix, inheritedDefaultNamespace, inheritedNamespacePrefixes);
                const childNodes = defaultNamespace === NamespaceURI_js_1.default.html && localName === 'template'
                    ? root.content[PropertySymbol.nodeArray]
                    : root[PropertySymbol.nodeArray];
                for (const node of childNodes) {
                    innerHTML += this.#serializeToString(node, defaultNamespace, namespacePrefixes);
                }
                if (!innerHTML &&
                    defaultNamespace === NamespaceURI_js_1.default.html &&
                    HTMLElementConfig_js_1.default[localName.toLowerCase()]?.contentModel ===
                        HTMLElementConfigContentModelEnum_js_1.default.noDescendants) {
                    return `<${tagName}${attributes} />`;
                }
                if (!innerHTML && defaultNamespace !== NamespaceURI_js_1.default.html) {
                    return `<${tagName}${attributes}/>`;
                }
                return `<${tagName}${attributes}>${innerHTML}</${tagName}>`;
            case Node_js_1.default.DOCUMENT_FRAGMENT_NODE:
            case Node_js_1.default.DOCUMENT_NODE:
                let html = '';
                if (root[PropertySymbol.xmlProcessingInstruction]) {
                    html += this.#serializeToString(root[PropertySymbol.xmlProcessingInstruction], inheritedDefaultNamespace, new Map(inheritedNamespacePrefixes));
                }
                for (const node of root[PropertySymbol.nodeArray]) {
                    html += this.#serializeToString(node, inheritedDefaultNamespace, new Map(inheritedNamespacePrefixes));
                }
                return html;
            case NodeTypeEnum_js_1.default.commentNode:
                return `<!--${root.textContent}-->`;
            case NodeTypeEnum_js_1.default.processingInstructionNode:
                return `<?${root.target} ${root.textContent}?>`;
            case NodeTypeEnum_js_1.default.textNode:
                const parentElement = root.parentElement;
                if (parentElement) {
                    const parentConfig = HTMLElementConfig_js_1.default[parentElement[PropertySymbol.localName]];
                    if (parentConfig?.contentModel === HTMLElementConfigContentModelEnum_js_1.default.rawText) {
                        return root.textContent;
                    }
                }
                return XMLEncodeUtility_js_1.default.encodeTextContent(root.textContent);
            case NodeTypeEnum_js_1.default.documentTypeNode:
                const doctype = root;
                const identifier = doctype.publicId ? ' PUBLIC' : doctype.systemId ? ' SYSTEM' : '';
                const publicId = doctype.publicId ? ` "${doctype.publicId}"` : '';
                const systemId = doctype.systemId ? ` "${doctype.systemId}"` : '';
                return `<!DOCTYPE ${doctype.name}${identifier}${publicId}${systemId}>`;
        }
        return '';
    }
    /**
     * Returns namespace prefixes.
     *
     * @param element Element.
     * @param inheritedNamespacePrefixes Inherited namespace prefixes.
     * @returns Namespace prefixes.
     */
    #getNamespacePrefixes(element, inheritedNamespacePrefixes) {
        const namespacePrefixes = new Map(inheritedNamespacePrefixes);
        for (const attribute of element[PropertySymbol.attributes][PropertySymbol.items].values()) {
            if (attribute[PropertySymbol.namespaceURI] === NamespaceURI_js_1.default.xmlns &&
                attribute[PropertySymbol.prefix]) {
                namespacePrefixes.set(attribute[PropertySymbol.value], attribute[PropertySymbol.localName]);
            }
        }
        return namespacePrefixes;
    }
    /**
     * Returns namespace prefixes.
     *
     * @param element Element.
     * @param namespacePrefixes Inherited namespace prefixes.
     * @returns Element prefix.
     */
    #getElementPrefix(element, namespacePrefixes) {
        if (element[PropertySymbol.prefix] && !element[PropertySymbol.namespaceURI]) {
            throw new Error('Element has a prefix but no namespace.');
        }
        if (!element[PropertySymbol.prefix] || !namespacePrefixes) {
            return null;
        }
        const elementPrefix = namespacePrefixes.get(element[PropertySymbol.namespaceURI]);
        if (elementPrefix) {
            return elementPrefix;
        }
        const existingPrefixes = new Set(namespacePrefixes.values());
        if (existingPrefixes.has(element[PropertySymbol.prefix])) {
            let i = 1;
            while (existingPrefixes.has('n' + i)) {
                i++;
            }
            namespacePrefixes.set(element[PropertySymbol.namespaceURI], 'n' + i);
            return 'n' + i;
        }
        namespacePrefixes.set(element[PropertySymbol.namespaceURI], element[PropertySymbol.prefix]);
        return element[PropertySymbol.prefix];
    }
    /**
     * Returns attributes as a string.
     *
     * @param element Element.
     * @param elementPrefix Element prefix.
     * @param inheritedDefaultNamespace Inherited default namespace.
     * @param inheritedNamespacePrefixes Inherited namespace prefixes.
     * @returns Attributes.
     */
    #getAttributes(element, elementPrefix, inheritedDefaultNamespace, inheritedNamespacePrefixes) {
        let attributeString = '';
        let namespaceString = '';
        const handledNamespaces = new Set();
        for (const attribute of element[PropertySymbol.attributes][PropertySymbol.items].values()) {
            // Namespace attributes should be in the beginning of the string.
            if (attribute[PropertySymbol.namespaceURI] === NamespaceURI_js_1.default.xmlns) {
                if (elementPrefix &&
                    attribute[PropertySymbol.localName] === elementPrefix &&
                    element[PropertySymbol.namespaceURI]) {
                    namespaceString += ` xmlns:${elementPrefix}="${XMLEncodeUtility_js_1.default.encodeXMLAttributeValue(element[PropertySymbol.namespaceURI])}"`;
                    handledNamespaces.add(element[PropertySymbol.namespaceURI]);
                }
                else if (!elementPrefix &&
                    attribute[PropertySymbol.name] === 'xmlns' &&
                    element[PropertySymbol.namespaceURI]) {
                    namespaceString += ` xmlns="${XMLEncodeUtility_js_1.default.encodeXMLAttributeValue(element[PropertySymbol.namespaceURI])}"`;
                    handledNamespaces.add(element[PropertySymbol.namespaceURI]);
                }
                else {
                    namespaceString += ` ${attribute[PropertySymbol.name]}="${XMLEncodeUtility_js_1.default.encodeXMLAttributeValue(attribute[PropertySymbol.value])}"`;
                    handledNamespaces.add(attribute[PropertySymbol.value]);
                }
            }
            else {
                attributeString += ` ${attribute[PropertySymbol.name]}="${XMLEncodeUtility_js_1.default.encodeXMLAttributeValue(attribute[PropertySymbol.value])}"`;
            }
        }
        // We should add the namespace as an attribute if it has not been added yet.
        if (element[PropertySymbol.namespaceURI] &&
            inheritedDefaultNamespace !== element[PropertySymbol.namespaceURI] &&
            !handledNamespaces.has(element[PropertySymbol.namespaceURI])) {
            if (elementPrefix && !inheritedNamespacePrefixes?.has(element[PropertySymbol.namespaceURI])) {
                namespaceString += ` xmlns:${elementPrefix}="${XMLEncodeUtility_js_1.default.encodeXMLAttributeValue(element[PropertySymbol.namespaceURI])}"`;
            }
            else if (!elementPrefix &&
                inheritedDefaultNamespace !== element[PropertySymbol.namespaceURI]) {
                namespaceString += ` xmlns="${XMLEncodeUtility_js_1.default.encodeXMLAttributeValue(element[PropertySymbol.namespaceURI])}"`;
            }
        }
        return namespaceString + attributeString;
    }
}
exports.default = XMLSerializer;
//# sourceMappingURL=XMLSerializer.cjs.map