'use strict';

var _mocha = require('mocha');

var _chai = require('chai');

var _fs = require('fs');

var _fs2 = _interopRequireDefault(_fs);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _index = require('./index');

var _index2 = _interopRequireDefault(_index);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(0, _mocha.describe)('independent', function () {
  (0, _mocha.it)('should replace relative require path with package name', function () {
    var filePath = _path2.default.resolve(__dirname, './test/require-example/example.js');
    return (0, _index2.default)({
      code: _fs2.default.readFileSync(filePath, 'utf8'),
      path: filePath
    }).then(function (icode) {
      (0, _chai.expect)(icode).to.eq(['\'use strict\'', "require('other-package')", "require('foo-bar/qar')", "const fooBar = require('foo-bar')", 'console.log(fooBar)', ''].join('\n'));
    });
  });

  (0, _mocha.it)('should replace relative import path with package name', function () {
    var filePath = _path2.default.resolve(__dirname, './test/import-example/example.js');
    return (0, _index2.default)({
      code: _fs2.default.readFileSync(filePath, 'utf8'),
      path: filePath
    }).then(function (icode) {
      (0, _chai.expect)(icode).to.eq(["import fooBar from 'foo-bar'", 'console.log(fooBar)', ''].join('\n'));
    });
  });
});