'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = independent;

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _resolve = require('resolve');

var _resolve2 = _interopRequireDefault(_resolve);

var _relative = require('relative');

var _relative2 = _interopRequireDefault(_relative);

var _readPkgUp = require('read-pkg-up');

var _readPkgUp2 = _interopRequireDefault(_readPkgUp);

var _asyncReplace = require('@zkochan/async-replace');

var _asyncReplace2 = _interopRequireDefault(_asyncReplace);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function independent(opts) {
  opts = opts || {};

  if (!opts.code) throw new Error('opts.code is required');

  if (!opts.path) throw new Error('opts.path is required');

  var basedir = _path2.default.dirname(opts.path);

  return (0, _asyncReplace2.default)(opts.code, /(require\(['"]| from ['"])(\.[a-zA-Z0-9\-_\/\.]*)(['"])/g, requireReplacer);

  function requireReplacer(match, requireOpen, relativePath, requireClose) {
    var absolutePath = resolvePath(relativePath);

    return (0, _readPkgUp2.default)({ cwd: absolutePath }).then(function (result) {
      if (!result.pkg) return match;

      var externalPath = getExternalPath({
        pkg: result.pkg,
        pkgRoot: _path2.default.dirname(result.path),
        filePath: absolutePath
      });
      return requireOpen + externalPath + requireClose;
    });
  }

  function resolvePath(requirePath) {
    return _resolve2.default.sync(requirePath, { basedir: basedir });
  }
}

function getExternalPath(opts) {
  var mainPath = _path2.default.resolve(opts.pkgRoot, opts.pkg.main || './index.js');

  if (mainPath === opts.filePath) return opts.pkg.name;

  return opts.pkg.name + '/' + noExt((0, _relative2.default)(opts.pkgRoot, opts.filePath));
}

function noExt(filePath) {
  return filePath.replace(/\.js$/, '');
}
module.exports = exports['default'];