# Lineicons - Free Essential Icons for Designers and Developers

Lineicons provides an extensive library of essential icons, perfect for designers and developers seeking high-quality, free icons. Our free basic version includes over 600 icons in a clean, line-style design, available for use in any personal or commercial projects without attribution.

## Installation

You can install Lineicons easily as an [npm package](https://www.npmjs.com/package/lineicons).

```bash
npm install lineicons
```

Or, using Yarn:

```bash
yarn add lineicons
```

## Usage

### Using CSS (Icon Font)

To use Lineicons with CSS, link the `lineicons.css` file in your project’s `<head>`:

```html
<head>
  <link href="[/project_path]/dist/lineicons.css" rel="stylesheet" />
</head>
```

Now you can start using Lineicons:

```html
<i class="lni lni-add-file"></i>
```

### Using SVG as a Web Component (HTML, Vue, etc.)

Alternatively, use SVG icons directly in your HTML, offering greater flexibility such as scaling, multi-color options, and advanced CSS animations, all while maintaining high resolution.

Add the following script to your project:

```html
<script type="module" src="[/project_path]/dist/lineicons.js"></script>
```

You can now use the `<line-icon>` custom element in your HTML:

```html
<line-icon name="home" type="regular"></line-icon>
```

This approach ensures icons remain sharp, no matter the size.

### Using Icon Font CDN

For a quick start, Lineicons is also available via CDN, compatible with both free and premium versions.

```html
<link rel="stylesheet" href="https://cdn.lineicons.com/5.0/lineicons.css" />
```

You can download icons in various formats, including React, SVG, PNG, Figma, Vue, Svelte, and more from our [Icons page](https://lineicons.com/icons).

## Useful Links and Resources

- [Documentation](https://lineicons.com/docs)
- [Explore and Download All Icons](https://lineicons.com/)
- [Lineicons Pro Pricing](https://lineicons.com/pricing)

[![Visit Lineicons](https://cdn.pimjo.com/lineicons-5.jpg)](https://lineicons.com/)

- [Lineicons Figma Plugin](https://www.figma.com/community/plugin/1217738304122072948/Lineicons)
- [Lineicons - Figma Source](https://www.figma.com/community/file/1198194066179400874)

## Support

Support our project and inspire our team by [starring 🌟 our repository](https://github.com/LineiconsHQ/Lineicons) and sharing it with others. If you enjoy using Lineicons, consider upgrading to [Lineicons Pro](https://lineicons.com/pro/).

## License

Lineicons Basic is completely free! Feel free to use it in personal or commercial projects, no attribution required.