var __create = Object.create;
var __defProp = Object.defineProperty;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __markAsModule = (target) => __defProp(target, "__esModule", {value: true});
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, {get: all[name], enumerable: true});
};
var __exportStar = (target, module2, desc) => {
  if (module2 && typeof module2 === "object" || typeof module2 === "function") {
    for (let key of __getOwnPropNames(module2))
      if (!__hasOwnProp.call(target, key) && key !== "default")
        __defProp(target, key, {get: () => module2[key], enumerable: !(desc = __getOwnPropDesc(module2, key)) || desc.enumerable});
  }
  return target;
};
var __toModule = (module2) => {
  return __exportStar(__markAsModule(__defProp(module2 != null ? __create(__getProtoOf(module2)) : {}, "default", module2 && module2.__esModule && "default" in module2 ? {get: () => module2.default, enumerable: true} : {value: module2, enumerable: true})), module2);
};

// packages/lwr/src/cli/commands/audit.ts
__markAsModule(exports);
__export(exports, {
  createAuditCommand: () => createAuditCommand
});
var import_compiler = __toModule(require("@lwc/compiler"));
var import_module_resolver = __toModule(require("@lwc/module-resolver"));
var import_es_module_lexer = __toModule(require("es-module-lexer"));
var import_config = __toModule(require("@lwrjs/config"));
var import_shared_utils = __toModule(require("@lwrjs/shared-utils"));
var import_commander = __toModule(require("commander"));
var import_chalk = __toModule(require("chalk"));
var import_path = __toModule(require("path"));
var import_fs = __toModule(require("fs"));
var import_object_treeify = __toModule(require("object-treeify"));
var import_xml2js = __toModule(require("xml2js"));
var CAPABILITY_SSR_ONLY = "lightning__ServerRenderable";
var CAPABILITY_SSR_HYDRATION = "lightning__ServerRenderableWithHydration";
var CAPABILITY_UNKNOWN = "Unknown";
var CAPABILITY_PRIVATE = "Private";
var PLATFORM_NS = ["lwr", "webruntime"];
var LWC_REGEX = /^[\w-]+\/[\w-]+$/;
var LWC_TRANSFORM_CONFIG = {
  experimentalDynamicComponent: {strictSpecifier: false},
  enableDynamicComponents: true,
  enableScopedSlots: true
};
var SFDX_CONFIG_PATH = "sfdx-project.json";
var CACHE = new Map();
function createAuditCommand() {
  return new import_commander.Command("audit").description("Audit the SSR capabilities of components").requiredOption("--components <component...>", '[string] space-separated list of component names to analyze (eg "header footer nav")').option("--namespace <string>", "[string] namespace of the components", "c").option("--depth <number>", "[number] number of levels to analyze", "1").option("--verbose", "[boolean] show tree of all analyzed components", false).action(async (options, cmd) => {
    CACHE.clear();
    const opts = cmd.optsWithGlobals();
    const {components, config, depth: depthStr, namespace: ns, rootDir, verbose} = opts;
    const lwcConfig = getLwcConfig(rootDir, config);
    let depth = parseInt(depthStr);
    if (isNaN(depth) || depth < 1) {
      console.log(import_chalk.default.bgYellow("WARN"), `Depth cannot be ${depthStr}, defaulting to 1`);
      depth = 1;
    }
    const cmpList = components.map((c) => `${ns}/${c}`).join(", ");
    console.log(`\u2728 Auditing SSR capabilities for ${import_chalk.default.bgGray(cmpList)}...`);
    let greatSuccess = true;
    for (const c of components) {
      const info = await analyzeComponentCapabilities(`${ns}/${c}`, rootDir, lwcConfig, depth);
      if (info) {
        const success = print(info, verbose);
        greatSuccess = success && greatSuccess;
      } else {
        greatSuccess = false;
        console.log(import_chalk.default.bgRed("FAIL"), import_chalk.default.bgGray(`${ns}/${c}`), "cannot be found");
      }
    }
    if (!greatSuccess)
      process.exit(1);
  });
}
async function analyzeComponentCapabilities(specifier, rootDir, modules, depth) {
  if (CACHE.has(specifier))
    return CACHE.get(specifier);
  const cmpDir = await getComponentDir(specifier, rootDir, modules);
  if (!cmpDir)
    return void 0;
  const info = {
    specifier,
    ssrCapability: await parseSsrCapability(specifier, cmpDir),
    children: []
  };
  info.children = await analyzeChildren(info, cmpDir, rootDir, modules, depth);
  info && CACHE.set(specifier, info);
  return info;
}
async function getComponentDir(specifier, rootDir, modules) {
  try {
    const s = isSFDX(rootDir) ? specifier.replace(/^c\//, "lwc/") : specifier;
    const {entry} = (0, import_module_resolver.resolveModule)(s, rootDir, {modules, rootDir});
    return import_path.default.dirname(entry);
  } catch (e) {
    if (e.code === "NO_LWC_MODULE_FOUND") {
      return void 0;
    } else {
      throw e;
    }
  }
}
async function parseSsrCapability(specifier, cmpDir) {
  const xml = readFile(import_path.default.join(cmpDir, `${(0, import_shared_utils.explodeSpecifier)(specifier).name}.js-meta.xml`));
  if (!xml) {
    const {namespace = ""} = (0, import_shared_utils.explodeSpecifier)(specifier);
    if (!PLATFORM_NS.includes(namespace)) {
      console.log(import_chalk.default.bgYellow("WARN"), import_chalk.default.bgGray(specifier), "does not have a js-meta.xml file");
      return void 0;
    }
    return CAPABILITY_PRIVATE;
  }
  const metadata = await (0, import_xml2js.parseStringPromise)(xml);
  const capabilities = metadata.LightningComponentBundle?.capabilities;
  const capability = Array.isArray(capabilities) ? capabilities[0].capability : void 0;
  if (Array.isArray(capability)) {
    return capability.includes(CAPABILITY_SSR_ONLY) ? CAPABILITY_SSR_ONLY : capability.includes(CAPABILITY_SSR_HYDRATION) ? CAPABILITY_SSR_HYDRATION : void 0;
  } else if (typeof capability === "string") {
    return capability.startsWith(CAPABILITY_SSR_ONLY) ? capability : void 0;
  }
  return void 0;
}
async function analyzeChildren(info, cmpDir, rootDir, modules, maxDepth = 1, curDepth = 0) {
  const {isLWC, imports} = await parseJsDeps(info.specifier, cmpDir);
  info.isLWC = isLWC;
  if (curDepth === maxDepth)
    return [];
  const htmlDeps = await parseHtmlDeps(info.specifier, cmpDir);
  const children = [];
  for (const d of [...htmlDeps, ...imports]) {
    if (CACHE.has(d)) {
      children.push(CACHE.get(d));
      continue;
    }
    const dir = await getComponentDir(d, rootDir, modules);
    const child = {specifier: d, children: []};
    if (dir) {
      child.ssrCapability = await parseSsrCapability(d, dir);
      child.children = await analyzeChildren(child, dir, rootDir, modules, maxDepth, curDepth + 1);
    } else {
      const {namespace = ""} = (0, import_shared_utils.explodeSpecifier)(d);
      child.ssrCapability = PLATFORM_NS.includes(namespace) ? CAPABILITY_PRIVATE : CAPABILITY_UNKNOWN;
    }
    CACHE.set(d, child);
    children.push(child);
  }
  return children;
}
async function parseHtmlDeps(specifier, cmpDir) {
  const filename = `${(0, import_shared_utils.explodeSpecifier)(specifier).name}.html`;
  const htmlCode = readFile(import_path.default.join(cmpDir, filename));
  if (!htmlCode)
    return [];
  const {namespace, name} = (0, import_shared_utils.explodeSpecifier)(specifier);
  const {code} = (0, import_compiler.transformSync)(htmlCode, filename, {...LWC_TRANSFORM_CONFIG, namespace, name});
  return (await getModuleMetadata(code)).imports;
}
async function parseJsDeps(specifier, cmpDir) {
  let jsCode = readFile(import_path.default.join(cmpDir, `${(0, import_shared_utils.explodeSpecifier)(specifier).name}.js`));
  if (!jsCode) {
    jsCode = readFile(import_path.default.join(cmpDir, `${(0, import_shared_utils.explodeSpecifier)(specifier).name}.ts`));
  }
  return await getModuleMetadata(jsCode);
}
async function getModuleMetadata(code) {
  if (!code)
    return {imports: []};
  const [imps, exports2] = await (0, import_es_module_lexer.parse)(code);
  const isLWC = exports2.some((e) => e.n === "default" && e.ln);
  const imports = imps.map((i) => i.n || code.substring(i.s, i.e)).filter((d) => LWC_REGEX.test(d));
  return {isLWC, imports};
}
function getLwcConfig(rootDir, lwrFile) {
  const absLwrConfigPath = import_path.default.isAbsolute(lwrFile) ? lwrFile : import_path.default.join(rootDir, lwrFile);
  if (import_fs.default.existsSync(absLwrConfigPath)) {
    const {appConfig} = (0, import_config.loadConfig)({rootDir, lwrConfigFile: lwrFile});
    return appConfig.lwc.modules;
  }
  const lwcConfigStr = readFile(import_path.default.join(rootDir, "lwc.config.json"));
  if (lwcConfigStr) {
    const lwcConfig = JSON.parse(lwcConfigStr).modules;
    if (lwcConfig)
      return lwcConfig;
  }
  const sfdxConfigStr = readFile(import_path.default.join(rootDir, SFDX_CONFIG_PATH));
  const modules = [];
  if (sfdxConfigStr) {
    const sfdxConfig = JSON.parse(sfdxConfigStr);
    const pkgDirs = sfdxConfig.packageDirectories || [];
    pkgDirs.forEach((d) => modules.push({dir: import_path.default.join(d.path, "main/default")}));
  }
  const pkgConfigStr = readFile(import_path.default.join(rootDir, "package.json"));
  if (pkgConfigStr) {
    const pkgConfig = JSON.parse(pkgConfigStr).lwc?.modules;
    if (pkgConfig)
      modules.push(...pkgConfig);
  }
  if (!modules.length) {
    console.log(import_chalk.default.bgRed("FAIL"), "LWC config not found in", import_chalk.default.bgGray(rootDir));
    process.exit(1);
  }
  return modules;
}
function readFile(filePath) {
  if (import_fs.default.existsSync(filePath)) {
    return import_fs.default.readFileSync(filePath, "utf8");
  }
}
function isSFDX(rootDir) {
  return import_fs.default.existsSync(import_path.default.join(rootDir, SFDX_CONFIG_PATH));
}
var SUCCESS_MSG = "contains no capability incompatibilities!";
var WARN_MSG = "depends on one or more components which are not available locally and must be analyzed manually:";
var SSR_ERROR_MSG = "has the ServerRenderable capability so it cannot depend on components with no SSR capability or the ServerRenderableWithHydration capability:";
var HYDRATE_ERROR_MSG = "has the ServerRenderableWithHydration capability so it cannot depend on components with no SSR capability:";
var CSR_ONLY = "No SSR capability";
var LIST_SEP = "\n    - ";
function print(info, verbose = false) {
  let success = true;
  const childCaps = {hydrate: new Set(), csr: new Set(), unknown: new Set()};
  groupCapabilitiesByType(childCaps, info);
  if (verbose) {
    const tree = buildTree([info], info.ssrCapability, true);
    tree && console.log("\n", (0, import_object_treeify.default)(tree), "\n");
  }
  if (info.ssrCapability === CAPABILITY_SSR_HYDRATION && childCaps.csr.size) {
    success = false;
    console.log(import_chalk.default.bgRed("FAIL"), import_chalk.default.bgGray(info.specifier), HYDRATE_ERROR_MSG, LIST_SEP + [...childCaps.csr].join(LIST_SEP));
  } else if (info.ssrCapability === CAPABILITY_SSR_ONLY && (childCaps.csr.size || childCaps.hydrate.size)) {
    success = false;
    console.log(import_chalk.default.bgRed("FAIL"), import_chalk.default.bgGray(info.specifier), SSR_ERROR_MSG, LIST_SEP + [...childCaps.csr, ...childCaps.hydrate].join(LIST_SEP));
  } else {
    console.log(import_chalk.default.bgGreen("PASS"), import_chalk.default.bgGray(info.specifier), SUCCESS_MSG);
  }
  if (childCaps.unknown.size) {
    console.log(import_chalk.default.bgYellow("WARN"), import_chalk.default.bgGray(info.specifier), WARN_MSG, LIST_SEP + [...childCaps.unknown].join(LIST_SEP));
  }
  return success;
}
function groupCapabilitiesByType(all, info) {
  for (const c of info.children) {
    if (c.ssrCapability === CAPABILITY_UNKNOWN) {
      all.unknown.add(c.specifier);
    } else if (!c.isLWC) {
      continue;
    } else if (!c.ssrCapability) {
      all.csr.add(c.specifier);
    } else if (c.ssrCapability === CAPABILITY_SSR_HYDRATION) {
      all.hydrate.add(c.specifier);
    }
    groupCapabilitiesByType(all, c);
  }
  return all;
}
function buildTree(info, rootCap, isRoot = false) {
  if (!info.length)
    return null;
  const tree = {};
  for (const i of info) {
    const cap = i.ssrCapability;
    if (cap === CAPABILITY_PRIVATE)
      continue;
    const pass = !rootCap || rootCap === CAPABILITY_SSR_ONLY && cap === CAPABILITY_SSR_ONLY || rootCap === CAPABILITY_SSR_HYDRATION && cap;
    const status = isRoot ? "" : cap === CAPABILITY_UNKNOWN ? import_chalk.default.bgYellow("WARN") : pass ? import_chalk.default.bgGreen("PASS") : !i.isLWC ? import_chalk.default.bgYellow("WARN (non-component module)") : import_chalk.default.bgRed("FAIL");
    tree[`${status} ${import_chalk.default.bgGray(i.specifier)} ${cap || CSR_ONLY}`] = buildTree(i.children, rootCap);
  }
  return tree;
}
