var __create = Object.create;
var __defProp = Object.defineProperty;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __markAsModule = (target) => __defProp(target, "__esModule", {value: true});
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, {get: all[name], enumerable: true});
};
var __exportStar = (target, module2, desc) => {
  if (module2 && typeof module2 === "object" || typeof module2 === "function") {
    for (let key of __getOwnPropNames(module2))
      if (!__hasOwnProp.call(target, key) && key !== "default")
        __defProp(target, key, {get: () => module2[key], enumerable: !(desc = __getOwnPropDesc(module2, key)) || desc.enumerable});
  }
  return target;
};
var __toModule = (module2) => {
  return __exportStar(__markAsModule(__defProp(module2 != null ? __create(__getProtoOf(module2)) : {}, "default", module2 && module2.__esModule && "default" in module2 ? {get: () => module2.default, enumerable: true} : {value: module2, enumerable: true})), module2);
};

// packages/lwr/src/cli/commands/cli.ts
__markAsModule(exports);
__export(exports, {
  createCLI: () => createCLI
});
var import_commander = __toModule(require("commander"));
var import_audit = __toModule(require("./audit.cjs"));
var import_build = __toModule(require("./build.cjs"));
var import_dev = __toModule(require("./dev.cjs"));
var import_preview = __toModule(require("./preview.cjs"));
var import_getVersion = __toModule(require("../utils/getVersion.cjs"));
var import_mrt_dev = __toModule(require("./mrt-dev.cjs"));
var import_mrt_package = __toModule(require("./mrt-package.cjs"));
function createCLI() {
  const cli = new import_commander.Command("lwr");
  cli.description("LWR command line");
  cli.addOption(new import_commander.Option("-c, --config <file>", `[string] use specified lwr.config.json file`).default("lwr.config.json")).addOption(new import_commander.Option("--rootDir <directory>", `[string] use specified root directory`).default(process.cwd(), '"."')).addOption(new import_commander.Option("--logLevel <level>", `[string] use specified log level`).env("LWR_LOG_LEVEL").choices(["debug", "verbose", "info", "warn", "error", "silent"]).default("info")).addOption(new import_commander.Option("--silent", `Enables silent logging which runs the server without any console output`).implies({logLevel: "silent"})).addOption(new import_commander.Option("--verbose", `Enables verbose logging for debugging server issues`).implies({
    logLevel: "verbose"
  }));
  cli.addCommand((0, import_dev.createDevCommand)());
  cli.addCommand((0, import_build.createBuildCommand)());
  cli.addCommand((0, import_preview.createPreviewCommand)());
  cli.addCommand((0, import_audit.createAuditCommand)());
  cli.addCommand((0, import_mrt_dev.createExperimentalMrtDevCommand)());
  cli.addCommand((0, import_mrt_package.createExperimentalMrtPackageCommand)());
  cli.showHelpAfterError();
  cli.version((0, import_getVersion.getVersion)());
  return cli;
}
