var __create = Object.create;
var __defProp = Object.defineProperty;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __markAsModule = (target) => __defProp(target, "__esModule", {value: true});
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, {get: all[name], enumerable: true});
};
var __exportStar = (target, module2, desc) => {
  if (module2 && typeof module2 === "object" || typeof module2 === "function") {
    for (let key of __getOwnPropNames(module2))
      if (!__hasOwnProp.call(target, key) && key !== "default")
        __defProp(target, key, {get: () => module2[key], enumerable: !(desc = __getOwnPropDesc(module2, key)) || desc.enumerable});
  }
  return target;
};
var __toModule = (module2) => {
  return __exportStar(__markAsModule(__defProp(module2 != null ? __create(__getProtoOf(module2)) : {}, "default", module2 && module2.__esModule && "default" in module2 ? {get: () => module2.default, enumerable: true} : {value: module2, enumerable: true})), module2);
};

// packages/lwr/src/cli/utils.ts
__markAsModule(exports);
__export(exports, {
  getAuthTokenOption: () => getAuthTokenOption,
  getBasePath: () => getBasePath,
  getModeOption: () => getModeOption,
  getPortOption: () => getPortOption,
  getSiteDirOption: () => getSiteDirOption,
  getSiteZipOption: () => getSiteZipOption,
  getSsrTimeoutOption: () => getSsrTimeoutOption,
  getTargetOption: () => getTargetOption,
  parseNumArg: () => parseNumArg
});
var import_commander = __toModule(require("commander"));
function getTargetOption() {
  return new import_commander.Option("-t, --target <target>", "[string] configured target for deployment").choices(["default", "mrt", "netlify"]).default("default");
}
function getSsrTimeoutOption() {
  return new import_commander.Option("--timeout [number]", `Set an ssr timeout in ms. If not specified, SSR requests will never timeout.`).env("SSR_TIMEOUT").argParser(parseNumArg);
}
function getPortOption() {
  return new import_commander.Option("-p, --port <number>", `[number] set port`).env("PORT").argParser(parseNumArg);
}
function getSiteDirOption() {
  return new import_commander.Option("--siteDir <path>", `[path] top level path to a directory where an unpacked experience site lives. If specified in conjunction with --siteZip, the site will be extracted to a child directory named 'app' within this folder.`);
}
function getSiteZipOption() {
  return new import_commander.Option("--siteZip <file>", `[file] specify the path to an experience site zip file to extract during local development setup. Will be extracted to a folder named 'app' within the specified 'siteDir'`);
}
function getModeOption() {
  return new import_commander.Option("-m, --mode <mode>", "[string] server mode").env("MODE").choices(["dev", "compat", "prod-compat", "prod"]);
}
function getAuthTokenOption() {
  return new import_commander.Option("--authToken <token>", `[string] set the auth token to be used when fetching data from Salesforce`).env("AUTH_TOKEN");
}
function getBasePath() {
  return new import_commander.Option("--basePath <path>", `[string] set the basepath to use for the app`).env("BASE_PATH");
}
function parseNumArg(value) {
  const parsedValue = parseInt(value, 10);
  if (isNaN(parsedValue)) {
    throw new import_commander.InvalidArgumentError("Not a number.");
  }
  return parsedValue;
}
