import { Command } from 'commander';
import { logger } from '@lwrjs/diagnostics';
import { build } from '@lwrjs/api';
import { getModeOption, getTargetOption } from '../utils.js';
export function createBuildCommand() {
    return new Command('build')
        .description('Build an LWR application')
        .addOption(getTargetOption())
        .addOption(getModeOption().choices(['prod', 'prod-compat']))
        .option('-o, --output <directory>', `[string] output directory`)
        .option('--clean', `[boolean] delete the output directory`, false)
        .option('-r, --routes <routes...>', `routes`)
        .option('-m, --modules <modules...>', `modules`)
        .option('-l, --locales <locales...>', `locales`)
        .option('--minify', '[boolean] minifies build output', false)
        .action(async (options, cmd) => {
        logger.info({ label: `build`, message: `Building lwr application` });
        const { rootDir, config, output, mode, clean, target, minify, routes, modules, locales, logLevel, } = cmd.optsWithGlobals();
        await build({
            logLevel,
            output,
            rootDir,
            config,
            target,
            clean,
            locales,
            routes,
            modules,
            mode,
            minify,
        });
    });
}
//# sourceMappingURL=build.js.map