import { Command, Option } from 'commander';
import { createAuditCommand } from './audit.js';
import { createBuildCommand } from './build.js';
import { createDevCommand } from './dev.js';
import { createPreviewCommand } from './preview.js';
import { getVersion } from '../utils/getVersion.js';
import { createExperimentalMrtDevCommand } from './mrt-dev.js';
import { createExperimentalMrtPackageCommand } from './mrt-package.js';
export function createCLI() {
    const cli = new Command('lwr');
    cli.description('LWR command line');
    cli.addOption(new Option('-c, --config <file>', `[string] use specified lwr.config.json file`).default('lwr.config.json'))
        .addOption(new Option('--rootDir <directory>', `[string] use specified root directory`).default(process.cwd(), '"."'))
        .addOption(new Option('--logLevel <level>', `[string] use specified log level`)
        .env('LWR_LOG_LEVEL')
        .choices(['debug', 'verbose', 'info', 'warn', 'error', 'silent'])
        .default('info'))
        .addOption(new Option('--silent', `Enables silent logging which runs the server without any console output`).implies({ logLevel: 'silent' }))
        .addOption(new Option('--verbose', `Enables verbose logging for debugging server issues`).implies({
        logLevel: 'verbose',
    }));
    cli.addCommand(createDevCommand());
    cli.addCommand(createBuildCommand());
    cli.addCommand(createPreviewCommand());
    cli.addCommand(createAuditCommand());
    cli.addCommand(createExperimentalMrtDevCommand());
    cli.addCommand(createExperimentalMrtPackageCommand());
    cli.showHelpAfterError();
    cli.version(getVersion());
    return cli;
}
//# sourceMappingURL=cli.js.map