import { Command } from 'commander';
import { getBasePath, getModeOption, getPortOption } from '../utils.js';
import { dev } from '@lwrjs/api';
export function createDevCommand() {
    return new Command('dev')
        .description('Starts an LWR server (defaults to dev mode)')
        .addOption(getPortOption())
        .addOption(getBasePath())
        .addOption(getModeOption().default('dev'))
        .option('-o, --open', `[boolean] open browser on startup`, false)
        .action(async (options, cmd) => {
        const { port, mode, rootDir, basePath, config, open, logLevel } = cmd.optsWithGlobals();
        await dev({ rootDir, port, mode, config, basePath, open, logLevel });
    });
}
//# sourceMappingURL=dev.js.map